/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.component.command.builtin;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdRuntimeException;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.OlapBuilderUnloadEntityContext;
import crazydev.iccube.builder.errors.OlapBuilderError;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.olap.component.command.builtin.OlapEngineAbstractLoadParams;
import crazydev.iccube.olap.component.command.builtin.OlapEngineUnloadEntityParams;
import crazydev.iccube.olap.component.command.builtin.OlapSchemaHelper;
import crazydev.iccube.olap.component.command.builtin.OlapSchemaLifeCycleStatus;
import crazydev.iccube.olap.component.command.builtin.OlapSchemaLoadStatus;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import java.io.Serializable;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class OlapUnloadEntityHelper<ENTITY_CTXT extends OlapBuilderUnloadEntityContext, ENTITY_PARAMS extends OlapEngineUnloadEntityParams>
extends OlapSchemaHelper {
    protected final Logger schemaLogger;

    public OlapUnloadEntityHelper(OlapEngineRequestContext olapEngineRequestContext) {
        super(olapEngineRequestContext);
        this.schemaLogger = olapEngineRequestContext.getLoggers().schema();
    }

    public OlapSchemaLifeCycleStatus unloadEntity(ENTITY_PARAMS params) {
        OlapSchema loadedSchema;
        boolean restoring = ((OlapEngineUnloadEntityParams)params).isRestoreActivated();
        String schemaName = ((OlapEngineUnloadEntityParams)params).getSchemaName();
        if (!restoring) {
            loadedSchema = this.getExistingSchemaForRead(schemaName);
        } else {
            OlapSchema restoringSchema = ((OlapEngineUnloadEntityParams)params).getRestoringSchema();
            if (restoringSchema == null) {
                throw new RuntimeException("internal error: missing restoring schema");
            }
            loadedSchema = restoringSchema;
        }
        OlapSchemaLifeCycleStatus status = this.unloadMultiPhase(params, loadedSchema);
        return status;
    }

    private OlapSchemaLifeCycleStatus unloadMultiPhase(ENTITY_PARAMS params, OlapSchema loadedSchema) {
        OlapBuilderUnloadEntityContext eContext = this.olapEngineRequestContext.getOrCreateUnloadEntityContext(((OlapEngineUnloadEntityParams)params).getMode());
        if (eContext.getCurrentTask() == 1) {
            OlapSchemaLifeCycleStatus status = this.unloadPhaseI(eContext, params, loadedSchema);
            this.olapEngineRequestContext.setLoadedSchemaStatusPhaseI(status);
            this.olapEngineRequestContext.freezeTaskExecutorForSchema(loadedSchema.getName(), ((OlapEngineAbstractLoadParams)params).getWaitS(), ((OlapEngineAbstractLoadParams)params).getCancelS());
            return status;
        }
        if (eContext.getCurrentTask() == 2) {
            OlapSchemaLifeCycleStatus statusPhaseI = this.olapEngineRequestContext.getLoadedSchemaStatusPhaseI();
            if (statusPhaseI == null) {
                throw new RuntimeException("internal error: missing " + eContext.commandForLogsAndErrors() + " [" + ((OlapEngineUnloadEntityParams)params).getSchemaName() + "] PHASE-I status");
            }
            OlapSchemaLifeCycleStatus status = this.unloadPhaseII_(params, loadedSchema, eContext, statusPhaseI);
            return status;
        }
        throw new RuntimeException("internal error: inconsistent " + eContext.commandForLogsAndErrors() + " processing");
    }

    private OlapSchemaLifeCycleStatus unloadPhaseII_(ENTITY_PARAMS params, OlapSchema loadedSchema, ENTITY_CTXT eContext, OlapSchemaLifeCycleStatus statusPhaseI) {
        OlapSchemaLoadStatus loadStatusPhaseI = statusPhaseI.getLoadStatus();
        OlapSchemaLifeCycleStatus status = loadStatusPhaseI == OlapSchemaLoadStatus.PARTITIONS_UNLOADED ? this.unloadPhaseII(eContext, params, loadedSchema) : statusPhaseI;
        OlapBuilderContext context = this.olapEngineRequestContext.getBuilderContext_();
        if (context != null) {
            OlapSchemaLoadStatus loadStatus = status.getLoadStatus();
            boolean succeeded = loadStatus == OlapSchemaLoadStatus.PARTITIONS_UNLOADED;
            context.onSchemaCompletedPhaseII(succeeded);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OlapSchemaLifeCycleStatus unloadPhaseI(ENTITY_CTXT eContext, ENTITY_PARAMS params, OlapSchema loadedSchema) {
        String schemaName = loadedSchema.getName();
        try {
            if (this.schemaLogger.isInfoEnabled()) {
                this.schemaLogger.info((Object)("[schema] " + ((OlapBuilderUnloadEntityContext)eContext).commandForLogsAndErrors() + " (PHASE I) started " + String.valueOf(params)));
            }
            OlapBuilderContext context = this.createBuilderContext(params, loadedSchema);
            this.olapEngineRequestContext.setBuilderContext(context);
            this.unsafeUnloadPhaseI(eContext, params, context, loadedSchema);
            OlapSchemaLifeCycleStatus olapSchemaLifeCycleStatus = new OlapSchemaLifeCycleStatus(schemaName, OlapSchemaLoadStatus.PARTITIONS_UNLOADED);
            return olapSchemaLifeCycleStatus;
        }
        catch (RuntimeException ex) {
            Object error = ex instanceof CdRuntimeException ? ((CdRuntimeException)((Object)ex)).getError() : new OlapBuilderError(OlapBuilderErrorCode.LOAD_PARTITIONS_ERROR, new Serializable[]{ex.getMessage()});
            OlapSchemaLifeCycleStatus olapSchemaLifeCycleStatus = this.reportError(OlapSchemaLoadStatus.PARTITIONS_LOAD_FAILED, loadedSchema, ((OlapBuilderUnloadEntityContext)eContext).commandForLogsAndErrors() + " (PHASE I) error [" + schemaName + "]", ex, (CdError)error);
            return olapSchemaLifeCycleStatus;
        }
        finally {
            if (this.schemaLogger.isInfoEnabled()) {
                this.schemaLogger.info((Object)("[schema] " + ((OlapBuilderUnloadEntityContext)eContext).commandForLogsAndErrors() + " (PHASE I) done [" + schemaName + "]"));
            }
        }
    }

    protected abstract OlapBuilderContext createBuilderContext(ENTITY_PARAMS var1, OlapSchema var2);

    protected abstract void unsafeUnloadPhaseI(ENTITY_CTXT var1, ENTITY_PARAMS var2, OlapBuilderContext var3, OlapSchema var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OlapSchemaLifeCycleStatus unloadPhaseII(ENTITY_CTXT eContext, ENTITY_PARAMS params, OlapSchema loadedSchema) {
        String schemaName = loadedSchema.getName();
        try {
            if (this.schemaLogger.isInfoEnabled()) {
                this.schemaLogger.info((Object)("[schema] " + ((OlapBuilderUnloadEntityContext)eContext).commandForLogsAndErrors() + " (PHASE II) started [" + schemaName + "]"));
            }
            this.unsafeUnloadPhaseII(eContext, params, loadedSchema);
            this.olapEngine.unloadPartitions(this.olapEngineRequestContext, loadedSchema, ((OlapBuilderUnloadEntityContext)eContext).getUnloadPartitionsInfo(loadedSchema));
            OlapSchemaLifeCycleStatus olapSchemaLifeCycleStatus = new OlapSchemaLifeCycleStatus(schemaName, OlapSchemaLoadStatus.PARTITIONS_UNLOADED);
            return olapSchemaLifeCycleStatus;
        }
        catch (RuntimeException ex) {
            Object error = ex instanceof CdRuntimeException ? ((CdRuntimeException)((Object)ex)).getError() : new OlapBuilderError(OlapBuilderErrorCode.LOAD_PARTITIONS_ERROR, new Serializable[]{ex.getMessage()});
            OlapSchemaLifeCycleStatus olapSchemaLifeCycleStatus = this.reportError(OlapSchemaLoadStatus.PARTITIONS_LOAD_ERROR, loadedSchema, ((OlapBuilderUnloadEntityContext)eContext).commandForLogsAndErrors() + " (PHASE II) error [" + schemaName + "]", ex, (CdError)error);
            return olapSchemaLifeCycleStatus;
        }
        finally {
            if (this.schemaLogger.isInfoEnabled()) {
                this.schemaLogger.info((Object)(((OlapBuilderUnloadEntityContext)eContext).commandForLogsAndErrors() + " (PHASE II) done [" + schemaName + "]"));
            }
        }
    }

    protected abstract void unsafeUnloadPhaseII(ENTITY_CTXT var1, ENTITY_PARAMS var2, OlapSchema var3);

    protected OlapSchemaLifeCycleStatus reportError(OlapSchemaLoadStatus status, OlapSchema schema, String logMessage, @Nullable Throwable logMessageThrowable, CdError errorToReport) {
        OlapLoggers.COMMAND.warn((Object)logMessage, logMessageThrowable);
        IcCubeRequestStatusManager statusManager = this.olapEngineRequestContext.getRequestStatusManager();
        statusManager.onRequestError(this.getRequestUuid(), errorToReport);
        if (status == OlapSchemaLoadStatus.PARTITIONS_LOAD_ERROR) {
            this.olapEngine.loadPartitionsError(this.olapEngineRequestContext, schema);
        }
        return new OlapSchemaLifeCycleStatus(schema.getName(), status);
    }
}

