/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.component.command.builtin;

import crazydev.iccube.authorization.permissions.role.OlapRolePermissions;
import crazydev.iccube.cluster.master.local.M_LocalCluster;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.request.task.IcCubeSchemaAccessLockMode;
import org.jetbrains.annotations.Nullable;

public abstract class OlapSchemaHelper {
    protected final OlapEngineRequestContext olapEngineRequestContext;
    protected final OlapEngineComponent olapEngine;

    public OlapSchemaHelper(OlapEngineRequestContext olapEngineRequestContext) {
        this.olapEngineRequestContext = olapEngineRequestContext;
        this.olapEngine = olapEngineRequestContext.getOlapEngineComponent();
    }

    protected M_LocalCluster getCluster() {
        return this.olapEngineRequestContext.getCluster();
    }

    protected String getRequestUuid() {
        return this.olapEngineRequestContext.getRequestClientUUID();
    }

    @Nullable
    protected OlapSchema getSchema(IcCubeSchemaAccessLockMode mode, String name) {
        OlapRolePermissions elevated = this.olapEngineRequestContext.elevateForBuilderPermissions();
        return this.olapEngine.getAuthorizedSchema(this.olapEngineRequestContext, elevated.getSchemasPermissions(), mode, name);
    }

    protected OlapSchema getExistingSchemaForRead(String name) {
        OlapSchema schema = this.getSchema(IcCubeSchemaAccessLockMode.READ, name);
        if (schema == null) {
            throw new RuntimeException("internal error: missing schema (" + name + ")");
        }
        return schema;
    }
}

