/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.component.command.builtin;

import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationPermissions;
import crazydev.iccube.authorization.permissions.role.OlapRolePermissions;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.OlapBuilderSchemaMain;
import crazydev.iccube.builder.errors.OlapBuilderError;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderIncrLoadLimitNotAuthException;
import crazydev.iccube.builder.errors.OlapBuilderIncrLoadNotAuthException;
import crazydev.iccube.builder.factory.schema.IOlapBuilderSchemaDefFactory;
import crazydev.iccube.contextual.OlapContextualBigException;
import crazydev.iccube.olap.component.command.builtin.IOlapEngineLoadSchemaParams;
import crazydev.iccube.olap.component.command.builtin.OlapEngineOfflineMode;
import crazydev.iccube.olap.component.command.builtin.OlapSchemaHelper;
import crazydev.iccube.olap.component.command.builtin.OlapSchemaLifeCycleStatus;
import crazydev.iccube.olap.component.command.builtin.OlapSchemaLoadStatus;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.entity.permissions.IOlapSchemasPermission;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaIncrLoadInfo;
import crazydev.iccube.olap.schema.localization.OlapSchemaLocalization;
import crazydev.iccube.olap.util.OlapOOM;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import crazydev.iccube.request.task.IcCubeSchemaAccessLockMode;
import java.io.File;
import java.io.Serializable;
import org.apache.log4j.Logger;

public class OlapLoadSchemaHelper
extends OlapSchemaHelper {
    private final Logger schemaLogger;

    public OlapLoadSchemaHelper(OlapEngineRequestContext olapEngineRequestContext) {
        super(olapEngineRequestContext);
        this.schemaLogger = olapEngineRequestContext.getLoggers().schema();
    }

    public boolean unloadSchema(String schemaName, int waitS, int cancelS) {
        this.olapEngineRequestContext.onDetailAdded("Schema : " + schemaName, "Unloading");
        if (this.olapEngineRequestContext.getLoadSchemaTask() == 0) {
            if (this.schemaLogger.isInfoEnabled()) {
                this.schemaLogger.info((Object)("[schema] UNLOAD_SCHEMA (PHASE I) started [" + schemaName + "]"));
            }
            OlapSchemaLifeCycleStatus status = new OlapSchemaLifeCycleStatus(schemaName, OlapSchemaLoadStatus.UNLOADED);
            this.olapEngineRequestContext.setLoadedSchemaStatusPhaseI(status);
            this.olapEngineRequestContext.freezeTaskExecutorForSchema(schemaName, waitS, cancelS);
            return true;
        }
        if (this.schemaLogger.isInfoEnabled()) {
            this.schemaLogger.info((Object)("[schema] UNLOAD_SCHEMA (PHASE II) started [" + schemaName + "]"));
        }
        boolean unloaded = this.olapEngine.unloadSchema(this.olapEngineRequestContext, schemaName);
        return unloaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OlapSchemaLifeCycleStatus loadSchema(IOlapEngineLoadSchemaParams params) {
        if (this.olapEngineRequestContext.isMissing()) {
            return new OlapSchemaLifeCycleStatus("icCube's Missing", OlapSchemaLoadStatus.LOADED);
        }
        try {
            this.olapEngineRequestContext.onProgressPhase("loadSchemaStarted", new Serializable[0]);
            this.olapEngineRequestContext.setupBuilderLoadExecutors(false);
            OlapSchemaLifeCycleStatus status = this.loadSchemaMultiTasks(params);
            IcCubeRequestStatusManager statusManager = this.olapEngineRequestContext.getRequestStatusManager();
            statusManager.onRequestLoadSchemaStatus(this.getRequestUuid(), status);
            OlapSchemaLifeCycleStatus olapSchemaLifeCycleStatus = status;
            return olapSchemaLifeCycleStatus;
        }
        finally {
            this.olapEngineRequestContext.releaseBuilderLoadExecutors(false);
        }
    }

    private OlapSchemaLifeCycleStatus loadSchemaMultiTasks(IOlapEngineLoadSchemaParams params) {
        if (OlapOOM.oom) {
            throw new RuntimeException("load schema disabled on out-of-memory error");
        }
        File factoryFile = params.getSchemaFactoryFile();
        IcCubeRequestStatusManager statusManager = this.olapEngineRequestContext.getRequestStatusManager();
        statusManager.onRequestAttachedToSchemaDefFactory(this.getRequestUuid(), factoryFile);
        IOlapBuilderSchemaDefFactory factory = this.olapEngineRequestContext.getOrCreateSchemaFactoryForLoad(factoryFile);
        String schemaName = factory.getSchemaName();
        if (this.olapEngineRequestContext.getLoadSchemaTask() == 0) {
            if (this.schemaLogger.isInfoEnabled()) {
                this.schemaLogger.info((Object)("[schema] LOAD_SCHEMA (multi-phases) started [" + schemaName + "] [" + factoryFile.getAbsolutePath() + "]"));
            }
            this.loadSchemaPhaseI(params, factory);
            this.olapEngineRequestContext.freezeTaskExecutorForSchema(schemaName, params.getWaitS(), params.getCancelS());
            OlapSchemaLifeCycleStatus status = this.olapEngineRequestContext.getLoadedSchemaStatusPhaseI();
            return status;
        }
        OlapSchemaLifeCycleStatus statusPhaseI = this.olapEngineRequestContext.getLoadedSchemaStatusPhaseI();
        if (statusPhaseI == null) {
            throw new RuntimeException("internal error: missing load schema [" + schemaName + "] phase I status");
        }
        OlapSchemaLifeCycleStatus status = this.loadSchemaPhaseII_(params, factory, statusPhaseI);
        return status;
    }

    private OlapSchemaLifeCycleStatus loadSchemaPhaseII_(IOlapEngineLoadSchemaParams params, IOlapBuilderSchemaDefFactory factory, OlapSchemaLifeCycleStatus statusPhaseI) {
        OlapSchemaLoadStatus loadStatusPhaseI = statusPhaseI.getLoadStatus();
        OlapSchemaLifeCycleStatus status = loadStatusPhaseI == OlapSchemaLoadStatus.LOADED || loadStatusPhaseI == OlapSchemaLoadStatus.INCREMENTAL_LOADED ? this.loadSchemaPhaseII(params, factory) : statusPhaseI;
        OlapBuilderContext context = this.olapEngineRequestContext.getBuilderContext_();
        if (context != null) {
            OlapSchemaLoadStatus loadStatus = status.getLoadStatus();
            boolean succeeded = loadStatus == OlapSchemaLoadStatus.LOADED || loadStatus == OlapSchemaLoadStatus.INCREMENTAL_LOADED;
            context.onSchemaCompletedPhaseII(succeeded);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSchemaPhaseI(IOlapEngineLoadSchemaParams params, IOlapBuilderSchemaDefFactory factory) {
        String schemaName = factory.getSchemaName();
        File factoryFile = params.getSchemaFactoryFile();
        try {
            String ts;
            if (this.schemaLogger.isInfoEnabled()) {
                this.schemaLogger.info((Object)("[schema] LOAD_SCHEMA (PHASE I) started [" + schemaName + "]"));
            }
            if ((ts = params.getRestoreTimestamp()) != null) {
                this.olapEngineRequestContext.onDetailAdded("Schema : " + schemaName, "Restoring the activity " + ts);
            } else {
                this.olapEngineRequestContext.onDetailAdded("Schema : " + schemaName, "Loading " + factoryFile.getAbsolutePath());
            }
            this.unsafeLoadSchemaPhaseI(params, factory);
        }
        catch (IncrLoadLimitAuthException ex) {
            OlapLoggers.COMMAND.warn((Object)("LOAD SCHEMA  (PHASE I) recoverable incr-load not authorized : limit exceeded [" + schemaName + "]"));
            OlapBuilderError error = new OlapBuilderError(OlapBuilderErrorCode.INCR_LOAD_LIMIT_NOT_AUTH, new Serializable[0]);
            IcCubeRequestStatusManager statusManager = this.olapEngineRequestContext.getRequestStatusManager();
            statusManager.onRequestError(this.getRequestUuid(), error);
            this.olapEngineRequestContext.setLoadedSchemaStatusPhaseI(new OlapSchemaLifeCycleStatus(schemaName, OlapSchemaLoadStatus.INCREMENTAL_LOAD_ERROR));
        }
        catch (IncrLoadAuthException ex) {
            OlapLoggers.COMMAND.warn((Object)("LOAD SCHEMA (PHASE I) recoverable incr-load not authorized [" + schemaName + "]"));
            OlapBuilderError error = new OlapBuilderError(OlapBuilderErrorCode.INCR_LOAD_NOT_AUTH, new Serializable[0]);
            IcCubeRequestStatusManager statusManager = this.olapEngineRequestContext.getRequestStatusManager();
            statusManager.onRequestError(this.getRequestUuid(), error);
            this.olapEngineRequestContext.setLoadedSchemaStatusPhaseI(new OlapSchemaLifeCycleStatus(schemaName, OlapSchemaLoadStatus.INCREMENTAL_LOAD_ERROR));
        }
        catch (IncrLoadException ex) {
            IcCubeRequestStatusManager statusManager = this.olapEngineRequestContext.getRequestStatusManager();
            statusManager.onRequestErrors(this.getRequestUuid(), ex.cause.getErrors());
            this.olapEngineRequestContext.setLoadedSchemaStatusPhaseI(new OlapSchemaLifeCycleStatus(schemaName, OlapSchemaLoadStatus.INCREMENTAL_LOAD_ERROR));
        }
        catch (IncrLoadUnexpectedException ex) {
            OlapLoggers.COMMAND.warn((Object)("load schema (PHASE I) recoverable incr-load unexpected error [" + schemaName + "] "), (Throwable)ex.cause);
            OlapBuilderError unexpected = new OlapBuilderError(OlapBuilderErrorCode.UNEXPECTED_ERROR, ex.cause);
            IcCubeRequestStatusManager statusManager = this.olapEngineRequestContext.getRequestStatusManager();
            statusManager.onRequestError(this.getRequestUuid(), unexpected);
            this.olapEngineRequestContext.setLoadedSchemaStatusPhaseI(new OlapSchemaLifeCycleStatus(schemaName, OlapSchemaLoadStatus.INCREMENTAL_LOAD_ERROR));
        }
        catch (FullLoadException ex) {
            IcCubeRequestStatusManager statusManager = this.olapEngineRequestContext.getRequestStatusManager();
            statusManager.onRequestErrors(this.getRequestUuid(), ex.cause.getErrors());
            OlapSchemaLifeCycleStatus status = new OlapSchemaLifeCycleStatus(schemaName, OlapSchemaLoadStatus.LOAD_ERROR);
            this.olapEngineRequestContext.setLoadedSchemaStatusPhaseI(status);
        }
        catch (FullLoadUnexpectedException ex) {
            OlapLoggers.COMMAND.warn((Object)("LOAD SCHEMA (PHASE I) full-load unexpected error [" + schemaName + "] "), (Throwable)ex.cause);
            OlapBuilderError unexpected = new OlapBuilderError(OlapBuilderErrorCode.UNEXPECTED_ERROR, ex.cause);
            IcCubeRequestStatusManager statusManager = this.olapEngineRequestContext.getRequestStatusManager();
            statusManager.onRequestError(this.getRequestUuid(), unexpected);
            OlapSchemaLifeCycleStatus status = new OlapSchemaLifeCycleStatus(schemaName, OlapSchemaLoadStatus.LOAD_ERROR);
            this.olapEngineRequestContext.setLoadedSchemaStatusPhaseI(status);
        }
        finally {
            if (this.schemaLogger.isInfoEnabled()) {
                this.schemaLogger.info((Object)("[schema] LOAD_SCHEMA (PHASE I) done [" + schemaName + "]"));
            }
        }
    }

    private void unsafeLoadSchemaPhaseI(IOlapEngineLoadSchemaParams params, IOlapBuilderSchemaDefFactory factory) throws FullLoadUnexpectedException, FullLoadException, IncrLoadUnexpectedException, IncrLoadLimitAuthException, IncrLoadAuthException, IncrLoadException {
        String schemaName = factory.getSchemaName();
        boolean hasSchema = this.hasSchemaWithIncrementalActive(params, schemaName);
        if (!params.isExplicitFullLoad() && hasSchema) {
            this.unsafeIncrLoadSchemaPhaseI(params, factory, schemaName);
        } else {
            this.unsafeFullLoadPhaseI(params, factory, schemaName);
        }
    }

    private void unsafeFullLoadPhaseI(IOlapEngineLoadSchemaParams params, IOlapBuilderSchemaDefFactory factory, String schemaName) throws FullLoadUnexpectedException, FullLoadException {
        try {
            if (this.schemaLogger.isInfoEnabled()) {
                this.schemaLogger.info((Object)("[schema] LOAD_SCHEMA (PHASE I) full-load started [" + factory.getSchemaName() + "]"));
            }
            OlapSchema schema = OlapBuilderSchemaMain.create(this.olapEngineRequestContext, params, this.olapEngine.getProperties(), this.olapEngine.getFunctionRepository(), false, factory);
            Logger logger = this.olapEngineRequestContext.getLoggers().builder();
            OlapLoadSchemaHelper.setupSchemaLocalization(logger, schema);
            OlapSchemaLifeCycleStatus status = new OlapSchemaLifeCycleStatus(schemaName, OlapSchemaLoadStatus.LOADED);
            this.olapEngineRequestContext.setLoadedSchemaPhaseI(schema);
            this.olapEngineRequestContext.setLoadedSchemaStatusPhaseI(status);
        }
        catch (OlapContextualBigException ex) {
            throw new FullLoadException(ex);
        }
        catch (RuntimeException ex) {
            throw new FullLoadUnexpectedException(ex);
        }
    }

    public static void setupSchemaLocalization(Logger logger, OlapSchema schema) {
        try {
            OlapSchemaLocalization localization = schema.getLocalization();
            if (logger.isInfoEnabled()) {
                logger.info((Object)("[schema] schema [" + schema.getName() + "] localization post-processing started"));
            }
            localization.resolveLocalisationKeys(logger, schema);
        }
        finally {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("[schema] schema [" + schema.getName() + "] localization post-processing done"));
            }
        }
    }

    private void unsafeIncrLoadSchemaPhaseI(IOlapEngineLoadSchemaParams params, IOlapBuilderSchemaDefFactory factory, String schemaName) throws IncrLoadUnexpectedException, IncrLoadLimitAuthException, IncrLoadAuthException, IncrLoadException {
        try {
            OlapSchema loadedSchema;
            if (this.schemaLogger.isInfoEnabled()) {
                this.schemaLogger.info((Object)("[schema] LOAD_SCHEMA (PHASE I)  incr-load started [" + factory.getSchemaName() + "]"));
            }
            if ((loadedSchema = params.isRestoreActivated() && params.getRestoringSchema() != null ? params.getRestoringSchema() : this.getSchema(IcCubeSchemaAccessLockMode.READ, schemaName)) == null) {
                throw new RuntimeException("internal error: missing schema (" + schemaName + ")");
            }
            OlapBuilderContext context = OlapBuilderSchemaMain.incrementalLoadPhaseI(this.olapEngineRequestContext, params, loadedSchema);
            if (context == null) {
                this.schemaLogger.error((Object)("[schema] LOAD_SCHEMA (PHASE I)  incr-load de-activated due to previous incr-load on-error [" + factory.getSchemaName() + "]"));
                this.olapEngineRequestContext.onDetailAdded("Load Info.", "Nothing done (incremental load deactivated due to previous error).");
                OlapSchemaLifeCycleStatus status = new OlapSchemaLifeCycleStatus(schemaName, OlapSchemaLoadStatus.INCREMENTAL_LOAD_DEACTIVATED);
                this.olapEngineRequestContext.setIncrLoadedBuilderContextPhaseI(context);
                this.olapEngineRequestContext.setLoadedSchemaStatusPhaseI(status);
            } else {
                OlapSchemaLifeCycleStatus status = new OlapSchemaLifeCycleStatus(schemaName, OlapSchemaLoadStatus.INCREMENTAL_LOADED);
                this.olapEngineRequestContext.setIncrLoadedBuilderContextPhaseI(context);
                this.olapEngineRequestContext.setLoadedSchemaStatusPhaseI(status);
            }
        }
        catch (OlapBuilderIncrLoadLimitNotAuthException ex) {
            throw new IncrLoadLimitAuthException(ex);
        }
        catch (OlapBuilderIncrLoadNotAuthException ex) {
            throw new IncrLoadAuthException(ex);
        }
        catch (OlapContextualBigException ex) {
            throw new IncrLoadException(ex);
        }
        catch (RuntimeException ex) {
            throw new IncrLoadUnexpectedException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OlapSchemaLifeCycleStatus loadSchemaPhaseII(IOlapEngineLoadSchemaParams params, IOlapBuilderSchemaDefFactory factory) {
        String schemaName = factory.getSchemaName();
        try {
            if (this.schemaLogger.isInfoEnabled()) {
                this.schemaLogger.info((Object)("[schema] LOAD_SCHEMA (PHASE II) started [" + schemaName + "]"));
            }
            OlapSchemaLifeCycleStatus olapSchemaLifeCycleStatus = this.unsafeLoadSchemaPhaseII(params, factory);
            return olapSchemaLifeCycleStatus;
        }
        catch (FullLoadUnexpectedException ex) {
            OlapLoggers.COMMAND.warn((Object)("LOAD SCHEMA (PHASE II) full-load unexpected error [" + schemaName + "] "), (Throwable)ex.cause);
            OlapBuilderError unexpected = new OlapBuilderError(OlapBuilderErrorCode.UNEXPECTED_ERROR, ex.cause);
            IcCubeRequestStatusManager statusManager = this.olapEngineRequestContext.getRequestStatusManager();
            statusManager.onRequestError(this.getRequestUuid(), unexpected);
            OlapSchemaLifeCycleStatus olapSchemaLifeCycleStatus = new OlapSchemaLifeCycleStatus(schemaName, OlapSchemaLoadStatus.LOAD_ERROR);
            return olapSchemaLifeCycleStatus;
        }
        catch (IncrLoadAuthException ex) {
            OlapLoggers.COMMAND.warn((Object)("LOAD SCHEMA (PHASE II) incr-load not authorized [" + schemaName + "]"));
            OlapBuilderError error = new OlapBuilderError(OlapBuilderErrorCode.INCR_LOAD_NOT_AUTH, new Serializable[0]);
            IcCubeRequestStatusManager statusManager = this.olapEngineRequestContext.getRequestStatusManager();
            statusManager.onRequestError(this.getRequestUuid(), error);
            OlapSchemaLifeCycleStatus olapSchemaLifeCycleStatus = new OlapSchemaLifeCycleStatus(schemaName, OlapSchemaLoadStatus.INCREMENTAL_LOAD_ERROR);
            return olapSchemaLifeCycleStatus;
        }
        catch (IncrLoadUnexpectedException ex) {
            OlapLoggers.COMMAND.warn((Object)("LOAD SCHEMA (PHASE II) incr-load unexpected error [" + schemaName + "] "), (Throwable)ex.cause);
            OlapBuilderError unexpected = new OlapBuilderError(OlapBuilderErrorCode.UNEXPECTED_ERROR, ex.cause);
            IcCubeRequestStatusManager statusManager = this.olapEngineRequestContext.getRequestStatusManager();
            statusManager.onRequestError(this.getRequestUuid(), unexpected);
            OlapSchemaLifeCycleStatus olapSchemaLifeCycleStatus = new OlapSchemaLifeCycleStatus(schemaName, OlapSchemaLoadStatus.INCREMENTAL_LOAD_ERROR);
            return olapSchemaLifeCycleStatus;
        }
        catch (IncrLoadException ex) {
            IcCubeRequestStatusManager statusManager = this.olapEngineRequestContext.getRequestStatusManager();
            statusManager.onRequestErrors(this.getRequestUuid(), ex.cause.getErrors());
            OlapSchemaLifeCycleStatus olapSchemaLifeCycleStatus = new OlapSchemaLifeCycleStatus(schemaName, OlapSchemaLoadStatus.INCREMENTAL_LOAD_ERROR);
            return olapSchemaLifeCycleStatus;
        }
        finally {
            if (this.schemaLogger.isInfoEnabled()) {
                this.schemaLogger.info((Object)("[schema] LOAD_SCHEMA (PHASE II) done [" + factory.getSchemaName() + "]"));
            }
        }
    }

    private OlapSchemaLifeCycleStatus unsafeLoadSchemaPhaseII(IOlapEngineLoadSchemaParams params, IOlapBuilderSchemaDefFactory factory) throws FullLoadUnexpectedException, IncrLoadUnexpectedException, IncrLoadAuthException, IncrLoadException {
        OlapBuilderContext context;
        OlapSchema loadedSchemaPhaseI = this.olapEngineRequestContext.getLoadedSchemaPhaseI();
        if (loadedSchemaPhaseI != null) {
            return this.unsafeFullLoadSchemaPhaseII(params, factory, loadedSchemaPhaseI);
        }
        String schemaName = factory.getSchemaName();
        OlapSchema loadedSchema = params.isRestoreActivated() && params.getRestoringSchema() != null ? params.getRestoringSchema() : this.getSchema(IcCubeSchemaAccessLockMode.WRITE, schemaName);
        if (factory.incrementalLoadActive() && loadedSchema != null && (context = this.olapEngineRequestContext.getIncrLoadedBuilderContextPhaseI()) != null) {
            return this.unsafeIncrLoadSchemaPhaseII(factory, loadedSchema, context);
        }
        throw new RuntimeException("internal error : load schema (PHASE II) - missing schema / context");
    }

    private OlapSchemaLifeCycleStatus unsafeFullLoadSchemaPhaseII(IOlapEngineLoadSchemaParams params, IOlapBuilderSchemaDefFactory factory, OlapSchema loadedSchemaPhaseI) throws FullLoadUnexpectedException {
        boolean isCreateOfflineOnly = params.getOfflineMode() == OlapEngineOfflineMode.WRITE_ONLY;
        String info = isCreateOfflineOnly ? "(create-offline-only) " : "";
        try {
            if (this.schemaLogger.isInfoEnabled()) {
                this.schemaLogger.info((Object)("[schema] LOAD_SCHEMA " + info + "(PHASE II) full-load started [" + factory.getSchemaName() + "]"));
            }
            if (!isCreateOfflineOnly) {
                this.olapEngine.addSchema(this.olapEngineRequestContext, loadedSchemaPhaseI);
            }
            if (this.schemaLogger.isInfoEnabled()) {
                this.schemaLogger.info((Object)("[schema] LOAD_SCHEMA " + info + "(PHASE II) full-load done [" + factory.getSchemaName() + "]"));
            }
            return new OlapSchemaLifeCycleStatus(loadedSchemaPhaseI.getName(), OlapSchemaLoadStatus.LOADED);
        }
        catch (RuntimeException ex) {
            this.schemaLogger.error((Object)("[schema] LOAD_SCHEMA " + info + "(PHASE II)  full-load done on-error (unexpected) [" + factory.getSchemaName() + "]"));
            throw new FullLoadUnexpectedException(ex);
        }
    }

    private OlapSchemaLifeCycleStatus unsafeIncrLoadSchemaPhaseII(IOlapBuilderSchemaDefFactory factory, OlapSchema loadedSchema, OlapBuilderContext context) throws IncrLoadUnexpectedException, IncrLoadAuthException, IncrLoadException {
        if (this.schemaLogger.isInfoEnabled()) {
            this.schemaLogger.info((Object)("[schema] LOAD_SCHEMA (PHASE II) incr-load started [" + factory.getSchemaName() + "]"));
        }
        try {
            OlapSchemaIncrLoadInfo incrLoadInfo = OlapBuilderSchemaMain.incrementalLoadPhaseII(context, loadedSchema);
            boolean didSomething = incrLoadInfo.hasNewData();
            if (didSomething) {
                this.olapEngine.incrLoadSchema(this.olapEngineRequestContext, loadedSchema, incrLoadInfo);
            } else {
                context.onIncrLoadWithoutData();
            }
            if (this.schemaLogger.isInfoEnabled()) {
                this.schemaLogger.info((Object)("[schema] LOAD_SCHEMA (PHASE II) incr-load done " + (didSomething ? "" : "without data ") + "[" + factory.getSchemaName() + "]"));
            }
            return new OlapSchemaLifeCycleStatus(loadedSchema.getName(), OlapSchemaLoadStatus.INCREMENTAL_LOADED);
        }
        catch (OlapBuilderIncrLoadNotAuthException ex) {
            throw new IncrLoadAuthException(ex);
        }
        catch (OlapContextualBigException ex) {
            this.olapEngine.incrLoadSchemaOnError(this.olapEngineRequestContext, loadedSchema);
            this.schemaLogger.error((Object)("[schema] LOAD_SCHEMA (PHASE II) incr-load done on-error [" + factory.getSchemaName() + "]"));
            throw new IncrLoadException(ex);
        }
        catch (RuntimeException ex) {
            this.olapEngine.incrLoadSchemaOnError(this.olapEngineRequestContext, loadedSchema);
            this.schemaLogger.error((Object)("[schema] LOAD_SCHEMA (PHASE II) incr-load done on-error (unexpected) [" + factory.getSchemaName() + "]"));
            throw new IncrLoadUnexpectedException(ex);
        }
    }

    private boolean hasSchemaWithIncrementalActive(IOlapEngineLoadSchemaParams params, String name) {
        if (!params.isExplicitFullLoad() && params.isRestoreActivated() && params.getRestoringSchema() != null) {
            return true;
        }
        OlapRolePermissions elevated = this.olapEngineRequestContext.elevateForBuilderPermissions();
        OlapRoleApplicationPermissions applicationPermissions = elevated.getApplicationPermissions();
        IOlapSchemasPermission schemasPermissions = elevated.getSchemasPermissions();
        OlapRuntimeContext rContext = this.olapEngineRequestContext.asRuntimeContext();
        return this.olapEngine.hasAuthorizedSchemaWithIncrementalActive(rContext, applicationPermissions, schemasPermissions, name);
    }

    static class IncrLoadLimitAuthException
    extends Exception {
        private static final long serialVersionUID = 4041849240816684092L;
        private final OlapBuilderIncrLoadLimitNotAuthException cause;

        public IncrLoadLimitAuthException(OlapBuilderIncrLoadLimitNotAuthException cause) {
            this.cause = cause;
        }
    }

    static class IncrLoadAuthException
    extends Exception {
        private static final long serialVersionUID = -3334161489340835136L;
        private final OlapBuilderIncrLoadNotAuthException cause;

        public IncrLoadAuthException(OlapBuilderIncrLoadNotAuthException cause) {
            this.cause = cause;
        }
    }

    static class IncrLoadException
    extends Exception {
        private static final long serialVersionUID = 8086521715595456260L;
        private final OlapContextualBigException cause;

        public IncrLoadException(OlapContextualBigException cause) {
            this.cause = cause;
        }
    }

    static class IncrLoadUnexpectedException
    extends Exception {
        private static final long serialVersionUID = 5522373950820153312L;
        private final RuntimeException cause;

        public IncrLoadUnexpectedException(RuntimeException cause) {
            this.cause = cause;
        }
    }

    static class FullLoadException
    extends Exception {
        private static final long serialVersionUID = 8275724980935707125L;
        private final OlapContextualBigException cause;

        public FullLoadException(OlapContextualBigException cause) {
            this.cause = cause;
        }
    }

    static class FullLoadUnexpectedException
    extends Exception {
        private static final long serialVersionUID = -6383072333204403870L;
        private final RuntimeException cause;

        public FullLoadUnexpectedException(RuntimeException cause) {
            this.cause = cause;
        }
    }
}

