/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.component.command.builtin;

import crazydev.common.collection.CdSetList;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.OlapBuilderContextMode;
import crazydev.iccube.builder.OlapBuilderLoadMeasureGroupContext;
import crazydev.iccube.builder.OlapBuilderReferenceSolver;
import crazydev.iccube.builder.OlapBuilderSchemaMain;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.executor.common.OlapBuilderTableProcessingHelper;
import crazydev.iccube.builder.factory.schema.IOlapBuilderSchemaDefFactory;
import crazydev.iccube.builder.model.builders.IOlapBuilderTableListener;
import crazydev.iccube.builder.model.def.IOlapBuilderBaseFactsDef;
import crazydev.iccube.builder.model.def.IOlapBuilderCubeDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.builder.model.def.IOlapBuilderSchemaDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.cluster.shared.facts.bitmap.S_FactBitmapContainerFactory;
import crazydev.iccube.common.executor.OlapThreadPoolExecutorTaskSchedulingPolicy;
import crazydev.iccube.enums.OlapIncrementalLoadStrategy;
import crazydev.iccube.olap.component.command.builtin.OlapEngineLoadMeasureGroupParams;
import crazydev.iccube.olap.component.command.builtin.OlapLoadEntityHelper;
import crazydev.iccube.olap.component.command.builtin.OlapSchemaLifeCycleStatus;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.cube.OlapRegularCube;
import crazydev.iccube.olap.entity.dimension.OlapMeasuresDimension;
import crazydev.iccube.olap.facts.OlapFactCubeManager;
import crazydev.iccube.olap.facts.column.list.IOlapFactListFactory;
import crazydev.iccube.olap.goodies.incrload.IncrLoadTableSavePoint;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.util.OlapCaseInsensitiveName;
import crazydev.iccube.olap.util.OlapNameUtils;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class OlapLoadMeasureGroupsHelper
extends OlapLoadEntityHelper<OlapBuilderLoadMeasureGroupContext, OlapEngineLoadMeasureGroupParams> {
    private static final Hash.Strategy<IOlapBuilderDataTableDef> HASH_ON_ID = new Hash.Strategy<IOlapBuilderDataTableDef>(){

        public int hashCode(IOlapBuilderDataTableDef object) {
            String id = object.getId();
            return id.hashCode();
        }

        public boolean equals(@Nullable IOlapBuilderDataTableDef o1, @Nullable IOlapBuilderDataTableDef o2) {
            if (o1 == o2) {
                return true;
            }
            if (o1 == null || o2 == null) {
                return false;
            }
            String id1 = o1.getId();
            String id2 = o2.getId();
            return id1.equals(id2);
        }
    };
    private Map<IOlapBuilderDataTableDef, IncrLoadTableSavePoint> savePoints = new Object2ObjectOpenCustomHashMap(HASH_ON_ID);

    public OlapLoadMeasureGroupsHelper(OlapEngineRequestContext olapEngineRequestContext) {
        super(olapEngineRequestContext);
    }

    public OlapSchemaLifeCycleStatus loadMeasureGroup(OlapEngineLoadMeasureGroupParams params) {
        OlapSchemaLifeCycleStatus status = this.loadEntity(params);
        return status;
    }

    @Override
    protected OlapBuilderContext createBuilderContext(OlapEngineLoadMeasureGroupParams params, OlapSchema loadedSchema) {
        return new OlapBuilderContext(this.olapEngineRequestContext, params, OlapBuilderContextMode.LOAD_MEASURE_GROUPS, null, loadedSchema, loadedSchema.getSchemaDefinition());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void unsafeLoadPhaseI(OlapBuilderLoadMeasureGroupContext eContext, OlapEngineLoadMeasureGroupParams params, OlapBuilderContext context, OlapSchema loadedSchema) {
        OlapBuilderConnectionPool connectionPool = new OlapBuilderConnectionPool();
        OlapBuilderErrorManager errorManager = new OlapBuilderErrorManager(true);
        IOlapBuilderSchemaDefFactory schemaDefFactory = loadedSchema.getDefinitionFactory();
        IOlapBuilderSchemaDef schemaDef = schemaDefFactory.createSchemaDefinition(connectionPool, errorManager);
        OlapBuilderReferenceSolver referenceSolver = OlapBuilderSchemaMain.createReferenceSolver(errorManager, schemaDef);
        OlapBuilderSchemaMain.solveReferences(errorManager, schemaDef, referenceSolver);
        IOlapBuilderCubeDef cubeDef = this.setupCubeDef(eContext, params, schemaDef);
        RequestedFactsDef requestedFactsDef = this.setupRequestedFactsDef(eContext, params, schemaDef, cubeDef);
        List<IOlapBuilderDataTableDef> requestedTableDefs = this.setupRequestedTableDef(params, schemaDef, requestedFactsDef.factsDef);
        if (this.schemaLogger.isInfoEnabled()) {
            this.schemaLogger.info((Object)("[schema] " + eContext.commandForLogsAndErrors() + " requested table(s) [" + OlapNameUtils.availables(requestedTableDefs) + "]"));
        }
        this.validateTablesUsage(eContext, schemaDef, requestedFactsDef.factsDef, requestedTableDefs);
        context.createClusterContext(null, null);
        OlapBuilderSchemaMain.removeAllListeners(schemaDef);
        IOlapFactListFactory dimensionsColumnFactory = OlapBuilderSchemaMain.setupDimensionsColumnListFactory(this.olapEngineRequestContext, loadedSchema);
        IOlapFactListFactory factsColumnFactory = OlapBuilderSchemaMain.setupFactsColumnListFactory(this.olapEngineRequestContext, loadedSchema);
        S_FactBitmapContainerFactory factsBitmapContainerFactory = OlapBuilderSchemaMain.setupFactsBitmapContainerFactory(this.olapEngineRequestContext, loadedSchema);
        List<OlapRegularCube> requestedCubes = this.setupRequestedCubes(eContext, context, schemaDef, requestedFactsDef, dimensionsColumnFactory, factsColumnFactory, factsBitmapContainerFactory, loadedSchema);
        if (this.schemaLogger.isInfoEnabled()) {
            for (OlapRegularCube regularCube : requestedCubes) {
                this.schemaLogger.info((Object)("[schema] " + eContext.commandForLogsAndErrors() + " requested cube [" + regularCube.getNameX() + "]"));
            }
        }
        try {
            if (!context.isRestoring()) {
                this.setupRequestedFactsTableForIncrLoadStarted(loadedSchema, requestedFactsDef, requestedTableDefs);
                this.processRequestedFactsTable(eContext, context, connectionPool, params, requestedTableDefs);
                this.setupRequestedFactsTableForIncrLoadDone(eContext, loadedSchema, requestedFactsDef, requestedTableDefs);
                OlapLoadMeasureGroupsHelper.onRequestedFactsTableProcessed(context, requestedCubes);
            } else {
                context.restoreFacts(requestedCubes);
                context.restoreFactsContent();
                OlapLoadMeasureGroupsHelper.onRequestedFactsTableProcessed(context, requestedCubes);
                context.restoreCubesUnresolvedRows(requestedTableDefs);
                context.restoreIncrLoadSavePoints(OlapBuilderSchemaMain.allDataTables(schemaDef));
            }
        }
        finally {
            connectionPool.close();
        }
    }

    private void setupRequestedFactsTableForIncrLoadStarted(OlapSchema loadedSchema, RequestedFactsDef requestedFactsDef, List<IOlapBuilderDataTableDef> requestedTableDefs) {
        block4: for (IOlapBuilderDataTableDef requestedTableDef : requestedTableDefs) {
            OlapIncrementalLoadStrategy strategy = requestedTableDef.getIncrementalLoadStrategy();
            if (strategy == null) {
                return;
            }
            switch (strategy) {
                case NO_UPDATE: {
                    return;
                }
                case INCREMENTAL: 
                case INCREMENTAL_TRIGGER: 
                case FULL_RELOAD: {
                    IncrLoadTableSavePoint savePoint = new IncrLoadTableSavePoint(requestedTableDef);
                    savePoint.addListenerForLoadFacts(requestedTableDef);
                    this.savePoints.put(requestedTableDef, savePoint);
                    continue block4;
                }
            }
            throw new RuntimeException("internal error: unexpected incr. load strategy [" + String.valueOf((Object)strategy) + "]");
        }
    }

    private void setupRequestedFactsTableForIncrLoadDone(OlapBuilderLoadMeasureGroupContext context, OlapSchema loadedSchema, RequestedFactsDef requestedFactsDef, List<IOlapBuilderDataTableDef> requestedTableDefs) {
        if (this.savePoints.isEmpty()) {
            return;
        }
        for (IOlapBuilderDataTableDef requestedTableDef : requestedTableDefs) {
            IncrLoadTableSavePoint savePoint = this.savePoints.get(requestedTableDef);
            if (savePoint == null) continue;
            loadedSchema.updateIncrLoadSavePoints(context, requestedTableDef, savePoint);
        }
    }

    private IOlapBuilderCubeDef setupCubeDef(OlapBuilderLoadMeasureGroupContext eContext, OlapEngineLoadMeasureGroupParams params, IOlapBuilderSchemaDef schemaDef) {
        String requestedCubeName = params.getCubeName();
        List<IOlapBuilderCubeDef> cubes = schemaDef.getCubes();
        if (cubes != null) {
            for (IOlapBuilderCubeDef cube : cubes) {
                if (!OlapCaseInsensitiveName.equals(requestedCubeName, cube.getName())) continue;
                return cube;
            }
        }
        throw new OlapBuilderErrorException(OlapBuilderErrorCode.LOAD_MEASURE_GROUP_UNKNOWN_CUBE, new Serializable[]{requestedCubeName, OlapNameUtils.availables(cubes)});
    }

    private RequestedFactsDef setupRequestedFactsDef(OlapBuilderLoadMeasureGroupContext eContext, OlapEngineLoadMeasureGroupParams params, IOlapBuilderSchemaDef schemaDef, IOlapBuilderCubeDef cubeDef) {
        String requestedMeasureGroupName = params.getMeasureGroupName();
        List<IOlapBuilderBaseFactsDef> factDefs = cubeDef.getFacts();
        if (requestedMeasureGroupName == null) {
            if (factDefs != null && factDefs.size() == 1) {
                if (this.schemaLogger.isInfoEnabled()) {
                    this.schemaLogger.info((Object)("[schema] " + eContext.commandForLogsAndErrors() + " single facts selected [cube:" + cubeDef.getName() + "] [facts:" + factDefs.get(0).getName() + "]"));
                }
                return new RequestedFactsDef(cubeDef, factDefs.get(0));
            }
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.LOAD_MEASURE_GROUP_MISSING_FACTS, new Serializable[]{OlapNameUtils.availables(factDefs)});
        }
        if (factDefs != null) {
            for (IOlapBuilderBaseFactsDef factDef : factDefs) {
                if (!OlapCaseInsensitiveName.equals(requestedMeasureGroupName, factDef.getName())) continue;
                return new RequestedFactsDef(cubeDef, factDef);
            }
        }
        throw new OlapBuilderErrorException(OlapBuilderErrorCode.LOAD_MEASURE_GROUP_UNKNOWN_FACTS, new Serializable[]{requestedMeasureGroupName, OlapNameUtils.availables(factDefs)});
    }

    private List<IOlapBuilderDataTableDef> setupRequestedTableDef(OlapEngineLoadMeasureGroupParams params, IOlapBuilderSchemaDef schemaDef, IOlapBuilderBaseFactsDef requestedFactsDef) {
        IOlapBuilderTabularDataDef dataView = requestedFactsDef.getDataView();
        CdSetList<IOlapBuilderDataTableDef> underlyingTables = dataView.getUnderlyingTables();
        return underlyingTables;
    }

    private void validateTablesUsage(OlapBuilderLoadMeasureGroupContext eContext, IOlapBuilderSchemaDef schemaDef, IOlapBuilderBaseFactsDef requestedFactsDefs, List<IOlapBuilderDataTableDef> requestedTableDefs) {
        List<IOlapBuilderDimensionDef> dimensionDefs;
        List<IOlapBuilderCubeDef> cubeDefs = schemaDef.getCubes();
        if (cubeDefs != null) {
            for (IOlapBuilderCubeDef cubeDef : cubeDefs) {
                List<IOlapBuilderBaseFactsDef> factsDefs = cubeDef.getFacts();
                for (IOlapBuilderBaseFactsDef factsDef : factsDefs) {
                    IOlapBuilderTabularDataDef view = factsDef.getDataView();
                    CdSetList<IOlapBuilderDataTableDef> tables = view.getUnderlyingTables();
                    for (IOlapBuilderDataTableDef requestedTableDef : requestedTableDefs) {
                        if (!tables.contains((Object)requestedTableDef) || factsDef.equals(requestedFactsDefs)) continue;
                        this.schemaLogger.error((Object)("[schema] " + eContext.commandForLogsAndErrors() + " duplicated usage of requested table(s) [" + OlapNameUtils.availables(requestedTableDefs) + "] - used in facts : " + cubeDef.getName() + " / " + factsDef.getName()));
                        throw new OlapBuilderErrorException(OlapBuilderErrorCode.LOAD_MEASURE_GROUP_DUPLICATED_USAGE_FACTS, new Serializable[]{requestedFactsDefs.getName(), OlapNameUtils.availables(requestedTableDefs), cubeDef.getName(), factsDef.getName()});
                    }
                }
            }
        }
        if ((dimensionDefs = schemaDef.getDimensions()) != null) {
            for (IOlapBuilderDimensionDef dimensionDef : dimensionDefs) {
                IOlapBuilderTabularDataDef view = dimensionDef.getDataView();
                CdSetList<IOlapBuilderDataTableDef> tables = view.getUnderlyingTables();
                for (IOlapBuilderDataTableDef requestedTableDef : requestedTableDefs) {
                    if (!tables.contains((Object)requestedTableDef)) continue;
                    this.schemaLogger.error((Object)("[schema] " + eContext.commandForLogsAndErrors() + " duplicated usage of requested table(s) [" + OlapNameUtils.availables(requestedTableDefs) + "] - used in dimension : " + dimensionDef.getName()));
                    throw new OlapBuilderErrorException(OlapBuilderErrorCode.LOAD_MEASURE_GROUP_DUPLICATED_USAGE_DIMENSION, new Serializable[]{requestedFactsDefs.getName(), OlapNameUtils.availables(requestedTableDefs), dimensionDef.getName()});
                }
            }
        }
    }

    private List<OlapRegularCube> setupRequestedCubes(OlapBuilderLoadMeasureGroupContext eContext, OlapBuilderContext context, IOlapBuilderSchemaDef schemaDef, RequestedFactsDef requestedFactsDef, IOlapFactListFactory dimensionsColumnFactory, IOlapFactListFactory factsColumnFactory, S_FactBitmapContainerFactory factsBitmapContainerFactory, OlapSchema loadedSchema) {
        IOlapBuilderCubeDef cubeDef = requestedFactsDef.cubeDef;
        IOlapBuilderBaseFactsDef factsDef = requestedFactsDef.factsDef;
        List<IOlapBuilderBaseFactsDef> cubeFacts = cubeDef.getFacts();
        OlapMeasuresDimension measureDimension = OlapLoadMeasureGroupsHelper.setupMeasuresDimension(loadedSchema, dimensionsColumnFactory, cubeDef, cubeFacts);
        OlapRegularCube cube = new OlapRegularCube(context, factsColumnFactory, factsBitmapContainerFactory, loadedSchema, cubeDef.getName(), cubeDef.getDescription(), cubeFacts, measureDimension);
        eContext.registerRequestedCube(cubeDef, cube);
        if (this.schemaLogger.isInfoEnabled()) {
            this.schemaLogger.info((Object)("[schema] " + eContext.commandForLogsAndErrors() + " cube setup [cube:" + cubeDef.getName() + "] [facts:" + factsDef.getName() + "]"));
        }
        OlapFactCubeManager manager = cube.getCubeFactManager();
        manager.setupClusterInformation();
        IOlapBuilderTableListener factBuilder = factsDef.createFactBuilder(context, cube);
        IOlapBuilderTabularDataDef dataView = factsDef.getDataView();
        dataView.addListener(factBuilder);
        eContext.registerRequestedFacts(cubeDef, factsDef);
        eContext.registerFactBuilder(factBuilder, dataView);
        return eContext.getRequestedCubesX();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRequestedFactsTable(OlapBuilderLoadMeasureGroupContext eContext, OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, OlapEngineLoadMeasureGroupParams params, List<IOlapBuilderDataTableDef> requestedTables) {
        context.setForFactProcessing(true);
        context.onProgressPhase("factProcessingStarted", new Serializable[0]);
        context.onProgressEvent("factProcessingStarted", new Serializable[0]);
        try {
            if (this.schemaLogger.isInfoEnabled()) {
                for (IOlapBuilderDataTableDef requestedTable : requestedTables) {
                    this.schemaLogger.info((Object)("[schema] " + eContext.commandForLogsAndErrors() + " table processing started [table:" + requestedTable.getName() + "] [active:" + requestedTable.hasListeners() + "]"));
                }
            }
            OlapBuilderTableProcessingHelper.processTables(context, connectionPool, OlapThreadPoolExecutorTaskSchedulingPolicy.PARTITION, requestedTables);
        }
        finally {
            context.setForFactProcessing(false);
            context.onProgressPhase("factProcessingDone", new Serializable[0]);
            context.onProgressEvent("factProcessingDone", new Serializable[0]);
        }
    }

    static class RequestedFactsDef {
        final IOlapBuilderCubeDef cubeDef;
        final IOlapBuilderBaseFactsDef factsDef;

        public RequestedFactsDef(IOlapBuilderCubeDef cubeDef, IOlapBuilderBaseFactsDef factsDef) {
            this.cubeDef = cubeDef;
            this.factsDef = factsDef;
        }
    }
}

