/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.component.command.builtin;

import crazydev.common.fs.CdVFileSystem;
import crazydev.common.utils.CdSystemUtils;
import crazydev.common.version.CdVersion;
import crazydev.common.xml.CdXmlUtils;
import crazydev.iccube.babylon.OlapBabylonService;
import crazydev.iccube.configuration.OlapConfigurationError;
import crazydev.iccube.configuration.OlapConfigurationErrorCode;
import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.configuration.component.plugins.OlapConfPluginClassProcessor;
import crazydev.iccube.configuration.component.plugins.OlapConfPluginContainer;
import crazydev.iccube.configuration.component.plugins.builder.OlapConfBuilderPlugin;
import crazydev.iccube.configuration.component.plugins.function.OlapConfFunctionPlugin;
import crazydev.iccube.configuration.component.plugins.function.OlapConfJavaTableAgrregatorPlugin;
import crazydev.iccube.configuration.component.plugins.intializer.OlapConfAuthenticationServicePlugin;
import crazydev.iccube.configuration.component.plugins.intializer.OlapConfInitializerPlugin;
import crazydev.iccube.configuration.component.plugins.localization.OlapConfLocalizationPlugin;
import crazydev.iccube.configuration.component.plugins.method.OlapConfMethodsPlugin;
import crazydev.iccube.info.OlapLixContent;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.context.OlapEngineApplicationContext;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.plugins.OlapEnginePluginInfo;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.method.OlapModuleMethodCallInstrFactory;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.plugin.OlapPluginClassLoader;
import crazydev.iccube.plugin.OlapPluginErrorManager;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import crazydev.iccube.runtime.OlapRuntime;
import jakarta.xml.bind.DataBindingException;
import jakarta.xml.bind.JAXBException;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public class OlapLoadAllPluginsHelper {
    private final CdVFileSystem vfs;
    private final OlapEngineRequestContext olapEngineRequestContext;
    private final List<OlapConfPluginClassProcessor> processors;
    @Nullable
    private final File additionalPlugins;
    private final OlapEngineComponent olapEngine;

    public OlapLoadAllPluginsHelper(CdVFileSystem vfs, OlapEngineRequestContext olapEngineRequestContext, @Nullable File additionalPlugins, OlapConfPluginClassProcessor ... processors) {
        this.vfs = vfs;
        this.olapEngineRequestContext = olapEngineRequestContext;
        this.additionalPlugins = additionalPlugins;
        this.processors = new ArrayList<OlapConfPluginClassProcessor>();
        if (processors != null) {
            for (OlapConfPluginClassProcessor processor : processors) {
                if (processor == null) continue;
                this.processors.add(processor);
            }
        }
        this.olapEngine = olapEngineRequestContext.getOlapEngineComponent();
    }

    private static OlapConfPluginContainer unmarshallPluginContainer(File pluginLocation) throws OlapConfigurationException {
        OlapConfPluginContainer olapConfPluginContainer;
        Reader pluginReader = OlapConfPluginContainer.getLocationReader(pluginLocation);
        try {
            olapConfPluginContainer = (OlapConfPluginContainer)CdXmlUtils.unmarshall((File)pluginLocation, (Reader)pluginReader, (Class[])new Class[]{OlapConfPluginContainer.class});
        }
        catch (Throwable throwable) {
            try {
                IOUtils.closeQuietly((Reader)pluginReader);
                throw throwable;
            }
            catch (JAXBException ex) {
                OlapLoggers.PLUGINS.error((Object)("[plugins] Failed to unmarshall plugin [" + pluginLocation.getAbsolutePath() + "]"), (Throwable)ex);
                String message = "plugin error : could not read XML file (" + pluginLocation.getAbsolutePath() + ") : " + CdXmlUtils.getJAXBMessage((JAXBException)ex);
                throw new OlapConfigurationException(pluginLocation.getAbsolutePath(), OlapConfigurationErrorCode.XML_ERROR, new Serializable[]{message});
            }
            catch (DataBindingException ex) {
                OlapLoggers.PLUGINS.error((Object)("[plugins] Failed to unmarshall plugin [" + pluginLocation.getAbsolutePath() + "]"), (Throwable)ex);
                String message = "plugin error : could not read XML file (" + pluginLocation.getAbsolutePath() + ") : " + ex.getMessage();
                throw new OlapConfigurationException(pluginLocation.getAbsolutePath(), OlapConfigurationErrorCode.XML_ERROR, new Serializable[]{message});
            }
            catch (IOException ex) {
                OlapLoggers.PLUGINS.error((Object)("[plugins] Failed to unmarshall plugin [" + pluginLocation.getAbsolutePath() + "]"), (Throwable)ex);
                String message = "plugin error : could not read XML file (" + pluginLocation.getAbsolutePath() + ") : " + ex.getMessage();
                throw new OlapConfigurationException(pluginLocation.getAbsolutePath(), OlapConfigurationErrorCode.IO_ERROR, new Serializable[]{message});
            }
        }
        IOUtils.closeQuietly((Reader)pluginReader);
        return olapConfPluginContainer;
    }

    private static boolean isPlugin(File jarFile) throws IOException {
        if (jarFile.getName().toLowerCase().endsWith(".jar")) {
            JarFile jar = new JarFile(jarFile);
            JarEntry entry = jar.getJarEntry("META-INF/plugin.xml");
            return entry != null;
        }
        File metaInf = new File(jarFile, "META-INF");
        File xml = new File(metaInf, "plugin.xml");
        return xml.exists();
    }

    public void loadAllPlugins(@Nullable OlapLixContent classes) {
        this.doLoadAllPlugins(classes);
        this.olapEngine.onAllPluginsLoaded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLoadAllPlugins(@Nullable OlapLixContent classes) {
        this.olapEngine.clearAllPlugins(this.getRequestUuid());
        for (OlapConfPluginClassProcessor processor : this.processors) {
            processor.onBegin();
        }
        IcCubeRequestStatusManager statusManager = this.olapEngineRequestContext.getRequestStatusManager();
        List<File> pluginLocations = this.getPluginLocations();
        this.olapEngine.addAllPluginsLocations(pluginLocations);
        HashSet<String> done = new HashSet<String>();
        for (File pluginLocation : pluginLocations) {
            OlapLoggers.PLUGINS.info((Object)("[plugins] Location : [" + pluginLocation.getAbsolutePath() + "]"));
            try {
                if (OlapLoadAllPluginsHelper.isPlugin(pluginLocation)) {
                    OlapConfPluginContainer pluginContainer = OlapLoadAllPluginsHelper.unmarshallPluginContainer(pluginLocation);
                    pluginContainer.setLocation(pluginLocation);
                    String pluginName = pluginContainer.getName();
                    if (done.contains(pluginName)) {
                        OlapConfigurationError error = new OlapConfigurationError(OlapConfigurationErrorCode.DUPLICATED_PLUGIN_NAME, new Serializable[]{pluginName, pluginLocation.getAbsolutePath()});
                        statusManager.onRequestError(this.getRequestUuid(), error);
                        this.olapEngine.addPluginLocationErrors(pluginLocation, Arrays.asList(error));
                        continue;
                    }
                    done.add(pluginContainer.getName());
                    this.olapEngine.addPluginContainer(pluginContainer.getName(), pluginLocation, pluginContainer);
                    OlapPluginErrorManager errorManager = new OlapPluginErrorManager();
                    try {
                        this.loadPluginContainer(errorManager, classes, pluginLocations, pluginContainer);
                        continue;
                    }
                    finally {
                        statusManager.onRequestErrors(this.getRequestUuid(), errorManager.getErrors());
                        this.olapEngine.addPluginLocationErrors(pluginLocation, errorManager.getErrors());
                        continue;
                    }
                }
                this.olapEngine.addPluginDependency(pluginLocation);
            }
            catch (IOException ex) {
                OlapLoggers.PLUGINS.error((Object)"Unexpected IO error", (Throwable)ex);
                OlapConfigurationError error = new OlapConfigurationError(OlapConfigurationErrorCode.IO_ERROR, new Serializable[]{ex.getMessage()});
                statusManager.onRequestError(this.getRequestUuid(), error);
                this.olapEngine.addPluginLocationErrors(pluginLocation, Arrays.asList(error));
            }
            catch (OlapConfigurationException ex) {
                statusManager.onRequestError(this.getRequestUuid(), ex.getError());
                this.olapEngine.addPluginLocationErrors(pluginLocation, Arrays.asList(ex.getError()));
            }
        }
    }

    private void loadPluginContainer(OlapPluginErrorManager errorManager, @Nullable OlapLixContent classes, List<File> pluginLocations, OlapConfPluginContainer pluginContainer) {
        OlapLoggers.PLUGINS.info((Object)("[plugins] Name [" + pluginContainer.getName() + "] File [" + pluginContainer.getLocation().getAbsolutePath() + "]"));
        OlapPluginClassLoader classLoader = null;
        OlapEnginePluginInfo plugin = new OlapEnginePluginInfo(pluginContainer);
        this.registerInitialization(errorManager, plugin, classLoader);
        this.registerAuthenticationService(errorManager, plugin, classLoader);
        this.registerFunctions(errorManager, plugin, classLoader);
        this.registerBuilderClasses(errorManager, plugin, classLoader);
        this.registerMethods(errorManager, plugin, classLoader);
        this.registerGwtLocalization(errorManager, plugin, classLoader);
        this.registerTableAggregators(errorManager, plugin, classLoader);
        this.olapEngine.addPluginInfo(plugin);
    }

    private void registerInitialization(OlapPluginErrorManager errorManager, OlapEnginePluginInfo plugin, @Nullable OlapPluginClassLoader classLoader) {
        OlapLoggers.PLUGINS.info((Object)("[plugins] Name [" + plugin.getName() + "] initialization"));
        OlapConfPluginContainer container = plugin.getContainer();
        OlapConfInitializerPlugin initialization = container.getInitialization();
        if (initialization != null) {
            try {
                initialization.setupAndValidate(classLoader);
            }
            catch (OlapConfigurationException ex) {
                OlapLoggers.PLUGINS.error((Object)("[plugins] Initialization plugin error - (" + plugin.getName() + ") could not register classes : "), (Throwable)((Object)ex));
                errorManager.collectError(ex);
            }
        }
    }

    private void registerAuthenticationService(OlapPluginErrorManager errorManager, OlapEnginePluginInfo plugin, OlapPluginClassLoader classLoader) {
        OlapLoggers.PLUGINS.info((Object)("[plugins] Name [" + plugin.getName() + "] auth. service"));
        OlapConfPluginContainer container = plugin.getContainer();
        OlapConfAuthenticationServicePlugin service = container.getAuthenticationService();
        if (service != null) {
            try {
                service.setupAndValidate(classLoader);
                Class<?> clazz = this.olapEngine.registerUserDefinedAuthenticationService(service);
                if (clazz != null) {
                    plugin.addRegisteredAuthenticationClass(clazz);
                }
            }
            catch (OlapConfigurationException ex) {
                OlapLoggers.PLUGINS.error((Object)("[plugins] Authentication plugin error - (" + plugin.getName() + ") could not register classes : "), (Throwable)((Object)ex));
                errorManager.collectError(ex);
            }
        }
    }

    private void registerGwtLocalization(OlapPluginErrorManager errorManager, OlapEnginePluginInfo plugin, OlapPluginClassLoader classLoader) {
        OlapLoggers.PLUGINS.info((Object)("[plugins] Name [" + plugin.getName() + "] localization"));
        List<OlapConfLocalizationPlugin> localizations = plugin.getContainer().getLocalizations();
        for (OlapConfLocalizationPlugin localization : localizations) {
            try {
                localization.setupAndValidate(classLoader);
                OlapBabylonService.registerAlternateLocalization(localization.getLocalization());
            }
            catch (OlapConfigurationException ex) {
                OlapLoggers.PLUGINS.error((Object)("[plugins] UI localization plugin error - (" + plugin.getName() + ") could not register classes : "), (Throwable)((Object)ex));
                errorManager.collectError(ex);
            }
        }
    }

    private void registerMethods(OlapPluginErrorManager errorManager, OlapEnginePluginInfo plugin, OlapPluginClassLoader classLoader) {
        OlapLoggers.PLUGINS.info((Object)("[plugins] Name [" + plugin.getName() + "] methods"));
        List<OlapConfMethodsPlugin> methods = plugin.getContainer().getMethods();
        for (OlapConfMethodsPlugin method : methods) {
            String moduleName = method.getModuleName();
            OlapLoggers.PLUGINS.info((Object)("[plugins] Name [" + plugin.getName() + "] methods : " + moduleName));
            if (!this.olapEngineRequestContext.isMethodsModuleAuthorized(moduleName)) continue;
            try {
                OlapLoggers.PLUGINS.info((Object)("[plugins] Name [" + plugin.getName() + "] methods : " + moduleName + " setup/validate"));
                method.setupAndValidate(classLoader);
                OlapModuleMethodCallInstrFactory registeredMethods = this.olapEngine.registerModuleMethods(method);
                OlapLoggers.PLUGINS.info((Object)("[plugins] Name [" + plugin.getName() + "] methods : " + moduleName + " register"));
                plugin.addRegisteredModuleMethods(registeredMethods);
            }
            catch (OlapConfigurationException ex) {
                OlapLoggers.PLUGINS.error((Object)("[plugins] Methods plugin error - (" + plugin.getName() + ") : "), (Throwable)((Object)ex));
                errorManager.collectError(ex);
            }
        }
    }

    private void registerFunctions(OlapPluginErrorManager errorManager, OlapEnginePluginInfo plugin, OlapPluginClassLoader classLoader) {
        OlapLoggers.PLUGINS.info((Object)("[plugins] Name [" + plugin.getName() + "] functions"));
        List<OlapConfFunctionPlugin> functions = plugin.getContainer().getFunctions();
        for (OlapConfFunctionPlugin function : functions) {
            try {
                function.setupAndValidate(classLoader);
                List<OlapFunction> registeredFunctions = this.olapEngine.registerUserDefinedFunction(function);
                plugin.addRegisteredFunctions(registeredFunctions);
            }
            catch (OlapConfigurationException ex) {
                OlapLoggers.PLUGINS.error((Object)("[plugins] Function plugin error - (" + plugin.getName() + ") could not register function : "), (Throwable)((Object)ex));
                errorManager.collectError(ex);
            }
        }
    }

    private void registerTableAggregators(OlapPluginErrorManager errorManager, OlapEnginePluginInfo plugin, OlapPluginClassLoader classLoader) {
        OlapLoggers.PLUGINS.info((Object)("[plugins] Name [" + plugin.getName() + "] table Aggregators"));
        List<OlapConfJavaTableAgrregatorPlugin> aggregators = plugin.getContainer().getTableAggregator();
        for (OlapConfJavaTableAgrregatorPlugin aggregator : aggregators) {
            try {
                aggregator.setupAndValidate(classLoader);
                this.olapEngine.registerDataAggregator(aggregator);
                plugin.addRegisteredTableAggregators(aggregator);
            }
            catch (OlapConfigurationException ex) {
                OlapLoggers.PLUGINS.error((Object)("[plugins] Function plugin error - (" + plugin.getName() + ") could not register function : "), (Throwable)((Object)ex));
                errorManager.collectError(ex);
            }
        }
    }

    private void registerBuilderClasses(OlapPluginErrorManager errorManager, OlapEnginePluginInfo plugin, OlapPluginClassLoader classLoader) {
        OlapLoggers.PLUGINS.info((Object)("[plugins] Name [" + plugin.getName() + "] builder"));
        List<OlapConfBuilderPlugin> builders = plugin.getContainer().getBuilders();
        for (OlapConfBuilderPlugin builder : builders) {
            try {
                builder.setupAndValidate(classLoader);
                Class registeredBuilderClass = this.olapEngine.registerUserDefinedBuilderClass(builder);
                plugin.addRegisteredBuilderClass(registeredBuilderClass);
                for (OlapConfPluginClassProcessor processor : this.processors) {
                    processor.onClassRegistered(registeredBuilderClass);
                }
            }
            catch (OlapConfigurationException ex) {
                OlapLoggers.PLUGINS.error((Object)("[plugins] Builder plugin error - (" + plugin.getName() + ") could not register classes : "), (Throwable)((Object)ex));
                errorManager.collectError(ex);
            }
        }
    }

    private List<File> getPluginLocations() {
        OlapEngineApplicationContext applicationContext = this.olapEngineRequestContext.getApplicationContext();
        if (applicationContext.isIDEA()) {
            return this.doGetPluginLocationsForIDEA();
        }
        if (applicationContext.isCI()) {
            return this.doGetPluginLocationsForCI();
        }
        return this.doGetPluginLocations();
    }

    private List<File> doGetPluginLocations() {
        ArrayList<File> plugins = new ArrayList<File>();
        this.doGetPluginLocations(plugins, this.olapEngine.getPluginsDirectory());
        if (this.additionalPlugins != null && this.additionalPlugins.isDirectory()) {
            this.doGetPluginLocations(plugins, this.additionalPlugins);
        }
        return plugins;
    }

    private void doGetPluginLocations(List<File> plugins, File pluginsDirectory) {
        OlapLoggers.PLUGINS.info((Object)("[plugins] Directory (production) : [" + pluginsDirectory.getAbsolutePath() + "]"));
        List<File> jarFiles = this.listAllFiles(pluginsDirectory, pathName -> pathName.getName().endsWith(".jar"));
        for (File jarFile : jarFiles) {
            plugins.add(jarFile);
        }
        List<File> explodedFiles = this.listAllFiles(pluginsDirectory, pathName -> pathName.getName().endsWith("plugin.xml") && pathName.getParent().endsWith("META-INF"));
        for (File explodedFile : explodedFiles) {
            plugins.add(explodedFile.getParentFile().getParentFile());
        }
    }

    public List<File> listAllFiles(File where, FileFilter filter) {
        try {
            ArrayList<File> allFiles = new ArrayList<File>();
            this.vfs.forEachFileRecursive(where, path -> true, vPath -> {
                File file = vPath.path.toFile();
                if (file.isFile() && filter.accept(file)) {
                    allFiles.add(file);
                }
            });
            return allFiles;
        }
        catch (IOException ex) {
            throw new RuntimeException("could not retrieve the plugins", ex);
        }
    }

    private List<File> doGetPluginLocationsForIDEA() {
        File pluginsDirectory = this.olapEngine.getPluginsDirectory();
        boolean intelliJ = OlapRuntime.isRunningWithIntelliJ();
        OlapLoggers.PLUGINS.info((Object)("[plugins] directory (runner:" + (intelliJ ? "IntelliJ" : "Gradle") + ") [" + pluginsDirectory.getAbsolutePath() + "]"));
        ArrayList<File> plugins = new ArrayList<File>();
        if (!intelliJ) {
            String version = CdVersion.MISSING.asString();
            List<String> pluginNames = Arrays.asList("plugins/ic3-plugin-excel/build/libs/ic3-plugin-excel-" + version + ".jar", "plugins/ic3-plugin-google-api/build/libs/ic3-plugin-google-api-" + version + ".jar", "plugins/ic3-plugin-mongodb/build/libs/ic3-plugin-mongodb-" + version + ".jar", "plugins/ic3-plugin-olap/build/libs/ic3-plugin-olap-" + version + ".jar", "plugins/customers/ic3-plugin-propbase/build/libs/ic3-plugin-propbase-" + version + ".jar");
            for (String pluginName : pluginNames) {
                plugins.add(new File(pluginsDirectory, pluginName));
            }
        } else {
            List<String> pluginNames = Arrays.asList("plugins/ic3-plugin-excel/out/production/resources", "plugins/ic3-plugin-math-plus/out/production/resources", "plugins/ic3-plugin-google-api/out/production/resources", "plugins/ic3-plugin-mongodb/out/production/resources", "plugins/ic3-plugin-olap/out/production/resources", "plugins/customers/ic3-plugin-propbase/out/production/resources");
            for (String pluginName : pluginNames) {
                plugins.add(new File(pluginsDirectory, pluginName));
            }
        }
        return plugins;
    }

    private List<File> doGetPluginLocationsForCI() {
        File pluginsDirectory = new File(CdSystemUtils.getStringProperty((String)"icCube.ci.wd", (String)"/tmp"));
        OlapLoggers.PLUGINS.info((Object)("[plugins] Directory (idea) : [" + pluginsDirectory.getAbsolutePath() + "]"));
        List<String> pluginNames = Arrays.asList("modules/plugins/iccubeplugin/production/jars/iccube-plugin.jar", "modules/plugins/exceldatasource/production/jars/iccube-plugin-exceldatasource.jar", "modules/plugins/renjin/production/jars/iccube-plugin-renjin.jar");
        ArrayList<File> plugins = new ArrayList<File>();
        for (String pluginName : pluginNames) {
            plugins.add(new File(pluginsDirectory, pluginName));
        }
        return plugins;
    }

    private String getRequestUuid() {
        return this.olapEngineRequestContext.getRequestClientUUID();
    }
}

