/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.component.command.builtin;

import crazydev.iccube.builder.OlapBuilderContextMode;
import crazydev.iccube.builder.datasource.common.OlapBuilderTableRequestedPartitionKeys;
import crazydev.iccube.cluster.shared.backup.S_BackupHelper;
import crazydev.iccube.olap.component.command.builtin.OlapEngineUnloadEntityParams;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class OlapEngineUnloadPartitionsParams
extends OlapEngineUnloadEntityParams {
    public static final String COMMAND_NAME = "UNLOAD_PARTITIONS";
    private String dataSourceName;
    private String dataTableName;
    private boolean partitionsAsRange;
    private List<String> partitions;

    protected OlapEngineUnloadPartitionsParams() {
    }

    public OlapEngineUnloadPartitionsParams(String xmlaStatement, String schemaName, String dataSourceName, String dataTableName, boolean partitionsAsRange, List<String> partitions, int waitS, int cancelS) {
        super(xmlaStatement, schemaName, waitS, cancelS);
        this.dataSourceName = dataSourceName;
        this.dataTableName = dataTableName;
        this.partitionsAsRange = partitionsAsRange;
        this.partitions = partitions;
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public OlapBuilderContextMode getMode() {
        return OlapBuilderContextMode.UNLOAD_PARTITIONS;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public String getDataTableName() {
        return this.dataTableName;
    }

    public OlapBuilderTableRequestedPartitionKeys getPartitions() {
        return new OlapBuilderTableRequestedPartitionKeys(this.partitionsAsRange, this.partitions);
    }

    @Override
    public void doSave(File file) throws IOException {
        super.doSave(file);
        S_BackupHelper.appendToFile(file, "ds:" + this.dataSourceName + "\n");
        S_BackupHelper.appendToFile(file, "dt:" + this.dataTableName + "\n");
        S_BackupHelper.appendToFile(file, "pr:" + this.partitionsAsRange + "\n");
        S_BackupHelper.appendToFile(file, "pc:" + this.partitions.size() + "\n");
        for (String partition : this.partitions) {
            S_BackupHelper.appendToFile(file, "p:" + partition + "\n");
        }
    }

    @Override
    protected void doRestore(List<String> lines) throws IOException {
        super.doRestore(lines);
        this.dataSourceName = lines.remove(0).substring(3);
        this.dataTableName = lines.remove(0).substring(3);
        this.partitionsAsRange = Boolean.valueOf(lines.remove(0).substring(3));
        int pc = Integer.valueOf(lines.remove(0).substring(3));
        this.partitions = new ArrayList<String>();
        for (int ii = 0; ii < pc; ++ii) {
            this.partitions.add(lines.remove(0).substring(2));
        }
    }

    public String asString() {
        return "[schema:" + this.schemaName + "] [datasource:" + this.dataSourceName + "] [table:" + this.dataTableName + "] [range:" + this.partitionsAsRange + "] " + String.valueOf(this.partitions);
    }

    public String toString() {
        return this.asString();
    }
}

