/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.component.command.builtin;

import crazydev.iccube.cluster.shared.backup.S_RestoreMode;
import crazydev.iccube.olap.component.command.builtin.OlapEngineAbstractLoadParams;
import crazydev.iccube.olap.component.command.builtin.OlapEngineLoadMeasureGroupParams;
import crazydev.iccube.olap.component.command.builtin.OlapEngineLoadPartitionsParams;
import crazydev.iccube.olap.component.command.builtin.OlapEngineLoadSchemaParams;
import crazydev.iccube.olap.component.command.builtin.OlapEngineOfflineMode;
import crazydev.iccube.olap.component.command.builtin.OlapEngineUnloadPartitionsParams;
import crazydev.iccube.olap.schema.OlapSchema;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public interface IOlapEngineLoadSchemaParams {
    @Nullable
    public String getXmlaStatement();

    public String getCommandName();

    @Nullable
    public File getSchemaFactoryFile();

    public int getWaitS();

    public int getCancelS();

    public boolean isExplicitFullLoad();

    public boolean isForceBackupOn();

    public boolean isKeepMdxResultCache();

    public boolean isContinueBackupOnError();

    public boolean isRestoreActivated();

    @Nullable
    public S_RestoreMode getRestoringMode();

    @Nullable
    public String getRestoreTimestamp();

    @Nullable
    public OlapSchema getRestoringSchema();

    public OlapEngineOfflineMode getOfflineMode();

    @Nullable
    public String getOfflineSnapshot();

    public void save(File var1) throws IOException;

    public static IOlapEngineLoadSchemaParams restore(String command, List<String> lines) throws IOException {
        OlapEngineAbstractLoadParams params;
        if ("UNLOAD_PARTITIONS".equals(command)) {
            params = new OlapEngineUnloadPartitionsParams();
        } else if ("LOAD_MEASURE_GROUP".equals(command)) {
            params = new OlapEngineLoadMeasureGroupParams();
        } else if ("LOAD_PARTITIONS".equals(command)) {
            params = new OlapEngineLoadPartitionsParams();
        } else if ("LOAD_SCHEMA".equals(command)) {
            params = new OlapEngineLoadSchemaParams();
        } else {
            throw new RuntimeException("internal error: unexpected command [" + command + "]");
        }
        ((OlapEngineAbstractLoadParams)params).doRestore(lines);
        return params;
    }
}

