/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.compiler.ast.select;

import crazydev.common.exception.CdRuntimeException;
import crazydev.iccube.mdx.parser.ast.expression.MdxExpression;
import crazydev.iccube.mdx.parser.ast.expression.drillthrough.MdxDrillthroughFunctionReturnExpression;
import crazydev.iccube.mdx.parser.ast.expression.drillthrough.MdxDrillthroughIdentifierReturnExpression;
import crazydev.iccube.mdx.parser.ast.expression.drillthrough.MdxDrillthroughReturnExpression;
import crazydev.iccube.mdx.parser.ast.expression.drillthrough.MdxDrillthroughStatementExpression;
import crazydev.iccube.mdx.parser.ast.expression.literal.MdxLongLiteralExpression;
import crazydev.iccube.mdx.parser.ast.statement.MdxStatementExpression;
import crazydev.iccube.olap.compiler.OlapCompilationContext;
import crazydev.iccube.olap.compiler.ast.MdxEntityCompiler;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.select.OlapTopLevelSelectInstr;
import crazydev.iccube.olap.goodies.drillthrough.OlapDrillthroughInstr;
import crazydev.iccube.olap.goodies.drillthrough.OlapDrillthroughReturn;
import crazydev.iccube.olap.goodies.drillthrough.returns.OlapDrillthroughFunctionReturn;
import crazydev.iccube.olap.goodies.drillthrough.returns.OlapDrillthroughIdentifierReturn;
import java.util.ArrayList;
import java.util.List;

public class MdxDrillthroughQueryCompiler
extends MdxEntityCompiler<MdxDrillthroughStatementExpression> {
    public OlapDrillthroughInstr doCompile(OlapCompilationContext context, MdxDrillthroughStatementExpression mdx) {
        MdxStatementExpression selectExpression = mdx.getSelect();
        OlapTopLevelSelectInstr select = (OlapTopLevelSelectInstr)context.compile(selectExpression);
        MdxLongLiteralExpression mdxRowsExpression = mdx.getMaxRows();
        int maxRows = mdxRowsExpression != null ? (int)mdxRowsExpression.value() : context.getProperties().getDrillthroughDefaultMaxRows();
        List<OlapDrillthroughReturn> returns = MdxDrillthroughQueryCompiler.compileReturnStatements(context, mdx.getReturnStatements());
        return new OlapDrillthroughInstr(MdxDrillthroughQueryCompiler.createRange(mdx), maxRows, select, returns);
    }

    public static List<OlapDrillthroughReturn> compileReturnStatements(OlapCompilationContext context, List<MdxDrillthroughReturnExpression> returnStatements) {
        ArrayList<OlapDrillthroughReturn> returns = new ArrayList<OlapDrillthroughReturn>();
        for (MdxDrillthroughReturnExpression returnStatement : returnStatements) {
            if (returnStatement instanceof MdxDrillthroughIdentifierReturnExpression) {
                MdxDrillthroughQueryCompiler.compileIdentifierReturnStatement(context, returns, (MdxDrillthroughIdentifierReturnExpression)returnStatement);
                continue;
            }
            if (returnStatement instanceof MdxDrillthroughFunctionReturnExpression) {
                MdxDrillthroughQueryCompiler.compileFunctionReturnStatement(context, returns, (MdxDrillthroughFunctionReturnExpression)returnStatement);
                continue;
            }
            throw new CdRuntimeException("internal error: unexpected DRILLTHROUGH RETURN type (" + returnStatement.getClass().getName() + ")");
        }
        return returns;
    }

    private static void compileIdentifierReturnStatement(OlapCompilationContext context, List<OlapDrillthroughReturn> returns, MdxDrillthroughIdentifierReturnExpression returnStatement) {
        Object argument = context.compile(returnStatement.getIdentifier());
        returns.add(new OlapDrillthroughIdentifierReturn(returnStatement, (OlapInstr)argument));
    }

    private static void compileFunctionReturnStatement(OlapCompilationContext context, List<OlapDrillthroughReturn> returns, MdxDrillthroughFunctionReturnExpression returnStatement) {
        List<OlapInstr> arguments = MdxDrillthroughQueryCompiler.compileFunctionArguments(context, returnStatement);
        returns.add(OlapDrillthroughFunctionReturn.create(returnStatement, arguments));
    }

    private static List<OlapInstr> compileFunctionArguments(OlapCompilationContext context, MdxDrillthroughFunctionReturnExpression returnStatement) {
        ArrayList<OlapInstr> arguments = new ArrayList<OlapInstr>();
        for (MdxExpression argumentExpression : returnStatement.getArguments()) {
            Object argument = context.compile(argumentExpression);
            arguments.add((OlapInstr)argument);
        }
        return arguments;
    }
}

