/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.compiler.ast.select;

import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.mdx.parser.ast.expression.MdxExpression;
import crazydev.iccube.mdx.parser.ast.expression.literal.MdxFalseLiteralExpression;
import crazydev.iccube.mdx.parser.ast.expression.literal.MdxLongLiteralExpression;
import crazydev.iccube.mdx.parser.ast.expression.literal.MdxStringLiteralExpression;
import crazydev.iccube.mdx.parser.ast.expression.literal.MdxTrueLiteralExpression;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectCategoryProperties;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectCategoryProperty;
import crazydev.iccube.olap.compiler.OlapCompilationContext;
import crazydev.iccube.olap.compiler.exception.OlapCompilationException;
import crazydev.iccube.olap.compiler.exception.OlapCompilationExceptionContext;
import crazydev.iccube.olap.entity.catmember.OlapCategoryHierarchyProperties;
import crazydev.iccube.olap.entity.catmember.OlapCategoryMemberProperties;
import crazydev.iccube.olap.util.OlapCaseInsensitiveName;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public abstract class MdxCreateCategoryExpressionCompilerHelper {
    public static OlapCategoryMemberProperties compileMemberProperties(OlapCompilationContext context, String categoryMemberId, @Nullable MdxSelectCategoryProperties properties) {
        boolean addChildren = false;
        if (properties != null) {
            for (MdxSelectCategoryProperty mdxProperty : properties.getProperties()) {
                if ("ADD_CHILDREN".equalsIgnoreCase(mdxProperty.getResolvedName())) {
                    addChildren = MdxCreateCategoryExpressionCompilerHelper.compileAddChildrenProperty(context, categoryMemberId, mdxProperty.getValue());
                    continue;
                }
                throw new OlapCompilationException(context, OlapErrorCode.CAT_MEMBER_PROPERTY_UNKNOWN, new Serializable[]{categoryMemberId, mdxProperty.getResolvedName()});
            }
        }
        return new OlapCategoryMemberProperties(addChildren);
    }

    private static boolean compileAddChildrenProperty(OlapCompilationExceptionContext context, String id, MdxExpression expression) {
        if (expression instanceof MdxTrueLiteralExpression) {
            return true;
        }
        if (expression instanceof MdxFalseLiteralExpression) {
            return false;
        }
        if (expression instanceof MdxLongLiteralExpression) {
            MdxLongLiteralExpression value = (MdxLongLiteralExpression)expression;
            return value.value() != 0L;
        }
        if (expression instanceof MdxStringLiteralExpression) {
            MdxStringLiteralExpression value = (MdxStringLiteralExpression)expression;
            String svalue = value.value();
            return "true".equalsIgnoreCase(svalue) || "yes".equalsIgnoreCase(svalue);
        }
        throw new OlapCompilationException(context, OlapErrorCode.INVALID_ADD_CHILDREN, new Serializable[]{expression.asMdx(), id});
    }

    public static OlapCategoryHierarchyProperties compileHierarchyProperties(OlapCompilationContext context, String categoryMemberId, @Nullable MdxSelectCategoryProperties properties) {
        String defaultMemberName = "All-M";
        String levelNamePattern = "L - ${hierarchyName} - ${levelDepth}";
        String description = null;
        if (properties != null) {
            for (MdxSelectCategoryProperty mdxProperty : properties.getProperties()) {
                if ("DEFAULT_MEMBER_NAME".equalsIgnoreCase(mdxProperty.getResolvedName())) {
                    defaultMemberName = MdxCreateCategoryExpressionCompilerHelper.compileDefaultMemberNameProperty(context, categoryMemberId, mdxProperty.getValue());
                    continue;
                }
                if ("LEVEL_NAME_PATTERN".equalsIgnoreCase(mdxProperty.getResolvedName())) {
                    levelNamePattern = MdxCreateCategoryExpressionCompilerHelper.compileLevelNamePatternProperty(context, categoryMemberId, mdxProperty.getValue());
                    continue;
                }
                if ("DESCRIPTION".equalsIgnoreCase(mdxProperty.getResolvedName())) {
                    description = MdxCreateCategoryExpressionCompilerHelper.compileDescriptionProperty(context, categoryMemberId, mdxProperty.getValue());
                    continue;
                }
                throw new OlapCompilationException(context, OlapErrorCode.CAT_HIERARCHY_PROPERTY_UNKNOWN, new Serializable[]{categoryMemberId, mdxProperty.getResolvedName()});
            }
        }
        return new OlapCategoryHierarchyProperties(defaultMemberName, levelNamePattern, description);
    }

    private static String compileDefaultMemberNameProperty(OlapCompilationExceptionContext context, String id, MdxExpression expression) {
        if (expression instanceof MdxStringLiteralExpression) {
            MdxStringLiteralExpression value = (MdxStringLiteralExpression)expression;
            String svalue = value.value();
            if (OlapCaseInsensitiveName.equals("all", svalue)) {
                throw new OlapCompilationException(context, OlapErrorCode.INVALID_DEFAULT_MEMBER_NAME_ALL, new Serializable[]{id});
            }
            return svalue;
        }
        throw new OlapCompilationException(context, OlapErrorCode.INVALID_DEFAULT_MEMBER_NAME, new Serializable[]{expression.asMdx(), id});
    }

    private static String compileLevelNamePatternProperty(OlapCompilationExceptionContext context, String id, MdxExpression expression) {
        if (expression instanceof MdxStringLiteralExpression) {
            MdxStringLiteralExpression value = (MdxStringLiteralExpression)expression;
            String svalue = value.value();
            return svalue;
        }
        throw new OlapCompilationException(context, OlapErrorCode.INVALID_LEVEL_NAME_PATTERN, new Serializable[]{expression.asMdx(), id});
    }

    private static String compileDescriptionProperty(OlapCompilationExceptionContext context, String id, MdxExpression expression) {
        if (expression instanceof MdxStringLiteralExpression) {
            MdxStringLiteralExpression value = (MdxStringLiteralExpression)expression;
            String svalue = value.value();
            return svalue;
        }
        throw new OlapCompilationException(context, OlapErrorCode.INVALID_DESCRIPTION, new Serializable[]{expression.asMdx(), id});
    }
}

