/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.compiler.ast.option;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.mdx.scanner.CdMdxToken;
import crazydev.common.mdx.scanner.CdMdxTokenKind;
import crazydev.iccube.mdx.parser.ast.expression.option.MdxOptionExpression;
import crazydev.iccube.olap.compiler.OlapCompilationContext;
import crazydev.iccube.olap.compiler.ast.MdxEntityCompiler;
import crazydev.iccube.olap.entity.option.OlapOption;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.option.OlapOptionInstr;

public class MdxOptionExpressionCompiler
extends MdxEntityCompiler<MdxOptionExpression> {
    @Override
    protected OlapInstr doCompile(OlapCompilationContext context, MdxOptionExpression mdx) {
        CdMdxToken token = mdx.getOption();
        CdMdxTokenKind option = token.getKind();
        OlapInstrLocationRange range = MdxOptionExpressionCompiler.createRange(mdx);
        return switch (option) {
            case CdMdxTokenKind.ADD_TO_RESULT -> new OlapOptionInstr(range, OlapOption.ADD_TO_RESULT);
            case CdMdxTokenKind.AFTER -> new OlapOptionInstr(range, OlapOption.AFTER);
            case CdMdxTokenKind.ALL -> new OlapOptionInstr(range, OlapOption.ALL);
            case CdMdxTokenKind.ASC -> new OlapOptionInstr(range, OlapOption.ASC);
            case CdMdxTokenKind.BASC -> new OlapOptionInstr(range, OlapOption.BASC);
            case CdMdxTokenKind.BDESC -> new OlapOptionInstr(range, OlapOption.BDESC);
            case CdMdxTokenKind.BEFORE -> new OlapOptionInstr(range, OlapOption.BEFORE);
            case CdMdxTokenKind.BEFORE_AND_AFTER -> new OlapOptionInstr(range, OlapOption.BEFORE_AND_AFTER);
            case CdMdxTokenKind.CASE_SENSITIVE -> new OlapOptionInstr(range, OlapOption.CASE_SENSITIVE);
            case CdMdxTokenKind.CASE_INSENSITIVE -> new OlapOptionInstr(range, OlapOption.CASE_INSENSITIVE);
            case CdMdxTokenKind.CONSTRAINED -> new OlapOptionInstr(range, OlapOption.CONSTRAINED);
            case CdMdxTokenKind.DESC -> new OlapOptionInstr(range, OlapOption.DESC);
            case CdMdxTokenKind.EXCLUDEEMPTY -> new OlapOptionInstr(range, OlapOption.EXCLUDEEMPTY);
            case CdMdxTokenKind.INCLUDEEMPTY -> new OlapOptionInstr(range, OlapOption.INCLUDEEMPTY);
            case CdMdxTokenKind.LEAVES -> new OlapOptionInstr(range, OlapOption.LEAVES);
            case CdMdxTokenKind.POST -> new OlapOptionInstr(range, OlapOption.POST);
            case CdMdxTokenKind.RECURSIVE -> new OlapOptionInstr(range, OlapOption.RECURSIVE);
            case CdMdxTokenKind.SELF -> new OlapOptionInstr(range, OlapOption.SELF);
            case CdMdxTokenKind.SELF_AND_AFTER -> new OlapOptionInstr(range, OlapOption.SELF_AND_AFTER);
            case CdMdxTokenKind.SELF_AND_BEFORE -> new OlapOptionInstr(range, OlapOption.SELF_AND_BEFORE);
            case CdMdxTokenKind.SELF_BEFORE_AFTER -> new OlapOptionInstr(range, OlapOption.SELF_BEFORE_AFTER);
            case CdMdxTokenKind.STR_NUMBERS -> new OlapOptionInstr(range, OlapOption.STR_NUMBERS);
            case CdMdxTokenKind.TYPED -> new OlapOptionInstr(range, OlapOption.TYPED);
            default -> throw new CdProgrammingException("Unexpected MDX option '" + String.valueOf(option) + "'");
        };
    }
}

