/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.compiler.ast.command;

import crazydev.common.mdx.scanner.CdMdxToken;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.mdx.parser.ast.expression.MdxExpression;
import crazydev.iccube.mdx.parser.ast.expression.command.MdxExecCommandParamExpression;
import crazydev.iccube.mdx.parser.ast.expression.command.MdxExecCommandStatementExpression;
import crazydev.iccube.mdx.parser.ast.expression.id.MdxIdentifierExpression;
import crazydev.iccube.olap.compiler.OlapCompilationContext;
import crazydev.iccube.olap.compiler.ast.MdxEntityCompiler;
import crazydev.iccube.olap.compiler.exception.OlapCompilationException;
import crazydev.iccube.olap.eval.command.OlapCancelAllRequestsExecCommandStatementInstr;
import crazydev.iccube.olap.eval.command.OlapMdxExecCommandStatementInstr;
import crazydev.iccube.olap.eval.command.OlapResultCacheExecCommandStatementInstr;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import java.io.Serializable;
import java.util.List;

public class MdxExecCommandStatementCompiler
extends MdxEntityCompiler<MdxExecCommandStatementExpression> {
    @Override
    protected OlapInstr doCompile(OlapCompilationContext context, MdxExecCommandStatementExpression mdx) {
        CdMdxToken commandToken = mdx.getCommandName();
        String commandName = commandToken.getLexeme();
        if ("result_cache".equalsIgnoreCase(commandName)) {
            return this.doCompileResultCache(context, mdx);
        }
        if ("cancel_all_requests".equalsIgnoreCase(commandName)) {
            return this.doCompileCancelAllRequests(context, mdx);
        }
        if ("expr".equalsIgnoreCase(commandName)) {
            return this.doCompileExecMdxExpression(context, mdx);
        }
        throw new OlapCompilationException(context, OlapErrorCode.COMMAND_UNKNOWN, new Serializable[]{commandName});
    }

    private OlapInstr doCompileResultCache(OlapCompilationContext context, MdxExecCommandStatementExpression mdx) {
        String option;
        MdxIdentifierExpression id;
        MdxExpression expr;
        List<MdxExecCommandParamExpression> params = mdx.getParams();
        if (params.size() == 1 && (expr = params.get(0).getExpr()) instanceof MdxIdentifierExpression && (id = (MdxIdentifierExpression)expr).isSimple() && "clear".equalsIgnoreCase(option = id.getLastPartAsString())) {
            return new OlapResultCacheExecCommandStatementInstr(MdxExecCommandStatementCompiler.createRange(mdx));
        }
        throw new OlapCompilationException(context, OlapErrorCode.COMMAND_PARAM_ERROR, new Serializable[]{"result_cache"});
    }

    private OlapInstr doCompileCancelAllRequests(OlapCompilationContext context, MdxExecCommandStatementExpression mdx) {
        List<MdxExecCommandParamExpression> params = mdx.getParams();
        if (params.size() == 1) {
            String option;
            MdxIdentifierExpression id;
            MdxExpression expr = params.get(0).getExpr();
            if (expr instanceof MdxIdentifierExpression && (id = (MdxIdentifierExpression)expr).isSimple() && "exclude_load".equalsIgnoreCase(option = id.getLastPartAsString())) {
                return new OlapCancelAllRequestsExecCommandStatementInstr(MdxExecCommandStatementCompiler.createRange(mdx), true);
            }
            throw new OlapCompilationException(context, OlapErrorCode.COMMAND_PARAM_ERROR, new Serializable[]{"cancel_all_requests"});
        }
        return new OlapCancelAllRequestsExecCommandStatementInstr(MdxExecCommandStatementCompiler.createRange(mdx), false);
    }

    private OlapInstr doCompileExecMdxExpression(OlapCompilationContext context, MdxExecCommandStatementExpression mdx) {
        List<MdxExecCommandParamExpression> params = mdx.getParams();
        if (params.size() != 1) {
            throw new OlapCompilationException(context, OlapErrorCode.COMMAND_PARAM_ERROR, new Serializable[]{"expr"});
        }
        MdxExpression expr = params.get(0).getExpr();
        return new OlapMdxExecCommandStatementInstr(MdxExecCommandStatementCompiler.createRange(expr), expr);
    }
}

