/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.compiler;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.iccube.mdx.parser.ast.MdxEntity;
import crazydev.iccube.olap.compiler.OlapCompilationContext;
import crazydev.iccube.olap.compiler.ast.MdxEntityCompiler;
import crazydev.iccube.olap.compiler.ast.action.MdxCreateDrillthroughActionExpressionCompiler;
import crazydev.iccube.olap.compiler.ast.command.MdxExecCommandStatementCompiler;
import crazydev.iccube.olap.compiler.ast.create.MdxCreateCalcMemberStatementCompiler;
import crazydev.iccube.olap.compiler.ast.create.MdxCreateCategoryHierarchyStatementCompiler;
import crazydev.iccube.olap.compiler.ast.create.MdxCreateCategoryMemberStatementCompiler;
import crazydev.iccube.olap.compiler.ast.create.MdxCreateFunctionStatementCompiler;
import crazydev.iccube.olap.compiler.ast.create.MdxCreateMeasureStatementCompiler;
import crazydev.iccube.olap.compiler.ast.create.MdxCreateSetStatementExpressionCompiler;
import crazydev.iccube.olap.compiler.ast.create.MdxDefineDefaultMemberStatementCompiler;
import crazydev.iccube.olap.compiler.ast.create.MdxSetTableAggregatorStatementExpressionCompiler;
import crazydev.iccube.olap.compiler.ast.drop.MdxDropActionStatementCompiler;
import crazydev.iccube.olap.compiler.ast.drop.MdxDropAllStatementCompiler;
import crazydev.iccube.olap.compiler.ast.drop.MdxDropCalcMemberStatementCompiler;
import crazydev.iccube.olap.compiler.ast.drop.MdxDropCategoryHierarchyStatementCompiler;
import crazydev.iccube.olap.compiler.ast.drop.MdxDropCategoryMemberStatementCompiler;
import crazydev.iccube.olap.compiler.ast.drop.MdxDropFunctionStatementCompiler;
import crazydev.iccube.olap.compiler.ast.drop.MdxDropMeasureStatementCompiler;
import crazydev.iccube.olap.compiler.ast.drop.MdxDropSetStatementCompiler;
import crazydev.iccube.olap.compiler.ast.function.MdxDeclaredFunctionArgumentCallExpressionCompiler;
import crazydev.iccube.olap.compiler.ast.function.MdxFunctionCallExpressionCompiler;
import crazydev.iccube.olap.compiler.ast.function.MdxFunctionLongArgArrayWrapperExpressionCompiler;
import crazydev.iccube.olap.compiler.ast.function.MdxFunctionNameExpressionCompiler;
import crazydev.iccube.olap.compiler.ast.function.MdxFunctionStringArgArrayWrapperExpressionCompiler;
import crazydev.iccube.olap.compiler.ast.function.MdxNativeFunctionExpressionCompiler;
import crazydev.iccube.olap.compiler.ast.function.MdxNoFunctionArgExpressionExpressionCompiler;
import crazydev.iccube.olap.compiler.ast.function.MdxSetItemOperatorExpressionCompiler;
import crazydev.iccube.olap.compiler.ast.id.MdxIdentifierExpressionCompiler;
import crazydev.iccube.olap.compiler.ast.literal.MdxAsNamedSetExpressionCompiler;
import crazydev.iccube.olap.compiler.ast.literal.MdxDoubleLiteralExpressionCompiler;
import crazydev.iccube.olap.compiler.ast.literal.MdxFalseLiteralExpressionCompiler;
import crazydev.iccube.olap.compiler.ast.literal.MdxLongLiteralExpressionCompiler;
import crazydev.iccube.olap.compiler.ast.literal.MdxNullLiteralExpressionCompiler;
import crazydev.iccube.olap.compiler.ast.literal.MdxStringLiteralExpressionCompiler;
import crazydev.iccube.olap.compiler.ast.literal.MdxTrueLiteralExpressionCompiler;
import crazydev.iccube.olap.compiler.ast.method.MdxObjectMethodCallExpressionCompiler;
import crazydev.iccube.olap.compiler.ast.operator.MdxBinaryOperatorCallExpressionCompiler;
import crazydev.iccube.olap.compiler.ast.operator.MdxUnaryOperatorCallExpressionCompiler;
import crazydev.iccube.olap.compiler.ast.option.MdxOptionExpressionCompiler;
import crazydev.iccube.olap.compiler.ast.scase.MdxSearchCaseExpressionCompiler;
import crazydev.iccube.olap.compiler.ast.scase.MdxSimpleCaseExpressionCompiler;
import crazydev.iccube.olap.compiler.ast.script.MdxScriptExpressionCompiler;
import crazydev.iccube.olap.compiler.ast.select.MdxCreateCalcMemberExpressionCompiler;
import crazydev.iccube.olap.compiler.ast.select.MdxCreateMeasureExpressionCompiler;
import crazydev.iccube.olap.compiler.ast.select.MdxCreateSetSelectExpressionCompiler;
import crazydev.iccube.olap.compiler.ast.select.MdxDrillthroughQueryCompiler;
import crazydev.iccube.olap.compiler.ast.select.MdxSelectQueryCompiler;
import crazydev.iccube.olap.compiler.ast.set.MdxExistingSetExpressionCompiler;
import crazydev.iccube.olap.compiler.ast.set.MdxSetExpressionCompiler;
import crazydev.iccube.olap.compiler.ast.tuple.MdxTupleOrParenExpressionCompiler;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class OlapCompilerRepository {
    private final Map<Class, MdxEntityCompiler> compilers = new HashMap<Class, MdxEntityCompiler>();

    public OlapCompilerRepository() {
        this.register(new MdxNativeFunctionExpressionCompiler());
        this.register(new MdxAsNamedSetExpressionCompiler());
        this.register(new MdxBinaryOperatorCallExpressionCompiler());
        this.register(new MdxCreateMeasureExpressionCompiler());
        this.register(new MdxCreateCalcMemberExpressionCompiler());
        this.register(new MdxCreateDrillthroughActionExpressionCompiler());
        this.register(new MdxSearchCaseExpressionCompiler());
        this.register(new MdxSimpleCaseExpressionCompiler());
        this.register(new MdxDoubleLiteralExpressionCompiler());
        this.register(new MdxFalseLiteralExpressionCompiler());
        this.register(new MdxFunctionCallExpressionCompiler());
        this.register(new MdxFunctionLongArgArrayWrapperExpressionCompiler());
        this.register(new MdxFunctionStringArgArrayWrapperExpressionCompiler());
        this.register(new MdxDeclaredFunctionArgumentCallExpressionCompiler());
        this.register(new MdxFunctionNameExpressionCompiler());
        this.register(new MdxObjectMethodCallExpressionCompiler());
        this.register(new MdxIdentifierExpressionCompiler());
        this.register(new MdxLongLiteralExpressionCompiler());
        this.register(new MdxCreateSetSelectExpressionCompiler());
        this.register(new MdxNoFunctionArgExpressionExpressionCompiler());
        this.register(new MdxNullLiteralExpressionCompiler());
        this.register(new MdxOptionExpressionCompiler());
        this.register(new MdxDrillthroughQueryCompiler());
        this.register(new MdxSelectQueryCompiler());
        this.register(new MdxSetExpressionCompiler());
        this.register(new MdxExistingSetExpressionCompiler());
        this.register(new MdxSetItemOperatorExpressionCompiler());
        this.register(new MdxStringLiteralExpressionCompiler());
        this.register(new MdxTrueLiteralExpressionCompiler());
        this.register(new MdxTupleOrParenExpressionCompiler());
        this.register(new MdxUnaryOperatorCallExpressionCompiler());
        this.register(new MdxDefineDefaultMemberStatementCompiler());
        this.register(new MdxCreateCategoryHierarchyStatementCompiler());
        this.register(new MdxCreateCategoryMemberStatementCompiler());
        this.register(new MdxCreateCalcMemberStatementCompiler());
        this.register(new MdxCreateMeasureStatementCompiler());
        this.register(new MdxCreateSetStatementExpressionCompiler());
        this.register(new MdxSetTableAggregatorStatementExpressionCompiler());
        this.register(new MdxCreateFunctionStatementCompiler());
        this.register(new MdxDropAllStatementCompiler());
        this.register(new MdxDropActionStatementCompiler());
        this.register(new MdxDropCategoryHierarchyStatementCompiler());
        this.register(new MdxDropCategoryMemberStatementCompiler());
        this.register(new MdxDropCalcMemberStatementCompiler());
        this.register(new MdxDropMeasureStatementCompiler());
        this.register(new MdxDropSetStatementCompiler());
        this.register(new MdxDropFunctionStatementCompiler());
        this.register(new MdxExecCommandStatementCompiler());
        this.register(new MdxScriptExpressionCompiler());
    }

    public OlapInstr compile(OlapCompilationContext context, MdxEntity mdx) {
        MdxEntityCompiler xcompiler = this.get(mdx.getClass());
        return xcompiler.compile(context, mdx);
    }

    protected MdxEntityCompiler get(Class<? extends MdxEntity> clazz) {
        MdxEntityCompiler xcompiler = this.compilers.get(clazz);
        if (xcompiler == null) {
            throw new CdProgrammingException("Missing MDX compiler for [" + clazz.getSimpleName() + "]");
        }
        return xcompiler;
    }

    private void register(MdxEntityCompiler compiler) {
        this.doRegisterWithSuperClass(compiler);
    }

    private void doRegisterWithSuperClass(MdxEntityCompiler compiler) {
        Class<?> clazz = compiler.getClass();
        Type intf = clazz.getGenericSuperclass();
        if (!(intf instanceof ParameterizedType)) {
            throw new CdProgrammingException("Could not register MDX compiler for [" + clazz.getSimpleName() + "]");
        }
        ParameterizedType xintf = (ParameterizedType)intf;
        Type[] args = xintf.getActualTypeArguments();
        if (args.length != 1) {
            throw new CdProgrammingException("Could not register MDX compiler for [" + clazz.getSimpleName() + "]");
        }
        Type arg = args[0];
        if (!(arg instanceof Class)) {
            throw new CdProgrammingException("Could not register MDX compiler for [" + clazz.getSimpleName() + "]");
        }
        Class xarg = (Class)arg;
        if (!MdxEntity.class.isAssignableFrom(xarg)) {
            throw new CdProgrammingException("Could not register MDX compiler for [" + clazz.getSimpleName() + "]");
        }
        this.doRegister(xarg, compiler);
    }

    private void doRegister(Class clazz, MdxEntityCompiler compiler) {
        if (this.compilers.containsKey(clazz)) {
            throw new CdProgrammingException("Inconsistent MDX compiler [" + compiler.getClass().getSimpleName() + "] indexing [" + clazz.getSimpleName() + "]");
        }
        this.compilers.put(clazz, compiler);
    }
}

