/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.compiler;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.thread.CdThreadSupport;
import crazydev.common.thread.CdThreadSupportLevel;
import crazydev.common.xmla.CdXmlaCaller;
import crazydev.iccube.collection.OlapStack;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.configuration.component.properties.OlapVisualMode;
import crazydev.iccube.mdx.parser.ast.MdxEntity;
import crazydev.iccube.olap.compiler.OlapCompilerRepository;
import crazydev.iccube.olap.compiler.ast.MdxEntityCompiler;
import crazydev.iccube.olap.compiler.exception.OlapCompilationExceptionContext;
import crazydev.iccube.olap.entity.properties.cell.OlapCellProperty;
import crazydev.iccube.olap.entity.properties.member.OlapIntrinsicMemberProperty;
import crazydev.iccube.olap.entity.properties.member.OlapIntrinsicMemberPropertyManager;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.function.OlapFunctionRepository;
import crazydev.iccube.olap.eval.function.mdx.OlapDeclaredFunctionParameter;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.method.OlapModuleMethodCallInstrFactory;
import crazydev.iccube.olap.eval.method.OlapModuleMethodsRepository;
import crazydev.iccube.olap.eval.select.tidypostprocessor.OlapTidyPostProcessor;
import crazydev.iccube.olap.eval.select.tidypostprocessor.OlapTidyPostProcessorRepository;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@CdThreadSupport(value=CdThreadSupportLevel.CONDITIONALLY_THREAD_SAFE)
public class OlapCompilationContext
implements OlapCompilationExceptionContext {
    private final OlapCompilerRepository compilers = new OlapCompilerRepository();
    private final OlapIntrinsicMemberPropertyManager memberPropertyManager = new OlapIntrinsicMemberPropertyManager();
    private final CdXmlaCaller caller;
    @Nullable
    private final List<OlapCellProperty> mdxDefaultRequestedCellProperties;
    private final OlapProperties properties;
    private final OlapFunctionRepository functionRepository;
    private final OlapModuleMethodsRepository moduleMethodsRepository;
    private final OlapMdxEntityStack currentMdxEntity = new OlapMdxEntityStack();
    @Nullable
    private String declaredFunctionName;
    @Nullable
    private List<OlapDeclaredFunctionParameter> declaredFunctionArgNames;

    public OlapCompilationContext(CdXmlaCaller caller, @Nullable List<OlapCellProperty> mdxDefaultRequestedCellProperties, OlapProperties properties, OlapFunctionRepository functionRepository, OlapModuleMethodsRepository moduleMethodsRepository) {
        this.caller = caller;
        this.mdxDefaultRequestedCellProperties = mdxDefaultRequestedCellProperties;
        this.properties = properties;
        this.functionRepository = functionRepository;
        this.moduleMethodsRepository = moduleMethodsRepository;
    }

    public CdXmlaCaller getXmlaCaller() {
        return this.caller;
    }

    public boolean isVisualTotals() {
        return this.properties.getVisualMode() == OlapVisualMode.VISUAL_TOTAL;
    }

    public boolean isCompactSetInSubSelect() {
        return this.properties.isCompactSetInSubSelect();
    }

    @Nullable
    public List<OlapCellProperty> getMdxDefaultRequestedCellProperties() {
        return this.mdxDefaultRequestedCellProperties;
    }

    @Override
    @Nullable
    public OlapInstrLocationRange getErrorLocation() {
        if (this.currentMdxEntity.isEmpty()) {
            return null;
        }
        MdxEntity entity = (MdxEntity)this.currentMdxEntity.peek();
        return MdxEntityCompiler.createRange(entity);
    }

    public void pushCurrentMdxEntity(MdxEntity entity) {
        this.currentMdxEntity.push(entity);
    }

    public MdxEntity popCurrentMdxEntity() {
        return (MdxEntity)this.currentMdxEntity.pop();
    }

    public OlapProperties getProperties() {
        return this.properties;
    }

    public <T extends OlapInstr> T compile(MdxEntity mdx) {
        return (T)this.compilers.compile(this, mdx);
    }

    @Nullable
    public OlapInstr compileOptional(@Nullable MdxEntity mdx) {
        if (mdx == null) {
            return null;
        }
        return this.compile(mdx);
    }

    public OlapFunctionRepository getFunctionRepository() {
        return this.functionRepository;
    }

    public OlapFunction lookupExistingRegularFunction(String name) {
        OlapFunction function = this.functionRepository.lookupFunction(name);
        if (function == null || function.isDeclared()) {
            throw new CdProgrammingException("internal error : unknown function [" + name + "]");
        }
        return function;
    }

    @Nullable
    public OlapFunction lookupRegularFunction(String name) {
        OlapFunction function = this.functionRepository.lookupFunction(name);
        if (function == null || function.isDeclared()) {
            return null;
        }
        return function;
    }

    @Nullable
    public OlapModuleMethodCallInstrFactory lookupModuleMethods(String name) {
        return this.moduleMethodsRepository.lookupModule(name);
    }

    @Nullable
    public OlapIntrinsicMemberProperty getIntrinsicProperty(String name) {
        return this.memberPropertyManager.getIntrinsicProperty(name);
    }

    @Nullable
    public String getDeclaredFunctionName() {
        return this.declaredFunctionName;
    }

    @Nullable
    public OlapDeclaredFunctionParameter getDeclaredFunctionParameter(String name) {
        List<OlapDeclaredFunctionParameter> argNames = this.declaredFunctionArgNames;
        if (argNames != null) {
            for (int idx = 0; idx < argNames.size(); ++idx) {
                OlapDeclaredFunctionParameter argName = argNames.get(idx);
                if (!name.equalsIgnoreCase(argName.getName())) continue;
                return argName;
            }
        }
        return null;
    }

    public void setDeclaredFunction(String function, List<OlapDeclaredFunctionParameter> argNames) {
        this.declaredFunctionName = function;
        this.declaredFunctionArgNames = argNames;
    }

    public void resetDeclaredFunction() {
        this.declaredFunctionName = null;
        this.declaredFunctionArgNames = null;
    }

    @Nullable
    public OlapTidyPostProcessor getTidyPostProcessor(String name) {
        return OlapTidyPostProcessorRepository.INSTANCE.getTidyPostProcessor(name);
    }

    static class OlapMdxEntityStack
    extends OlapStack<MdxEntity> {
        OlapMdxEntityStack() {
        }
    }
}

