/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.notification;

import crazydev.iccube.notification.IOlapNotificationListener;
import crazydev.iccube.notification.OlapNotificationServiceException;
import crazydev.iccube.notification.definition.OlapNotificationServiceDefinition;
import jakarta.mail.internet.InternetAddress;
import java.io.File;
import java.io.Serializable;
import java.util.Date;
import org.jetbrains.annotations.Nullable;

public abstract class OlapNotificationService {
    @Nullable
    private File xml;

    protected OlapNotificationService() {
    }

    public void configure(OlapNotificationServiceDefinition definition) throws OlapNotificationServiceException {
        this.xml = definition.getXmlFile();
    }

    @Nullable
    public File getConfigurationFile() {
        return this.xml;
    }

    public abstract void stop();

    public void onInternalError(String message) {
        this.onInternalError(message, null);
    }

    public abstract void onInternalError(String var1, @Nullable Throwable var2);

    public abstract void onLicenseExpiryWarning(@Nullable IOlapNotificationListener var1, Date var2);

    public abstract void onServerReady();

    public abstract void onSchemaFullLoad(String var1, String var2, String var3);

    public abstract void onSchemaIncrementalLoad(String var1, String var2, String var3);

    public abstract void onSchemaUnload(String var1, String var2, String var3);

    public abstract void onSchemaIncrementalLoadDeActivated(String var1, String var2, String var3);

    public abstract void onSchemaLoadCancelled(String var1, String var2, String var3);

    public abstract void onSchemaFullLoadError(String var1, String var2, String var3);

    public abstract void onSchemaIncrementalLoadError(String var1, String var2, String var3);

    public abstract void onSchemaLoadError(String var1, String var2, String var3);

    public abstract void onSchemaUnloadPartitions(String var1, String var2, String var3);

    public abstract void onSchemaLoadPartitions(String var1, String var2, String var3);

    public abstract void onSchemaLoadPartitionsFailed(String var1, String var2, String var3);

    public abstract void onSchemaLoadPartitionsError(String var1, String var2, String var3);

    public abstract void onAlert(@Nullable IOlapNotificationListener var1, boolean var2, @Nullable InternetAddress[] var3, String var4, String var5, @Nullable Serializable var6, @Nullable String var7);
}

