/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.notification;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.notification.OlapNotification;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.Nullable;

public class OlapNotificationFilter {
    @Nullable
    private final Pattern levelPattern;
    @Nullable
    private final String level;
    @Nullable
    private final Pattern typePattern;
    @Nullable
    private final String type;
    @Nullable
    private final Pattern schemaPattern;
    @Nullable
    private final String schema;

    public OlapNotificationFilter(@Nullable String level, @Nullable String type, @Nullable String schema) throws PatternSyntaxException {
        this.levelPattern = !CdStringUtils.isNullOrBlank((String)level) ? Pattern.compile(level) : null;
        this.level = level;
        this.typePattern = !CdStringUtils.isNullOrBlank((String)type) ? Pattern.compile(type) : null;
        this.type = type;
        this.schemaPattern = !CdStringUtils.isNullOrBlank((String)schema) ? Pattern.compile(schema) : null;
        this.schema = schema;
    }

    public static String asLogInfo(@Nullable OlapNotificationFilter filter) {
        if (filter == null) {
            return "accepting all notifications";
        }
        return filter.asLogInfo();
    }

    public String asLogInfo() {
        Object info = "accepting";
        if (this.level != null) {
            info = (String)info + " [level:" + this.level + "]";
        }
        if (this.type != null) {
            info = (String)info + " [type:" + this.type + "]";
        }
        if (this.schema != null) {
            info = (String)info + " [schema :" + this.schema + "]";
        }
        if (this.level == null && this.type == null && this.schema == null) {
            info = (String)info + " all notifications";
            return info;
        }
        return info;
    }

    public boolean accepts(OlapNotification notification) {
        String notificationSchema;
        String notificationType;
        String notificationLevel;
        if (this.levelPattern != null && !this.levelPattern.matcher(notificationLevel = notification.getLevel().name()).matches()) {
            return false;
        }
        if (this.typePattern != null && !this.typePattern.matcher(notificationType = notification.getType().name()).matches()) {
            return false;
        }
        return this.schemaPattern == null || (notificationSchema = notification.getSchema()) != null && this.schemaPattern.matcher(notificationSchema).matches();
    }
}

