/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.notification;

import crazydev.common.utils.CdExceptionUtils;
import crazydev.iccube.common.executor.OlapThreadFactory;
import crazydev.iccube.notification.IOlapNotificationListener;
import crazydev.iccube.notification.OlapNotification;
import crazydev.iccube.notification.OlapNotificationFilter;
import crazydev.iccube.notification.OlapNotificationLevel;
import crazydev.iccube.notification.OlapNotificationParams;
import crazydev.iccube.notification.OlapNotificationServerId;
import crazydev.iccube.notification.OlapNotificationService;
import crazydev.iccube.notification.OlapNotificationServiceException;
import crazydev.iccube.notification.OlapNotificationServiceListener;
import crazydev.iccube.notification.OlapNotificationServiceListeners;
import crazydev.iccube.notification.OlapNotificationServiceTransporter;
import crazydev.iccube.notification.OlapNotificationType;
import crazydev.iccube.notification.definition.OlapNotificationFilterDefinition;
import crazydev.iccube.notification.definition.OlapNotificationServiceDefinition;
import crazydev.iccube.notification.definition.OlapNotificationServiceListenerDefinition;
import crazydev.iccube.notification.definition.OlapNotificationTransporterDefinition;
import crazydev.iccube.notification.transporter.OlapNotificationTransportService;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.version.OlapVersion;
import jakarta.mail.internet.InternetAddress;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.Nullable;

public class OlapNotificationDefaultService
extends OlapNotificationService {
    private static final AtomicReference<String> hostname = new AtomicReference();
    private final ExecutorService executorService;
    private final OlapNotificationServiceListeners listeners = new OlapNotificationServiceListeners();
    private final String serverId;
    private final List<OlapNotificationTransportService> services;
    private int awaitTermination = 0;

    public OlapNotificationDefaultService(String serverId, List<OlapNotificationTransportService> services) {
        this.executorService = Executors.newFixedThreadPool(1, new OlapThreadFactory("notification"));
        this.serverId = serverId;
        this.services = services;
    }

    private static String getOrCreateHostname() {
        String name = hostname.get();
        if (name != null) {
            return name;
        }
        try {
            name = InetAddress.getLocalHost().getHostName();
            hostname.set(name);
        }
        catch (UnknownHostException ex) {
            name = "localhost";
            hostname.set("localhost");
        }
        return name;
    }

    @Override
    public void configure(OlapNotificationServiceDefinition definition) throws OlapNotificationServiceException {
        super.configure(definition);
        this.awaitTermination = definition.getAwaitTermination();
        List<OlapNotificationServiceListenerDefinition> definitions = definition.getListeners();
        if (definitions != null) {
            for (OlapNotificationServiceListenerDefinition listenerDefinition : definitions) {
                this.configureListener(listenerDefinition);
            }
        }
    }

    private void configureListener(OlapNotificationServiceListenerDefinition definition) throws OlapNotificationServiceException {
        OlapNotificationFilterDefinition filterDefinition = definition.getFilter();
        OlapNotificationFilter filter = this.configureFilter(filterDefinition);
        List<OlapNotificationTransporterDefinition> transporterDefinitions = definition.getTransporters();
        List<OlapNotificationServiceTransporter> transporters = this.configureTransporters(transporterDefinitions);
        OlapNotificationServiceListener listener = new OlapNotificationServiceListener(filter, transporters);
        this.listeners.add(listener);
    }

    private OlapNotificationFilter configureFilter(OlapNotificationFilterDefinition definition) {
        return new OlapNotificationFilter(definition.getStatus(), definition.getType(), definition.getSchema());
    }

    private List<OlapNotificationServiceTransporter> configureTransporters(List<OlapNotificationTransporterDefinition> definitions) throws OlapNotificationServiceException {
        ArrayList<OlapNotificationServiceTransporter> transporters = new ArrayList<OlapNotificationServiceTransporter>();
        for (OlapNotificationTransporterDefinition definition : definitions) {
            OlapNotificationServiceTransporter transporter = this.configureTransporter(definition);
            transporters.add(transporter);
        }
        return transporters;
    }

    private OlapNotificationServiceTransporter configureTransporter(OlapNotificationTransporterDefinition definition) throws OlapNotificationServiceException {
        String serviceId = definition.getService();
        for (OlapNotificationTransportService service : this.services) {
            if (!service.getId().equals(serviceId)) continue;
            OlapNotificationServiceTransporter transporter = service.transporter(definition);
            return transporter;
        }
        throw new OlapNotificationServiceException("missing transport service [" + serviceId + "] referenced by transporter [" + definition.getId() + "]");
    }

    public List<OlapNotificationTransportService> getServices() {
        return this.services;
    }

    @Override
    public void stop() {
        OlapLoggers.NOTIFICATION.info((Object)("[notification] shutting down (possibly waiting for " + this.awaitTermination + "sec)"));
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(this.awaitTermination, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        OlapLoggers.NOTIFICATION.info((Object)"[notification] shutting down now");
        if (!this.executorService.isTerminated()) {
            this.executorService.shutdownNow();
        }
        OlapLoggers.NOTIFICATION.info((Object)"[notification] bye");
    }

    @Override
    public void onInternalError(String message, @Nullable Throwable exception) {
        OlapNotificationParams params = new OlapNotificationParams();
        params.setParam("Version", (Serializable)((Object)OlapVersion.get().asString()));
        params.setParam("Internal Error Message", (Serializable)((Object)message));
        if (exception != null) {
            params.setParam("Internal Error Exception", (Serializable)((Object)CdExceptionUtils.getStackTraceAsString((Throwable)exception)));
        }
        this.notify(null, OlapNotificationLevel.ERROR, OlapNotificationType.INTERNAL_ERROR, params);
    }

    @Override
    public void onLicenseExpiryWarning(@Nullable IOlapNotificationListener callback, Date expiryDate) {
        OlapNotificationParams params = new OlapNotificationParams();
        params.setParam("Message", (Serializable)((Object)("The license is about to expire ( " + expiryDate.toString() + " ); please contact your support administrator.")));
        this.notify(callback, OlapNotificationLevel.INFO, OlapNotificationType.LICENSE_EXPIRY_WARNING, params);
    }

    @Override
    public void onServerReady() {
        this.notify(null, OlapNotificationLevel.INFO, OlapNotificationType.SERVER_READY);
    }

    @Override
    public void onSchemaFullLoad(String requestUUID, String userName, String schemaName) {
        OlapNotificationParams params = this.createNotificationParams(requestUUID, userName, schemaName);
        this.notify(null, OlapNotificationLevel.INFO, OlapNotificationType.SCHEMA_FULL_LOAD, params);
    }

    private OlapNotificationParams createNotificationParams(String requestUUID, String userName, String schemaName) {
        OlapNotificationParams params = new OlapNotificationParams();
        params.setParam("Request UUID", (Serializable)((Object)requestUUID));
        params.setParam("User", (Serializable)((Object)userName));
        params.setParam("Schema", (Serializable)((Object)schemaName));
        return params;
    }

    @Override
    public void onSchemaIncrementalLoad(String requestUUID, String userName, String schemaName) {
        OlapNotificationParams params = this.createNotificationParams(requestUUID, userName, schemaName);
        this.notify(null, OlapNotificationLevel.INFO, OlapNotificationType.SCHEMA_INCREMENTAL_LOAD, params);
    }

    @Override
    public void onSchemaUnload(String requestUUID, String userName, String schemaName) {
        OlapNotificationParams params = this.createNotificationParams(requestUUID, userName, schemaName);
        this.notify(null, OlapNotificationLevel.INFO, OlapNotificationType.SCHEMA_UNLOAD, params);
    }

    @Override
    public void onSchemaIncrementalLoadDeActivated(String requestUUID, String userName, String schemaName) {
        OlapNotificationParams params = this.createNotificationParams(requestUUID, userName, schemaName);
        this.notify(null, OlapNotificationLevel.WARNING, OlapNotificationType.SCHEMA_INCREMENTAL_LOAD_DEACTIVATED, params);
    }

    @Override
    public void onSchemaLoadCancelled(String requestUUID, String userName, String schemaName) {
        OlapNotificationParams params = this.createNotificationParams(requestUUID, userName, schemaName);
        this.notify(null, OlapNotificationLevel.WARNING, OlapNotificationType.SCHEMA_LOAD_CANCELLED, params);
    }

    @Override
    public void onSchemaFullLoadError(String requestUUID, String userName, String schemaName) {
        OlapNotificationParams params = this.createNotificationParams(requestUUID, userName, schemaName);
        this.notify(null, OlapNotificationLevel.ERROR, OlapNotificationType.SCHEMA_FULL_LOAD_ERROR, params);
    }

    @Override
    public void onSchemaIncrementalLoadError(String requestUUID, String userName, String schemaName) {
        OlapNotificationParams params = this.createNotificationParams(requestUUID, userName, schemaName);
        this.notify(null, OlapNotificationLevel.ERROR, OlapNotificationType.SCHEMA_INCREMENTAL_LOAD_ERROR, params);
    }

    @Override
    public void onSchemaLoadError(String requestUUID, String userName, String schemaName) {
        OlapNotificationParams params = this.createNotificationParams(requestUUID, userName, schemaName);
        this.notify(null, OlapNotificationLevel.ERROR, OlapNotificationType.SCHEMA_LOAD_ERROR, params);
    }

    @Override
    public void onSchemaUnloadPartitions(String requestUUID, String userName, String schemaName) {
        OlapNotificationParams params = this.createNotificationParams(requestUUID, userName, schemaName);
        this.notify(null, OlapNotificationLevel.INFO, OlapNotificationType.SCHEMA_PARTITIONS_UNLOADED, params);
    }

    @Override
    public void onSchemaLoadPartitions(String requestUUID, String userName, String schemaName) {
        OlapNotificationParams params = this.createNotificationParams(requestUUID, userName, schemaName);
        this.notify(null, OlapNotificationLevel.INFO, OlapNotificationType.SCHEMA_PARTITIONS_LOADED, params);
    }

    @Override
    public void onSchemaLoadPartitionsFailed(String requestUUID, String userName, String schemaName) {
        OlapNotificationParams params = this.createNotificationParams(requestUUID, userName, schemaName);
        this.notify(null, OlapNotificationLevel.ERROR, OlapNotificationType.SCHEMA_PARTITIONS_LOAD_FAILED, params);
    }

    @Override
    public void onSchemaLoadPartitionsError(String requestUUID, String userName, String schemaName) {
        OlapNotificationParams params = this.createNotificationParams(requestUUID, userName, schemaName);
        this.notify(null, OlapNotificationLevel.ERROR, OlapNotificationType.SCHEMA_PARTITIONS_LOAD_ERROR, params);
    }

    @Override
    public void onAlert(@Nullable IOlapNotificationListener callback, boolean onError, @Nullable InternetAddress[] toAddresses, String subject, String body, @Nullable Serializable attachment, @Nullable String attachmentName) {
        if (OlapLoggers.NOTIFICATION.isDebugEnabled()) {
            OlapLoggers.NOTIFICATION.debug((Object)("[notification] alert received : " + subject));
        }
        OlapNotificationParams params = new OlapNotificationParams();
        if (toAddresses != null) {
            params.setParam("Alert To", (Serializable)toAddresses);
        }
        params.setParam("Alert Subject", (Serializable)((Object)subject));
        params.setParam("Alert Body", (Serializable)((Object)body));
        if (attachment != null) {
            params.setParam("Alert Attachment", attachment);
        }
        if (attachmentName != null) {
            params.setParam("Alert Attachment Name", (Serializable)((Object)attachmentName));
        }
        OlapNotificationLevel level = !onError ? OlapNotificationLevel.INFO : OlapNotificationLevel.ERROR;
        this.notify(callback, level, OlapNotificationType.ALERT, params);
    }

    protected void notify(@Nullable IOlapNotificationListener callback, OlapNotificationLevel level, OlapNotificationType type) {
        this.notify(callback, level, type, null);
    }

    protected void notify(@Nullable IOlapNotificationListener callback, OlapNotificationLevel level, OlapNotificationType type, @Nullable OlapNotificationParams params) {
        try {
            this.executorService.submit(new Task(this, callback, level, type, params));
        }
        catch (RuntimeException ex) {
            OlapLoggers.NOTIFICATION.error((Object)("[notification] could not properly submit the notification [" + String.valueOf(level) + "][" + String.valueOf(type) + "]"), (Throwable)ex);
        }
    }

    class Task
    implements Runnable {
        @Nullable
        private final IOlapNotificationListener callback;
        private final OlapNotificationLevel level;
        private final OlapNotificationType type;
        private final OlapNotificationParams params;
        final /* synthetic */ OlapNotificationDefaultService this$0;

        Task(@Nullable OlapNotificationDefaultService this$0, IOlapNotificationListener callback, OlapNotificationLevel level, @Nullable OlapNotificationType type, OlapNotificationParams params) {
            OlapNotificationDefaultService olapNotificationDefaultService = this$0;
            Objects.requireNonNull(olapNotificationDefaultService);
            this.this$0 = olapNotificationDefaultService;
            this.callback = callback;
            this.level = level;
            this.type = type;
            this.params = params != null ? params : new OlapNotificationParams();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                OlapNotificationServiceListener[] listenerList = this.this$0.listeners.getListenerList();
                if (listenerList.length == 0) {
                    return;
                }
                OlapNotificationServerId id = new OlapNotificationServerId(OlapNotificationDefaultService.getOrCreateHostname(), this.this$0.serverId);
                OlapNotification notification = new OlapNotification(id, this.level, this.type, this.params);
                for (int ii = 0; ii < listenerList.length; ++ii) {
                    listenerList[ii].onNotification(notification);
                }
                if (this.callback != null) {
                    this.callback.onNotified();
                }
            }
            catch (RuntimeException ex) {
                OlapLoggers.NOTIFICATION.error((Object)("[notification] could not properly handle the notification [" + String.valueOf(this.level) + "][" + String.valueOf(this.type) + "]"), (Throwable)ex);
            }
            finally {
                if (this.callback != null) {
                    this.callback.onFinally();
                }
            }
        }
    }
}

