/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.mdx.parser.excel;

import crazydev.common.mdx.scanner.exception.CdMdxScannerException;
import crazydev.common.mdx.scanner.token.CdMdxIdentifierToken;
import crazydev.iccube.mdx.parser.MdxParser;
import crazydev.iccube.mdx.parser.MdxParsingContext;
import crazydev.iccube.mdx.parser.ast.expression.MdxExpression;
import crazydev.iccube.mdx.parser.ast.expression.id.MdxIdentifierExpression;
import crazydev.iccube.mdx.parser.ast.expression.set.MdxAsNamedSetExpression;
import crazydev.iccube.mdx.parser.ast.statement.MdxStatementExpression;
import crazydev.iccube.mdx.parser.exception.MdxParserException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class MdxExcelFixFilterHelperSet {
    @Nullable
    public static String fixMdxStatement(MdxParsingContext context, String mdx, String mdxHash) throws IOException, CdMdxScannerException, MdxParserException {
        HashMap<String, MdxAsNamedSetExpression> asNamedExpressions = new HashMap<String, MdxAsNamedSetExpression>();
        MdxStatementExpression query = MdxParser.parseMdxStatement(context, mdx, mdxHash);
        boolean ok = MdxExcelFixFilterHelperSet.lookupFilterHelperSets(asNamedExpressions, query);
        if (!ok) {
            return null;
        }
        String fixedMdx = mdx;
        for (Map.Entry entry : asNamedExpressions.entrySet()) {
            String name = (String)entry.getKey();
            MdxAsNamedSetExpression expression = (MdxAsNamedSetExpression)entry.getValue();
            String fix = expression.getExpr().asMdx();
            fixedMdx = fixedMdx.replaceFirst(", *\\[" + name + "\\]", ", " + fix);
        }
        return fixedMdx;
    }

    private static boolean lookupFilterHelperSets(Map<String, MdxAsNamedSetExpression> asNamedExpressions, MdxExpression expression) {
        CdMdxIdentifierToken id;
        MdxAsNamedSetExpression asNamedSetExpression;
        MdxIdentifierExpression nameSetId;
        if (expression instanceof MdxAsNamedSetExpression && (nameSetId = (asNamedSetExpression = (MdxAsNamedSetExpression)expression).getNamedSetId()).getParts().size() == 1 && !(id = nameSetId.getParts().get(0)).isKey() && id.getIdentifier().startsWith("XL_Filter_HelperSet_")) {
            return asNamedExpressions.put(id.getIdentifier(), asNamedSetExpression) == null;
        }
        List<MdxExpression> children = expression.getChildren();
        boolean ok = true;
        for (MdxExpression child : children) {
            ok &= MdxExcelFixFilterHelperSet.lookupFilterHelperSets(asNamedExpressions, child);
        }
        return ok;
    }
}

