/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.mdx.parser.ast.select;

import crazydev.common.mdx.scanner.CdMdxToken;
import crazydev.iccube.mdx.parser.ast.expression.MdxExpression;
import crazydev.iccube.mdx.parser.ast.expression.annotation.MdxAnnotation;
import crazydev.iccube.mdx.parser.ast.expression.id.MdxIdentifierExpression;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectCalcMember;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectCategoryHierarchy;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectCategoryMember;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectCellPropertyListClause;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectEntity;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectExtraAxisClause;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectExtraAxisClauses;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectFilterByClause;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectFilterByClauses;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectFunction;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectMeasure;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectNamedSet;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectQueryAxisClause;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectSlicerAxisClause;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectTidyPostProcessorClause;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectTidyPostProcessorClauses;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectWithClause;
import crazydev.iccube.mdx.parser.ast.statement.MdxStatementExpression;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class MdxSelectStatementExpression
extends MdxStatementExpression {
    private final String mdx;
    private final CdMdxToken firstToken;
    private final boolean nonVisual;
    private final List<MdxSelectMeasure> measureWithClauses;
    private final List<MdxSelectCalcMember> calcMemberWithClauses;
    private final List<MdxSelectNamedSet> namedSetWithClauses;
    private final List<MdxSelectFunction> functionWithClauses;
    private final List<MdxSelectCategoryHierarchy> categoryHierarchyWithClauses;
    private final List<MdxSelectCategoryMember> categoryMemberWithClauses;
    @Nullable
    private final List<MdxAnnotation> annotations;
    private final List<MdxSelectQueryAxisClause> queryAxisClauses;
    @Nullable
    private final MdxSelectSlicerAxisClause slicerAxisClause;
    private final MdxExpression subSelectClause;
    @Nullable
    private final MdxSelectCellPropertyListClause cellPropertyListClause;
    @Nullable
    private MdxSelectFilterByClauses filterByClauses;
    @Nullable
    private MdxSelectExtraAxisClauses extraAxisClauses;
    @Nullable
    private MdxSelectTidyPostProcessorClauses tidyPostProcessorClauses;

    public MdxSelectStatementExpression(String mdx, CdMdxToken firstToken, boolean nonVisual, @Nullable List<MdxSelectWithClause> withClauses, @Nullable List<MdxAnnotation> annotations, List<MdxSelectQueryAxisClause> queryAxisClauses, @Nullable MdxSelectSlicerAxisClause slicerAxisClause, MdxExpression subSelectClause, @Nullable MdxSelectCellPropertyListClause cellPropertyListClause, @Nullable MdxSelectFilterByClauses filterByClauses, @Nullable MdxSelectExtraAxisClauses extraAxisClauses, @Nullable MdxSelectTidyPostProcessorClauses tidyPostProcessorClauses) {
        this.mdx = mdx;
        this.firstToken = firstToken;
        this.nonVisual = nonVisual;
        this.measureWithClauses = MdxSelectStatementExpression.extractMeasures(withClauses);
        this.calcMemberWithClauses = MdxSelectStatementExpression.extractCalcMembers(withClauses);
        this.namedSetWithClauses = MdxSelectStatementExpression.extractNamedSets(withClauses);
        this.functionWithClauses = MdxSelectStatementExpression.extractFunctions(withClauses);
        this.categoryHierarchyWithClauses = MdxSelectStatementExpression.extractCategoryHierarchies(withClauses);
        this.categoryMemberWithClauses = MdxSelectStatementExpression.extractCategoryMembers(withClauses);
        this.annotations = annotations;
        this.queryAxisClauses = queryAxisClauses;
        this.slicerAxisClause = slicerAxisClause;
        this.subSelectClause = subSelectClause;
        this.cellPropertyListClause = cellPropertyListClause;
        this.filterByClauses = filterByClauses;
        this.extraAxisClauses = extraAxisClauses;
        this.tidyPostProcessorClauses = tidyPostProcessorClauses;
    }

    @Override
    public List<MdxExpression> getChildren() {
        List<MdxSelectEntity> clauses;
        ArrayList<MdxExpression> children = new ArrayList<MdxExpression>();
        for (MdxSelectMeasure measureWithClause : this.measureWithClauses) {
            children.add(measureWithClause.getId());
            children.add(measureWithClause.getFormula());
        }
        for (MdxSelectCalcMember calcMemberWithClause : this.calcMemberWithClauses) {
            children.add(calcMemberWithClause.getId());
            children.add(calcMemberWithClause.getFormula());
        }
        for (MdxSelectNamedSet namedSetWithClause : this.namedSetWithClauses) {
            children.add(namedSetWithClause.getId());
            children.add(namedSetWithClause.getFormula());
        }
        for (MdxSelectFunction functionWithClause : this.functionWithClauses) {
            children.add(functionWithClause.getName());
            children.add(functionWithClause.getBody());
        }
        for (MdxSelectCategoryHierarchy categoryHierarchyWithClause : this.categoryHierarchyWithClauses) {
            children.add(categoryHierarchyWithClause.getId());
        }
        for (MdxSelectCategoryMember categoryMemberWithClause : this.categoryMemberWithClauses) {
            children.add(categoryMemberWithClause.getId());
            children.add(categoryMemberWithClause.getFormula());
        }
        for (MdxSelectQueryAxisClause queryAxisClause : this.queryAxisClauses) {
            children.add(queryAxisClause.getExpression());
        }
        children.addAll(this.subSelectClause.getChildren());
        if (this.slicerAxisClause != null) {
            children.add(this.slicerAxisClause.getExpr());
        }
        if (this.filterByClauses != null) {
            clauses = this.filterByClauses.getClauses();
            for (MdxSelectEntity clause : clauses) {
                children.add(((MdxSelectFilterByClause)clause).getExpression());
            }
        }
        if (this.extraAxisClauses != null) {
            clauses = this.extraAxisClauses.getClauses();
            for (MdxSelectEntity clause : clauses) {
                children.add(((MdxSelectQueryAxisClause)clause).getExpression());
            }
        }
        return children;
    }

    public boolean isNonVisual() {
        return this.nonVisual;
    }

    @Override
    public CdMdxToken getFirstToken() {
        return this.firstToken;
    }

    @Override
    protected CdMdxToken doGetLastToken() {
        if (this.filterByClauses != null) {
            return this.filterByClauses.getLastToken();
        }
        if (this.cellPropertyListClause != null) {
            return this.cellPropertyListClause.getLastToken();
        }
        if (this.slicerAxisClause != null) {
            return this.slicerAxisClause.getLastToken();
        }
        if (this.extraAxisClauses != null) {
            return this.extraAxisClauses.getLastToken();
        }
        if (this.tidyPostProcessorClauses != null) {
            return this.tidyPostProcessorClauses.getLastToken();
        }
        return this.subSelectClause.getLastToken();
    }

    private static List<MdxSelectMeasure> extractMeasures(@Nullable List<MdxSelectWithClause> withClauses) {
        ArrayList<MdxSelectMeasure> cmembers = new ArrayList<MdxSelectMeasure>();
        if (withClauses != null) {
            for (MdxSelectWithClause withClause : withClauses) {
                if (!(withClause instanceof MdxSelectMeasure)) continue;
                cmembers.add((MdxSelectMeasure)withClause);
            }
        }
        return cmembers;
    }

    private static List<MdxSelectCalcMember> extractCalcMembers(@Nullable List<MdxSelectWithClause> withClauses) {
        ArrayList<MdxSelectCalcMember> cmembers = new ArrayList<MdxSelectCalcMember>();
        if (withClauses != null) {
            for (MdxSelectWithClause withClause : withClauses) {
                if (!(withClause instanceof MdxSelectCalcMember)) continue;
                cmembers.add((MdxSelectCalcMember)withClause);
            }
        }
        return cmembers;
    }

    private static List<MdxSelectNamedSet> extractNamedSets(@Nullable List<MdxSelectWithClause> withClauses) {
        ArrayList<MdxSelectNamedSet> cmembers = new ArrayList<MdxSelectNamedSet>();
        if (withClauses != null) {
            for (MdxSelectWithClause withClause : withClauses) {
                if (!(withClause instanceof MdxSelectNamedSet)) continue;
                cmembers.add((MdxSelectNamedSet)withClause);
            }
        }
        return cmembers;
    }

    private static List<MdxSelectFunction> extractFunctions(@Nullable List<MdxSelectWithClause> withClauses) {
        ArrayList<MdxSelectFunction> functions = new ArrayList<MdxSelectFunction>();
        if (withClauses != null) {
            for (MdxSelectWithClause withClause : withClauses) {
                if (!(withClause instanceof MdxSelectFunction)) continue;
                functions.add((MdxSelectFunction)withClause);
            }
        }
        return functions;
    }

    private static List<MdxSelectCategoryHierarchy> extractCategoryHierarchies(@Nullable List<MdxSelectWithClause> withClauses) {
        ArrayList<MdxSelectCategoryHierarchy> hierarchies = new ArrayList<MdxSelectCategoryHierarchy>();
        if (withClauses != null) {
            for (MdxSelectWithClause withClause : withClauses) {
                if (!(withClause instanceof MdxSelectCategoryHierarchy)) continue;
                hierarchies.add((MdxSelectCategoryHierarchy)withClause);
            }
        }
        return hierarchies;
    }

    private static List<MdxSelectCategoryMember> extractCategoryMembers(@Nullable List<MdxSelectWithClause> withClauses) {
        ArrayList<MdxSelectCategoryMember> members = new ArrayList<MdxSelectCategoryMember>();
        if (withClauses != null) {
            for (MdxSelectWithClause withClause : withClauses) {
                if (!(withClause instanceof MdxSelectCategoryMember)) continue;
                members.add((MdxSelectCategoryMember)withClause);
            }
        }
        return members;
    }

    public String getMdx() {
        return this.mdx;
    }

    public List<MdxSelectMeasure> getMeasureWithClauses() {
        return this.measureWithClauses;
    }

    public List<MdxSelectCalcMember> getCalcMembersWithClauses() {
        return this.calcMemberWithClauses;
    }

    public List<MdxSelectNamedSet> getNamedSetWithClauses() {
        return this.namedSetWithClauses;
    }

    public List<MdxSelectFunction> getFunctionWithClauses() {
        return this.functionWithClauses;
    }

    public List<MdxSelectCategoryHierarchy> getCategoryHierarchyWithClauses() {
        return this.categoryHierarchyWithClauses;
    }

    public List<MdxSelectCategoryMember> getCategoryMemberWithClauses() {
        return this.categoryMemberWithClauses;
    }

    @Nullable
    public List<MdxAnnotation> getAnnotations() {
        return this.annotations;
    }

    public void addFilterByAxes(List<MdxSelectQueryAxisClause> filterBy) {
        this.queryAxisClauses.addAll(filterBy);
    }

    public List<MdxSelectQueryAxisClause> getQueryAxisClauses() {
        return this.queryAxisClauses;
    }

    public int getQueryAxisClausesCount() {
        return this.queryAxisClauses.size();
    }

    @Nullable
    public MdxSelectSlicerAxisClause getSlicerAxisClause() {
        return this.slicerAxisClause;
    }

    public MdxExpression getSubSelectClause() {
        return this.subSelectClause;
    }

    @Nullable
    public MdxSelectCellPropertyListClause getCellPropertyListClause() {
        return this.cellPropertyListClause;
    }

    @Nullable
    public MdxSelectFilterByClauses getFilterByClauses() {
        return this.filterByClauses;
    }

    @Nullable
    public MdxSelectExtraAxisClauses getExtraAxisClauses() {
        return this.extraAxisClauses;
    }

    @Nullable
    public MdxSelectTidyPostProcessorClauses getTidyPostProcessorClauses() {
        return this.tidyPostProcessorClauses;
    }

    public void addExtraClauses(List<MdxSelectExtraAxisClause> axes, List<MdxSelectFilterByClause> filterBys, List<MdxSelectTidyPostProcessorClause> tidyPostProcessors) {
        if (axes != null && !axes.isEmpty()) {
            if (this.extraAxisClauses == null) {
                this.extraAxisClauses = new MdxSelectExtraAxisClauses(axes);
            } else {
                this.extraAxisClauses.add(axes);
            }
        }
        if (filterBys != null && !filterBys.isEmpty()) {
            if (this.filterByClauses == null) {
                this.filterByClauses = new MdxSelectFilterByClauses(filterBys);
            } else {
                this.filterByClauses.add(filterBys);
            }
        }
        if (tidyPostProcessors != null && !tidyPostProcessors.isEmpty()) {
            if (this.tidyPostProcessorClauses == null) {
                this.tidyPostProcessorClauses = new MdxSelectTidyPostProcessorClauses(tidyPostProcessors);
            } else {
                this.tidyPostProcessorClauses.add(tidyPostProcessors);
            }
        }
    }

    @Override
    @Nullable
    public List<String> extractMeasures() {
        List<String> measures = null;
        for (MdxSelectQueryAxisClause axis : this.queryAxisClauses) {
            measures = MdxSelectStatementExpression.extractMeasuresFromAxis(measures, axis);
        }
        if (this.slicerAxisClause != null) {
            measures = MdxSelectStatementExpression.extractMeasuresFromSlicer(measures, this.slicerAxisClause);
        }
        if (this.filterByClauses != null) {
            measures = MdxSelectStatementExpression.extractMeasuresFromFilterBy(measures, this.filterByClauses);
        }
        return measures;
    }

    @Override
    @Nullable
    public String extractCube() {
        MdxIdentifierExpression id;
        MdxExpression mdxExpression = this.subSelectClause;
        if (mdxExpression instanceof MdxIdentifierExpression && (id = (MdxIdentifierExpression)mdxExpression).getPartCount() == 1) {
            return id.getLastPartAsString();
        }
        mdxExpression = this.subSelectClause;
        if (mdxExpression instanceof MdxSelectStatementExpression) {
            MdxSelectStatementExpression select = (MdxSelectStatementExpression)mdxExpression;
            return select.extractCube();
        }
        return null;
    }

    @Nullable
    private static List<String> extractMeasuresFromAxis(@Nullable List<String> measures, MdxSelectQueryAxisClause axis) {
        if (axis.isExtra()) {
            return measures;
        }
        MdxExpression expr = axis.getExpression();
        List<String> extracted = expr.extractMeasures();
        return MdxSelectStatementExpression.addToMeasures(measures, extracted);
    }

    @Nullable
    private static List<String> extractMeasuresFromSlicer(@Nullable List<String> measures, MdxSelectSlicerAxisClause slicer) {
        MdxExpression expr = slicer.getExpr();
        List<String> extracted = expr.extractMeasures();
        return MdxSelectStatementExpression.addToMeasures(measures, extracted);
    }

    @Nullable
    private static List<String> extractMeasuresFromFilterBy(@Nullable List<String> measures, MdxSelectFilterByClauses filterBy) {
        List<MdxSelectFilterByClause> filters = filterBy.getClauses();
        for (MdxSelectFilterByClause filter : filters) {
            MdxExpression expr = filter.getExpression();
            List<String> extracted = expr.extractMeasures();
            measures = MdxSelectStatementExpression.addToMeasures(measures, extracted);
        }
        return measures;
    }

    @Nullable
    private static List<String> addToMeasures(@Nullable List<String> measures, @Nullable List<String> extracted) {
        if (extracted == null || extracted.isEmpty()) {
            return measures;
        }
        if (measures == null) {
            measures = new ArrayList<String>();
        }
        measures.addAll(extracted);
        return measures;
    }

    public String toString() {
        return "SELECT ...";
    }
}

