/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.mdx.parser.ast.select;

import crazydev.common.mdx.scanner.CdMdxToken;
import crazydev.iccube.mdx.parser.ast.expression.MdxExpression;
import crazydev.iccube.mdx.parser.ast.expression.function.MdxFunctionNativeBodyExpression;
import crazydev.iccube.mdx.parser.ast.expression.function.MdxFunctionTypedArgExpression;
import crazydev.iccube.mdx.parser.ast.expression.id.MdxIdentifierExpression;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectFunctionProperties;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectWithClause;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class MdxSelectFunction
extends MdxSelectWithClause {
    private final CdMdxToken firstToken;
    private final boolean isConstant;
    private final boolean isStatic;
    private final MdxIdentifierExpression name;
    private final List<MdxFunctionTypedArgExpression> argNames;
    private final MdxExpression body;
    @Nullable
    private final MdxSelectFunctionProperties properties;

    public MdxSelectFunction(CdMdxToken firstToken, boolean isConstant, boolean isStatic, MdxIdentifierExpression name, List<MdxFunctionTypedArgExpression> argNames, MdxExpression body, @Nullable MdxSelectFunctionProperties properties) {
        this.firstToken = firstToken;
        this.isConstant = isConstant;
        this.isStatic = isStatic;
        this.name = name;
        this.argNames = argNames;
        this.body = body;
        this.properties = properties;
    }

    @Nullable
    public MdxFunctionNativeBodyExpression getNativeFunctionSourceCode() {
        return this.body.getNativeFunctionSourceCode();
    }

    @Override
    public CdMdxToken getFirstToken() {
        return this.firstToken;
    }

    @Override
    public CdMdxToken getLastToken() {
        return this.body.getLastToken();
    }

    public boolean isConstant() {
        return this.isConstant;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public MdxIdentifierExpression getName() {
        return this.name;
    }

    public List<MdxFunctionTypedArgExpression> getArgNameExpressions() {
        return this.argNames;
    }

    public List<String> getArgNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (MdxFunctionTypedArgExpression argName : this.argNames) {
            names.add(argName.getName());
        }
        return names;
    }

    public MdxExpression getBody() {
        return this.body;
    }

    @Nullable
    public String getCubeName() {
        if (this.properties != null) {
            return this.properties.getCubeName();
        }
        return null;
    }

    public boolean isCached() {
        if (this.isStatic || this.isConstant) {
            Boolean cached = null;
            if (this.properties != null) {
                cached = this.properties.getCached();
            }
            if (cached != null) {
                return cached;
            }
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return this.name.toString() + " AS ...";
    }
}

