/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.mdx.parser.ast.select;

import crazydev.common.mdx.scanner.CdMdxToken;
import crazydev.common.mdx.scanner.CdMdxTokenKind;
import crazydev.common.mdx.scanner.token.CdMdxStringToken;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MdxSelectAxisName
extends MdxSelectEntity {
    public static final String TIDY_PAGING = "#MEASURES";
    private final CdMdxToken firstToken;
    private final CdMdxToken lastToken;
    @Nullable
    private final CdMdxToken builtin;
    private final long number;
    @Nullable
    private CdMdxStringToken role;

    public MdxSelectAxisName(CdMdxToken open, CdMdxToken close, long number) {
        this.firstToken = open;
        this.lastToken = close;
        this.builtin = null;
        this.number = number;
    }

    public MdxSelectAxisName(@NotNull CdMdxToken name) {
        this.firstToken = name;
        this.lastToken = name;
        this.builtin = name;
        this.number = -1L;
    }

    public MdxSelectAxisName(@NotNull CdMdxStringToken role, long number) {
        this.role = role;
        this.firstToken = role;
        this.lastToken = role;
        this.builtin = null;
        this.number = number;
    }

    @Nullable
    public CdMdxStringToken getRoleToken() {
        return this.role;
    }

    public void setRoleToken(CdMdxStringToken role) {
        this.role = role;
    }

    @Nullable
    public String getRole() {
        if (this.role != null) {
            return this.role.getValue();
        }
        return null;
    }

    public boolean isTidyPaging() {
        return this.role != null && TIDY_PAGING.equalsIgnoreCase(this.role.getValue());
    }

    @Override
    public CdMdxToken getFirstToken() {
        return this.firstToken;
    }

    @Override
    public CdMdxToken getLastToken() {
        return this.lastToken;
    }

    @Nullable
    public CdMdxToken getBuiltin() {
        return this.builtin;
    }

    public long getNumber() {
        return this.number;
    }

    public boolean isOverriddenBy(MdxSelectAxisName other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        if (this.builtin != null && other.builtin != null) {
            CdMdxTokenKind thisKind = this.builtin.getKind();
            CdMdxTokenKind otherKind = other.builtin.getKind();
            return thisKind.equals((Object)otherKind);
        }
        if (this.number != -1L) {
            return MdxSelectAxisName.isOverriddenBy(this.number, other);
        }
        if (other.number != -1L) {
            return MdxSelectAxisName.isOverriddenBy(other.number, this);
        }
        return false;
    }

    private static boolean isOverriddenBy(long number, MdxSelectAxisName other) {
        if (other.number != -1L) {
            return number == other.number;
        }
        if (other.builtin == null) {
            return false;
        }
        CdMdxTokenKind oKind = other.builtin.getKind();
        if (oKind == CdMdxTokenKind.COLUMNS) {
            return number == 0L;
        }
        if (oKind == CdMdxTokenKind.ROWS) {
            return number == 1L;
        }
        if (oKind == CdMdxTokenKind.PAGES) {
            return number == 2L;
        }
        if (oKind == CdMdxTokenKind.SECTIONS) {
            return number == 3L;
        }
        if (oKind == CdMdxTokenKind.CHAPTERS) {
            return number == 4L;
        }
        return false;
    }

    @Override
    public String toString() {
        if (this.role != null) {
            return "Axis:" + this.number + " role:" + this.role.getValue();
        }
        return "Axis:" + String.valueOf(this.number == -1L ? this.builtin : String.valueOf(this.number));
    }
}

