/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.mdx.parser.ast.expression.script;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.mdx.scanner.CdMdxToken;
import crazydev.iccube.mdx.parser.ast.expression.MdxExpression;
import crazydev.iccube.mdx.parser.ast.statement.MdxStatementExpression;
import java.util.ArrayList;
import java.util.List;

public class MdxScriptExpression
extends MdxExpression {
    private final String name;
    private List<MdxStatementExpression> statements;

    public MdxScriptExpression(String name, List<MdxStatementExpression> statements) {
        this.name = name;
        this.statements = statements;
    }

    @Override
    public CdMdxToken getFirstToken() {
        if (!this.statements.isEmpty()) {
            return this.statements.get(0).getFirstToken();
        }
        throw new CdProgrammingException("internal error: inconsistent script first token!");
    }

    @Override
    protected CdMdxToken doGetLastToken() {
        if (!this.statements.isEmpty()) {
            return this.statements.get(this.statements.size() - 1).getLastToken();
        }
        throw new CdProgrammingException("internal error: inconsistent script last token!");
    }

    @Override
    public List<MdxExpression> getChildren() {
        ArrayList<MdxExpression> children = new ArrayList<MdxExpression>();
        for (MdxStatementExpression statement : this.statements) {
            children.addAll(statement.getChildren());
        }
        return children;
    }

    public String getName() {
        return this.name;
    }

    public List<MdxStatementExpression> getStatements() {
        return this.statements;
    }

    public boolean isEmpty() {
        return this.statements.isEmpty();
    }
}

