/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.mdx.parser.ast.expression.id;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.mdx.scanner.token.CdMdxIdentifierToken;
import crazydev.iccube.mdx.parser.ast.expression.MdxExpression;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class MdxIdentifierExpression
extends MdxExpression {
    private final List<CdMdxIdentifierToken> parts;

    public MdxIdentifierExpression(CdMdxIdentifierToken part) {
        this(Arrays.asList(part));
    }

    public MdxIdentifierExpression(List<CdMdxIdentifierToken> parts) {
        this.parts = parts;
    }

    @Override
    public List<MdxExpression> getChildren() {
        return Collections.emptyList();
    }

    public CdMdxIdentifierToken getFirstToken() {
        return this.parts.get(0);
    }

    protected CdMdxIdentifierToken doGetLastToken() {
        return this.parts.get(this.parts.size() - 1);
    }

    public boolean isSimple() {
        return this.getPartCount() == 1 && !this.isDelimited() && !this.isLastPartDefinedAsKey();
    }

    public boolean isLastPartDefinedAsKey() {
        if (this.parts.isEmpty()) {
            return false;
        }
        CdMdxIdentifierToken token = this.parts.get(this.parts.size() - 1);
        return token.isKey();
    }

    public boolean isDelimited() {
        for (CdMdxIdentifierToken part : this.parts) {
            if (!part.isDelimited()) continue;
            return true;
        }
        return false;
    }

    public int getPartCount() {
        return this.parts.size();
    }

    public CdMdxIdentifierToken getPart(int pos) {
        return this.parts.get(pos);
    }

    public List<CdMdxIdentifierToken> getParts() {
        return Collections.unmodifiableList(this.parts);
    }

    public String getLastPartAsString() {
        if (this.parts.isEmpty()) {
            throw new CdProgrammingException("MDX identifier expression inconsistency.");
        }
        CdMdxIdentifierToken token = this.parts.get(this.parts.size() - 1);
        return token.getIdentifier();
    }

    public MdxIdentifierExpression subIdentifier(int from, int to) {
        if (from < 0) {
            throw new CdProgrammingException("MDX identifier expression inconsistency [from:" + from + "]");
        }
        if (to > this.parts.size()) {
            throw new CdProgrammingException("MDX identifier expression inconsistency [to:" + to + "]");
        }
        if (from > to) {
            throw new CdProgrammingException("MDX identifier expression inconsistency [from:" + from + "][to:" + to + "]");
        }
        return new MdxIdentifierExpression(this.parts.subList(from, to));
    }

    public String asParsedString() {
        return this.asParsedString(0);
    }

    public String asParsedString(int from) {
        StringBuilder sb = new StringBuilder();
        for (int idx = from; idx < this.parts.size(); ++idx) {
            CdMdxIdentifierToken token = this.parts.get(idx);
            if (idx > from) {
                sb.append(".");
            }
            sb.append(token.getLexeme());
        }
        return sb.toString();
    }

    @Override
    @Nullable
    public List<String> extractMeasures() {
        if (this.isLastPartDefinedAsKey() || this.getPartCount() != 2) {
            return null;
        }
        CdMdxIdentifierToken tk = this.getFirstToken();
        String lexeme = tk.getIdentifier();
        if ("Measures".equalsIgnoreCase(lexeme)) {
            return List.of(this.asMdx());
        }
        return null;
    }

    public String toString() {
        return this.asParsedString();
    }
}

