/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.mdx.parser.ast.expression.function;

import crazydev.common.mdx.scanner.CdMdxToken;
import crazydev.iccube.mdx.parser.ast.expression.MdxExpression;
import crazydev.iccube.mdx.parser.ast.expression.function.MdxFunctionTypedArgExpression;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class MdxFunctionNativeBodyExpression
extends MdxExpression {
    private final boolean withFunction;
    private final String functionName;
    private final List<MdxFunctionTypedArgExpression> functionArgs;
    private final CdMdxToken token;
    private final String body;

    public MdxFunctionNativeBodyExpression(boolean withFunction, String functionName, List<MdxFunctionTypedArgExpression> functionArgs, CdMdxToken token) {
        this.withFunction = withFunction;
        this.functionName = functionName;
        this.functionArgs = functionArgs;
        this.token = token;
        this.body = token.getLexeme();
    }

    public boolean isWithFunction() {
        return this.withFunction;
    }

    @Override
    @Nullable
    public MdxFunctionNativeBodyExpression getNativeFunctionSourceCode() {
        return this;
    }

    @Override
    public List<MdxExpression> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public CdMdxToken getFirstToken() {
        return this.token;
    }

    @Override
    protected CdMdxToken doGetLastToken() {
        return this.token;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public int getFunctionArgCount() {
        return this.functionArgs != null ? this.functionArgs.size() : 0;
    }

    public String getFunctionArgName(int index) {
        return this.functionArgs.get(index).getName();
    }

    @Nullable
    public String getFunctionArgType(int index) {
        return this.functionArgs.get(index).getType();
    }

    public String getBody() {
        return this.body;
    }

    public String toString() {
        return this.token.getLexeme();
    }
}

