/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.mdx.parser.ast.expression.function;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.mdx.scanner.CdMdxToken;
import crazydev.common.mdx.scanner.token.CdMdxIdentifierToken;
import crazydev.iccube.mdx.parser.ast.expression.MdxExpression;
import crazydev.iccube.mdx.parser.ast.expression.function.MdxFunctionArgExpression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class MdxFunctionCallExpression
extends MdxExpression {
    private final CdMdxIdentifierToken tkName;
    @Nullable
    private final CdMdxToken tkOpenParen;
    @Nullable
    private final CdMdxToken tkCloseParen;
    private final Notation notation;
    private final String name;
    private final List<MdxFunctionArgExpression> args;

    public MdxFunctionCallExpression(CdMdxIdentifierToken tkName, Notation notation, String name, @Nullable MdxExpression arg0) {
        this(tkName, null, null, notation, name, arg0, null);
    }

    public MdxFunctionCallExpression(CdMdxIdentifierToken tkName, @Nullable CdMdxToken tkOpenParen, @Nullable CdMdxToken tkCloseParen, Notation notation, String name, @Nullable MdxExpression arg0, @Nullable List<MdxFunctionArgExpression> args) {
        this.tkName = tkName;
        this.tkOpenParen = tkOpenParen;
        this.tkCloseParen = tkCloseParen;
        this.notation = notation;
        this.name = name;
        this.args = arg0 != null || args != null && !args.isEmpty() ? new ArrayList<MdxFunctionArgExpression>() : Collections.emptyList();
        if (arg0 != null) {
            this.args.add(new MdxFunctionArgExpression(0, arg0));
        }
        if (args != null) {
            this.args.addAll(args);
        }
        this.ensureConsistency();
    }

    @Override
    public List<MdxExpression> getChildren() {
        ArrayList<MdxExpression> children = new ArrayList<MdxExpression>();
        for (MdxFunctionArgExpression arg : this.args) {
            children.add(arg);
        }
        return children;
    }

    @Override
    public CdMdxToken getFirstToken() {
        if (this.notation == Notation.FUNCTION_POSTFIXED) {
            return this.args.get(0).getFirstToken();
        }
        return this.tkName;
    }

    @Override
    protected CdMdxToken doGetLastToken() {
        if (this.tkCloseParen != null) {
            return this.tkCloseParen;
        }
        return this.tkName;
    }

    public Notation getNotation() {
        return this.notation;
    }

    public String getName() {
        return this.name;
    }

    public List<MdxFunctionArgExpression> getArgs() {
        return this.args;
    }

    private void ensureConsistency() {
        switch (this.notation.ordinal()) {
            case 1: {
                if (!this.args.isEmpty()) break;
                throw new CdProgrammingException("Missing [this] argument in function call [" + this.name + "]");
            }
            case 0: {
                break;
            }
            case 2: {
                if (this.args.isEmpty()) {
                    throw new CdProgrammingException("Missing [this] argument in property call [" + this.name + "]");
                }
                if (this.args.size() <= 1) break;
                throw new CdProgrammingException("Multiple arguments in property call [" + this.name + "]");
            }
            default: {
                throw new CdProgrammingException("Unknown [" + String.valueOf((Object)this.notation) + "]");
            }
        }
    }

    @Override
    @Nullable
    public List<String> extractMeasures() {
        ArrayList<String> measures = null;
        if ("Crossjoin".equalsIgnoreCase(this.name)) {
            for (MdxFunctionArgExpression arg : this.args) {
                List<String> extracted = arg.extractMeasures();
                if (extracted == null || extracted.isEmpty()) continue;
                if (measures == null) {
                    measures = new ArrayList<String>();
                }
                measures.addAll(extracted);
            }
        }
        return measures;
    }

    public String toString() {
        return this.name + "( ... )";
    }

    public static enum Notation {
        FUNCTION_REGULAR,
        FUNCTION_POSTFIXED,
        PROPERTY;

    }
}

