/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.mdx.parser.ast.expression.authorization;

import crazydev.common.mdx.scanner.CdMdxToken;
import crazydev.common.mdx.scanner.CdMdxTokenKind;
import crazydev.iccube.mdx.parser.ast.expression.MdxExpression;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationCurrent;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class MdxAuthorizationStatement {
    protected final CdMdxToken plusMinusToken;
    @Nullable
    private final MdxAuthorizationCurrent current;

    protected MdxAuthorizationStatement(CdMdxToken plusMinusToken) {
        this.plusMinusToken = plusMinusToken;
        this.current = null;
    }

    protected MdxAuthorizationStatement(CdMdxToken plusMinusToken, @Nullable MdxAuthorizationCurrent current) {
        this.plusMinusToken = plusMinusToken;
        this.current = current;
    }

    public CdMdxToken getFirstToken() {
        return this.plusMinusToken;
    }

    public abstract CdMdxToken getLastToken();

    public abstract void getMdxExpressionChildren(List<MdxExpression> var1);

    public boolean isPP() {
        return false;
    }

    public boolean isPlus() {
        return CdMdxTokenKind.PLUS == this.plusMinusToken.getKind();
    }

    public boolean isMinus() {
        return CdMdxTokenKind.MINUS == this.plusMinusToken.getKind();
    }

    public abstract MdxExpression getMdxExpression();

    public String asMdx() {
        try {
            CdMdxToken ftoken = this.getFirstToken();
            int begin = ftoken.getLocation().offset();
            CdMdxToken ltoken = this.getLastToken();
            int end = ltoken.getLocation().offset() + ltoken.getLexeme().length();
            String fullMdx = ftoken.getMdx();
            String mdx = fullMdx.substring(begin, end);
            return mdx;
        }
        catch (RuntimeException ex) {
            OlapLoggers.AUTHORIZATION.warn((Object)("could not retrieve the MDX expression for : " + this.getClass().getName()), (Throwable)ex);
            return "n/a";
        }
    }

    @Nullable
    public MdxAuthorizationCurrent getCurrent() {
        return this.current;
    }

    public MdxAuthorizationStatement attachCurrent(@Nullable MdxAuthorizationCurrent current) {
        return this.copyForCurrent(current);
    }

    protected abstract MdxAuthorizationStatement copyForCurrent(MdxAuthorizationCurrent var1);
}

