/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.mdx.parser;

import crazydev.common.mdx.error.CdMdxErrorCode;
import crazydev.common.mdx.scanner.exception.CdMdxScannerException;
import crazydev.iccube.mdx.parser.MdxParser;
import crazydev.iccube.mdx.parser.MdxParsingContext;
import crazydev.iccube.mdx.parser.ast.expression.script.MdxScriptExpression;
import crazydev.iccube.mdx.parser.exception.MdxParserException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import org.apache.commons.io.IOUtils;

public abstract class MdxScriptParserHelper {
    public static final String FILE_ENCODING = "UTF-8";

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MdxScriptExpression parse(MdxParsingContext context, File script, String scriptHash) throws CdMdxScannerException, MdxParserException {
        MdxScriptExpression mdxScriptExpression;
        String cs = FILE_ENCODING;
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader((InputStream)new FileInputStream(script), FILE_ENCODING);
            mdxScriptExpression = MdxScriptParserHelper.parse(context, script.getName(), reader, scriptHash);
        }
        catch (FileNotFoundException ex) {
            try {
                throw new MdxParserException(null, CdMdxErrorCode.PARSE_SCRIPT_FILE_NOT_FOUND, new Serializable[]{script.getAbsolutePath()});
                catch (UnsupportedEncodingException ex2) {
                    throw new MdxParserException(null, CdMdxErrorCode.PARSE_SCRIPT_FILE_ENCODING_ERROR, new Serializable[]{FILE_ENCODING});
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        return mdxScriptExpression;
    }

    public static MdxScriptExpression parse(MdxParsingContext context, String filename, Reader script, String scriptHash) throws CdMdxScannerException, MdxParserException {
        try {
            String mdx = IOUtils.toString((Reader)script);
            String mdxHash = scriptHash;
            return MdxParser.parseMdxScript(context, filename, mdx, mdxHash);
        }
        catch (IOException ex) {
            throw new MdxParserException(null, CdMdxErrorCode.PARSE_SCRIPT_FILE_IO_ERROR, new Serializable[]{filename, ex.getMessage()});
        }
    }
}

