/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.mdx.parser;

import crazydev.common.mdx.scanner.exception.CdMdxScannerException;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.configuration.component.properties.OlapPropertyDescriptions;
import crazydev.iccube.mdx.parser.MdxParser;
import crazydev.iccube.mdx.parser.MdxParsingContext;
import crazydev.iccube.mdx.parser.ast.expression.id.MdxIdentifierExpression;
import crazydev.iccube.mdx.parser.exception.MdxParserException;
import crazydev.iccube.olap.compiler.ast.MdxEntityCompiler;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.properties.member.OlapIntrinsicMemberPropertyManager;
import crazydev.iccube.olap.eval.function.OlapFunctionRepository;
import crazydev.iccube.olap.schema.OlapSchemaFunctionRepository;
import java.util.Arrays;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

public abstract class MdxParserIdentifierHelper {
    @Nullable(value="cannot be parsed into an identifier for whatever reason")
    public static @Nullable(value="cannot be parsed into an identifier for whatever reason") OlapEntityIdentifier parseIdentifier(boolean acceptSCAN_EMPTY_DELIMITED_ID, String mdx, String identifierKind) {
        if (CdStringUtils.isNullOrBlank((String)mdx)) {
            return null;
        }
        try {
            return MdxParserIdentifierHelper.parseIdentifierX(acceptSCAN_EMPTY_DELIMITED_ID, mdx, identifierKind);
        }
        catch (CdMdxScannerException | MdxParserException ignored) {
            return null;
        }
    }

    public static OlapEntityIdentifier parseIdentifierX(boolean acceptSCAN_EMPTY_DELIMITED_ID, String mdx, String identifierKind) throws MdxParserException, CdMdxScannerException {
        String mdxHash = UUID.randomUUID().toString();
        String token = !mdx.contains(" ") || mdx.startsWith("[") ? mdx : "[" + mdx + "]";
        MdxIdentifierExpression expression = MdxParserIdentifierHelper.parseIdentifierExpression(acceptSCAN_EMPTY_DELIMITED_ID, token, mdxHash, identifierKind);
        return MdxEntityCompiler.createOlapIdentifier(expression);
    }

    @Nullable(value="cannot be parsed into an identifier for whatever reason")
    public static @Nullable(value="cannot be parsed into an identifier for whatever reason") OlapEntityIdentifier parseIdentifier(String mdx, String identifierKind) {
        if (CdStringUtils.isNullOrBlank((String)mdx)) {
            return null;
        }
        try {
            return MdxParserIdentifierHelper.parseIdentifierX(mdx, identifierKind);
        }
        catch (CdMdxScannerException | MdxParserException ignored) {
            return null;
        }
    }

    public static OlapEntityIdentifier parseIdentifierX(String mdx, String identifierKind) throws MdxParserException, CdMdxScannerException {
        String mdxHash = UUID.randomUUID().toString();
        String token = !mdx.contains(" ") || mdx.startsWith("[") ? mdx : "[" + mdx + "]";
        MdxIdentifierExpression expression = MdxParserIdentifierHelper.parseIdentifierExpression(false, token, mdxHash, identifierKind);
        return MdxEntityCompiler.createOlapIdentifier(expression);
    }

    private static MdxIdentifierExpression parseIdentifierExpression(boolean acceptSCAN_EMPTY_DELIMITED_ID, String mdx, String mdxHash, String identifierKind) throws MdxParserException, CdMdxScannerException {
        OlapProperties properties = new OlapProperties(Arrays.asList(OlapPropertyDescriptions.excelFixDotMembers.asProperty(true)));
        OlapFunctionRepository functionRepository = new OlapFunctionRepository(true);
        OlapSchemaFunctionRepository schemaFunctionRepository = new OlapSchemaFunctionRepository(functionRepository);
        OlapIntrinsicMemberPropertyManager memberPropertyManager = new OlapIntrinsicMemberPropertyManager(true);
        MdxParsingContext context = new MdxParsingContext(properties, functionRepository, schemaFunctionRepository.createSnapshot(), memberPropertyManager, true, acceptSCAN_EMPTY_DELIMITED_ID);
        return MdxParser.parseIdentifierExpression(context, mdx, mdxHash, identifierKind);
    }
}

