/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.gvi.table;

import crazydev.iccube.gvi.table.GviColumnDescription;
import crazydev.iccube.gvi.table.GviTableCell;
import crazydev.iccube.gvi.table.GviTableRow;
import crazydev.iccube.gvi.table.GviValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GviTable {
    private List<GviColumnDescription> columns = new ArrayList<GviColumnDescription>();
    private Map<String, Integer> columnIndexById = new HashMap<String, Integer>();
    private List<GviTableRow> rows = new ArrayList<GviTableRow>();
    private Map<String, Object> customProperties = null;

    public List<GviColumnDescription> getColumnDescriptions() {
        return this.columns;
    }

    public List<GviTableRow> getRows() {
        return this.rows;
    }

    public void addColumn(GviColumnDescription columnDescription) {
        String columnId = columnDescription.getId();
        if (this.columnIndexById.containsKey(columnId)) {
            throw new RuntimeException("Column Id [" + columnId + "] already in table description");
        }
        this.columnIndexById.put(columnId, this.columns.size());
        this.columns.add(columnDescription);
        for (GviTableRow row : this.rows) {
            row.addCell(new GviTableCell(GviValue.getNullValueFromValueType(columnDescription.getType())));
        }
    }

    public void addRow(GviTableRow row) {
        int cc;
        List<GviTableCell> cells = row.getCells();
        if (cells.size() > this.columns.size()) {
            throw new RuntimeException("Row has too many cells: %d. Should be at most of size : %d".formatted(cells.size(), this.columns.size()));
        }
        for (cc = 0; cc < cells.size(); ++cc) {
            String columnType;
            String cellType = cells.get(cc).getType();
            if (cellType.equals(columnType = this.columns.get(cc).getType())) continue;
            throw new RuntimeException("Cell type [%s] does not match column type [%s] at index : %d".formatted(cellType, columnType, cc));
        }
        for (cc = cells.size(); cc < this.columns.size(); ++cc) {
            row.addCell(new GviTableCell(GviValue.getNullValueFromValueType(this.columns.get(cc).getType())));
        }
        this.rows.add(row);
    }

    public void setCustomProperty(String propertyKey, Object propertyValue) {
        if (this.customProperties == null) {
            this.customProperties = new HashMap<String, Object>();
        }
        if (propertyKey == null || propertyValue == null) {
            throw new RuntimeException("Null keys/values are not allowed.");
        }
        this.customProperties.put(propertyKey, propertyValue);
    }
}

