/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.fs;

import crazydev.common.utils.CdPathEscapeUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.fs.OlapPathEntry;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.Nullable;

public class OlapPath {
    public static final OlapPath ROOT = OlapPath.create(new OlapPathEntry[0]);
    private final List<OlapPathEntry> entries;

    private OlapPath(List<OlapPathEntry> entries) {
        this.entries = entries;
    }

    public static OlapPath create(List<OlapPathEntry> entries) {
        ArrayList<OlapPathEntry> path = new ArrayList<OlapPathEntry>();
        if (entries != null) {
            for (OlapPathEntry entry : entries) {
                String name = entry.getName().trim();
                if (CdStringUtils.isNullOrBlank((String)name) || name.equals("/")) continue;
                path.add(entry);
            }
        }
        return new OlapPath(path);
    }

    public static OlapPath create(OlapPathEntry ... entries) {
        ArrayList<OlapPathEntry> path = new ArrayList<OlapPathEntry>();
        if (entries != null) {
            for (OlapPathEntry entry : entries) {
                path.add(entry);
            }
        }
        return OlapPath.create(path);
    }

    public static OlapPath createFromUrl(String url) {
        try {
            String[] parts = url.split("/");
            ArrayList<OlapPathEntry> entries = new ArrayList<OlapPathEntry>();
            for (int ii = 0; ii < parts.length; ++ii) {
                String part = parts[ii];
                if (CdStringUtils.isNullOrBlank((String)part)) continue;
                String entry = URLDecoder.decode(part, "UTF-8");
                entries.add(OlapPathEntry.create(entry));
            }
            return OlapPath.create(entries);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("unexpected missing UTF-8 encoding", ex);
        }
    }

    public String toURL() {
        if (this.entries.isEmpty()) {
            return "";
        }
        try {
            StringBuilder sb = new StringBuilder();
            for (OlapPathEntry entry : this.entries) {
                String name = entry.getName();
                String name_ = URLEncoder.encode(name, "UTF-8");
                sb.append("/").append(name_);
            }
            String url = sb.toString();
            return url;
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("UTF-8 not supported", ex);
        }
    }

    @Nullable
    public static OlapPath createFromUUID(@Nullable String uuid) {
        if (CdStringUtils.isNullOrBlank((String)uuid)) {
            return null;
        }
        String[] parts = uuid.split("/");
        ArrayList<OlapPathEntry> entries = new ArrayList<OlapPathEntry>();
        for (int ii = 0; ii < parts.length; ++ii) {
            String part = parts[ii];
            if (CdStringUtils.isNullOrBlank((String)part)) continue;
            String name = CdPathEscapeUtils.unescapeUuidName((String)part);
            entries.add(OlapPathEntry.create(name));
        }
        return OlapPath.create(entries);
    }

    public String toUUID() {
        if (this.entries.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (OlapPathEntry entry : this.entries) {
            String name = entry.getName();
            String name_ = CdPathEscapeUtils.escapeUuidName((String)name);
            sb.append("/").append(name_);
        }
        return sb.toString();
    }

    public String toUUID(int pos) {
        if (this.entries.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int ii = 0; ii <= pos; ++ii) {
            OlapPathEntry entry = this.entries.get(ii);
            String name = entry.getName();
            String name_ = CdPathEscapeUtils.escapeUuidName((String)name);
            sb.append("/").append(name_);
        }
        return sb.toString();
    }

    public static OlapPath createFromRawPath(String[] path) {
        if (path.length == 0) {
            return ROOT;
        }
        ArrayList<OlapPathEntry> entries = new ArrayList<OlapPathEntry>();
        for (String name : path) {
            if (CdStringUtils.isNullOrBlank((String)name)) continue;
            entries.add(OlapPathEntry.create(name));
        }
        return OlapPath.create(entries);
    }

    public String[] toRawPath() {
        if (this.entries.isEmpty()) {
            return new String[0];
        }
        String[] raw = new String[this.entries.size()];
        for (int ii = 0; ii < this.entries.size(); ++ii) {
            String name;
            OlapPathEntry entry = this.entries.get(ii);
            raw[ii] = name = entry.getName();
        }
        return raw;
    }

    @Nullable
    public static OlapPath createFromSimplePath(@Nullable String path) {
        if (path == null) {
            return null;
        }
        if (CdStringUtils.isNullOrBlank((String)path)) {
            return ROOT;
        }
        String[] parts = path.split("/");
        ArrayList<OlapPathEntry> entries = new ArrayList<OlapPathEntry>();
        for (int ii = 0; ii < parts.length; ++ii) {
            String part = parts[ii];
            if (CdStringUtils.isNullOrBlank((String)part)) continue;
            String name = CdPathEscapeUtils.unescapeSimplePathName((String)part);
            entries.add(OlapPathEntry.create(name));
        }
        return OlapPath.create(entries);
    }

    public String toSimplePath() {
        if (this.entries.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (OlapPathEntry entry : this.entries) {
            String name = entry.getName();
            String name_ = CdPathEscapeUtils.escapeSimplePathName((String)name);
            sb.append("/").append(name_);
        }
        return sb.toString();
    }

    public static OlapPath createFromZipPath(ZipFile zip, ZipEntry entry) {
        String path_ = entry.getName();
        String pathN = FilenameUtils.normalize((String)path_, (boolean)true);
        if (pathN.startsWith("/")) {
            pathN = pathN.substring(1);
        }
        return OlapPath.createFromZipPath(pathN);
    }

    public static OlapPath createFromZipPath(String path) {
        if (CdStringUtils.isNullOrBlank((String)path)) {
            return ROOT;
        }
        String[] parts = path.split("/");
        ArrayList<OlapPathEntry> entries = new ArrayList<OlapPathEntry>();
        for (int ii = 0; ii < parts.length; ++ii) {
            String part = parts[ii];
            if (CdStringUtils.isNullOrBlank((String)part)) continue;
            String name = CdPathEscapeUtils.unescapeFileName((String)part);
            entries.add(OlapPathEntry.create(name));
        }
        return OlapPath.create(entries);
    }

    public String toZipPath(boolean isDirectory) {
        StringBuilder sb = new StringBuilder();
        for (OlapPathEntry entry : this.entries) {
            String name = entry.getName();
            String name_ = CdPathEscapeUtils.escapeFileName((String)name);
            sb.append("/").append(name_);
        }
        Object path = sb.toString();
        if (((String)path).startsWith("/")) {
            path = ((String)path).substring(1);
        }
        if (isDirectory && !((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        return path;
    }

    public String toFileName(@Nullable String slash) {
        String path = this.toSimplePath();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (slash != null) {
            path = path.replace("/", slash);
        }
        path = CdPathEscapeUtils.escapeFileName((String)path);
        return path;
    }

    public OlapPath prepend(OlapPathEntry entry) {
        ArrayList<OlapPathEntry> path = new ArrayList<OlapPathEntry>();
        path.add(entry);
        path.addAll(this.entries);
        return OlapPath.create(path);
    }

    public OlapPath append(OlapPathEntry ... entries) {
        ArrayList<OlapPathEntry> path = new ArrayList<OlapPathEntry>();
        path.addAll(this.entries);
        if (entries != null) {
            for (OlapPathEntry entry : entries) {
                if (CdStringUtils.isNullOrBlank((String)entry.getName())) continue;
                path.add(entry);
            }
        }
        return OlapPath.create(path);
    }

    public OlapPath append(OlapPath other) {
        ArrayList<OlapPathEntry> path = new ArrayList<OlapPathEntry>();
        path.addAll(this.entries);
        for (OlapPathEntry entry : other.entries) {
            if (CdStringUtils.isNullOrBlank((String)entry.getName())) continue;
            path.add(entry);
        }
        return OlapPath.create(path);
    }

    public OlapPath addToLast(String value) {
        ArrayList<OlapPathEntry> path = new ArrayList<OlapPathEntry>();
        for (int ii = 0; ii < this.entries.size(); ++ii) {
            OlapPathEntry entry = this.entries.get(ii);
            if (ii == this.entries.size() - 1) {
                path.add(OlapPathEntry.create(entry.getName() + value));
                continue;
            }
            path.add(entry);
        }
        return OlapPath.create(path);
    }

    public OlapPath removeLast() {
        ArrayList<OlapPathEntry> entries_ = new ArrayList<OlapPathEntry>();
        for (int ii = 0; ii < this.entries.size() - 1; ++ii) {
            entries_.add(this.entries.get(ii));
        }
        return new OlapPath(entries_);
    }

    public OlapPath replace(String from, String to) {
        for (int ii = 0; ii < this.entries.size(); ++ii) {
            OlapPathEntry entry = this.entries.get(ii);
            if (!entry.getName().equals(from)) continue;
            this.entries.set(ii, OlapPathEntry.create(to));
        }
        return this;
    }

    public boolean hasParent() {
        if (this.entries.size() <= 1) {
            return false;
        }
        for (int ii = 0; ii < this.entries.size(); ++ii) {
            OlapPathEntry entry = this.entries.get(ii);
            String name = entry.getName();
            if (!CdStringUtils.isNotNullAndNotBlank((String)name) || name.equals("/")) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public OlapPathEntry getName() {
        if (this.entries.size() > 0) {
            return this.entries.get(this.entries.size() - 1);
        }
        return OlapPathEntry.create("");
    }

    public OlapPathEntry getName(int pos) {
        return this.entries.get(pos);
    }

    @Nullable
    public OlapPath getParent() {
        if (this.entries.size() > 1) {
            return OlapPath.create(this.entries.subList(0, this.entries.size() - 1));
        }
        return null;
    }

    public OlapPath getParentOrRoot() {
        if (this.entries.size() > 1) {
            return OlapPath.create(this.entries.subList(0, this.entries.size() - 1));
        }
        return ROOT;
    }

    public OlapPath subPath(int pos) {
        return OlapPath.create(this.entries.subList(pos, this.entries.size()));
    }

    public OlapPath subPath(int from, int to) {
        return OlapPath.create(this.entries.subList(from, to));
    }

    public List<OlapPathEntry> getEntries() {
        return this.entries;
    }

    public int size() {
        return this.entries.size();
    }

    public boolean endsWith(OlapPath other) {
        int offset = this.entries.size() - other.entries.size();
        if (offset >= 0) {
            for (int ii = 0; ii < other.entries.size(); ++ii) {
                OlapPathEntry thisEntry;
                OlapPathEntry otherEntry = other.entries.get(ii);
                if (otherEntry.equals(thisEntry = this.entries.get(offset + ii))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean startsWith(OlapPath other) {
        if (this.entries.size() >= other.entries.size()) {
            for (int ii = 0; ii < other.entries.size(); ++ii) {
                OlapPathEntry thisEntry;
                OlapPathEntry otherEntry = other.entries.get(ii);
                if (otherEntry.equals(thisEntry = this.entries.get(ii))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public OlapPath relativeTo(OlapPath other) {
        if (this.startsWith(other)) {
            ArrayList<OlapPathEntry> entries = new ArrayList<OlapPathEntry>();
            for (int ii = other.entries.size(); ii < this.entries.size(); ++ii) {
                entries.add(this.entries.get(ii));
            }
            return OlapPath.create(entries);
        }
        return this;
    }

    public String toErrorPath() {
        if (this.entries.isEmpty()) {
            return "/";
        }
        StringBuilder sb = new StringBuilder();
        for (OlapPathEntry entry : this.entries) {
            sb.append("/").append(entry.toErrorPath());
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OlapPath olapPath = (OlapPath)o;
        return this.entries.equals(olapPath.entries);
    }

    public int hashCode() {
        return this.entries.hashCode();
    }

    public String toString() {
        return this.toErrorPath();
    }
}

