/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.fs;

import crazydev.common.fs.CdVFilePath;
import crazydev.common.utils.CdIoUtils;
import crazydev.iccube.fs.OlapFileException;
import crazydev.iccube.fs.OlapFileNameFilter;
import crazydev.iccube.fs.OlapFileSystem;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class OlapFile {
    private final OlapFileSystem fileSystem;
    private final String path;
    private final File underlying;

    OlapFile(OlapFileSystem fileSystem, String path, File underlying) {
        this.fileSystem = fileSystem;
        this.path = path = path.replace("\\", "/");
        this.underlying = underlying;
        OlapFile.checkPath(fileSystem, path);
    }

    public static void checkPath(OlapFileSystem fileSystem, String path) {
        if (fileSystem.isConstraint() && OlapFileSystem.containsDotDot(path)) {
            throw new OlapFileException("Directory/file path with '..' is not allowed in constraint file system [" + path + "]");
        }
    }

    public OlapFileSystem getFileSystem() {
        return this.fileSystem;
    }

    public File __getUnderlying() {
        return this.underlying;
    }

    public String __getUnderlyingAbsolutePath() {
        return this.underlying.getAbsolutePath();
    }

    public OlapFile createChild(String path, File underlying) {
        return new OlapFile(this.fileSystem, path, underlying);
    }

    public String getName() {
        File xpath = new File(this.path);
        String name = xpath.getName();
        return name.isEmpty() ? xpath.getPath() : name;
    }

    public String getPath() {
        return this.path;
    }

    public String getUnderlyingAbsolutePathForUserError() {
        if (this.fileSystem.isConstraint()) {
            return "${fileSystemRoot}/" + this.path;
        }
        return this.underlying.getAbsolutePath();
    }

    @Nullable
    public OlapFile getParentFile() {
        return this.fileSystem.getParentFile(this);
    }

    public PrintStream createPrintStream() throws IOException {
        FileOutputStream fos = new FileOutputStream(this.underlying);
        PrintStream pos = new PrintStream((OutputStream)new BufferedOutputStream(fos), false, "UTF-8");
        return pos;
    }

    public InputStream createInputStream() throws IOException {
        return this.fileSystem.createInputStream(this);
    }

    public InputStream createInputStreamX(String encoding) throws IOException {
        return CdIoUtils.getInputStream((File)this.underlying, (String)encoding);
    }

    public List<String> readAllLines() throws IOException {
        return this.fileSystem.readAllLines(this);
    }

    public boolean mkdir() {
        return this.fileSystem.mkdir(this);
    }

    public boolean exists() {
        return this.fileSystem.exists(this);
    }

    public boolean delete() {
        return this.fileSystem.delete(this);
    }

    public long length() {
        return this.underlying.length();
    }

    public long lastModified() {
        return this.underlying.lastModified();
    }

    public boolean isDirectory() {
        return this.underlying.isDirectory();
    }

    public boolean isFile() {
        return this.underlying.isFile();
    }

    public DirectoryStream<Path> createDirectoryStream(DirectoryStream.Filter<? super Path> filter) throws IOException {
        return this.fileSystem.createDirectoryStream(this, filter);
    }

    public List<String> listLocalFileNames(OlapFileNameFilter filter) {
        return this.fileSystem.listLocalFileNames(this, filter);
    }

    public void processAllFiles(DirectoryStream.Filter<? super Path> filter, Consumer<CdVFilePath> action) throws IOException {
        this.fileSystem.processAllFiles(this, filter, action);
    }

    public void move(OlapFile target) throws IOException {
        this.fileSystem.move(this, target);
    }

    public void saveFile(InputStream fileContent) throws IOException {
        this.fileSystem.saveFile(this, fileContent);
    }

    public boolean equals(Object o) {
        throw new RuntimeException("wait and see if required");
    }

    public int hashCode() {
        throw new RuntimeException("wait and see");
    }

    public String toString() {
        return "[path: " + this.path + "][underlying: " + this.underlying.getAbsolutePath() + "]";
    }
}

