/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.enums;

import crazydev.common.exception.programming.CdUnsupportedSwitchTypeException;
import crazydev.iccube.olap.entity.member.OlapMemberKey;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.operator.scalar.OlapScalarOperators;
import jakarta.xml.bind.annotation.XmlEnum;
import java.util.Comparator;

@XmlEnum
public enum OlapMemberOrderKind {
    ASC,
    DESC,
    ASC_UPPER,
    DESC_UPPER;


    public MemberComparator getComparator(Comparator<String> comparator) {
        if (comparator == null) {
            return this._get(String::compareTo);
        }
        return this._get(comparator);
    }

    private MemberComparator _get(Comparator<String> comparator) {
        switch (this.ordinal()) {
            case 0: {
                return new UsingExternalComparator(comparator, true);
            }
            case 1: {
                return new UsingExternalComparator(comparator, false);
            }
            case 2: {
                return new UsingExternalComparator((o1, o2) -> comparator.compare(o1.toUpperCase(), o2.toUpperCase()), true);
            }
            case 3: {
                return new UsingExternalComparator((o1, o2) -> comparator.compare(o1.toUpperCase(), o2.toUpperCase()), false);
            }
        }
        throw new CdUnsupportedSwitchTypeException((Enum)this);
    }

    public boolean isDec() {
        return this == DESC || this == DESC_UPPER;
    }

    public boolean isAsc() {
        return this == ASC || this == ASC_UPPER;
    }

    public static interface MemberComparator {
        public int compare(String var1, String var2);

        public int compare(OlapMemberKey var1, OlapMemberKey var2);

        public int compare(OlapScalarEntity var1, OlapScalarEntity var2);
    }

    private static class UsingExternalComparator
    implements MemberComparator {
        private final Comparator<String> collator;
        private final boolean asc;

        private UsingExternalComparator(Comparator<String> collator, boolean asc) {
            this.collator = collator;
            this.asc = asc;
        }

        @Override
        public int compare(String name, String name2) {
            return this.asc ? this.collator.compare(name, name2) : -this.collator.compare(name, name2);
        }

        @Override
        public int compare(OlapMemberKey key, OlapMemberKey key1) {
            if (key.isSingleValue() && key1.isSingleValue()) {
                Comparable value = key.getValue();
                Comparable value1 = key1.getValue();
                if (value instanceof String && value1 instanceof String) {
                    return this.compare((String)((Object)value), (String)((Object)value1));
                }
            }
            return this.asc ? key.compareTo(key1) : -key.compareTo(key1);
        }

        @Override
        public int compare(OlapScalarEntity prop1, OlapScalarEntity prop2) {
            return this.asc ? OlapScalarOperators.compare(this.collator, prop1, prop2) : -OlapScalarOperators.compare(this.collator, prop1, prop2);
        }
    }
}

