/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.enums;

import crazydev.common.utils.CdStringUtils;
import jakarta.xml.bind.annotation.XmlEnum;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.TemporalField;
import java.time.temporal.WeekFields;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@XmlEnum
public enum OlapLevelType {
    YEAR("Y", "Year", "yyyy", "yyyy"){

        @Override
        public LocalDateTime getNextDate(LocalDateTime begin) {
            return begin.plusYears(1);
        }

        @Override
        public LocalDateTime transformToValidDate(LocalDateTime begin, @Nullable Locale locale) {
            return new LocalDateTime(begin.getYear(), 1, 1, 0, 0);
        }

        @Override
        public LocalDateTime toNextDate(LocalDateTime end) {
            return end.plusYears(1);
        }

        @Override
        public int getRelativeId(LocalDateTime date, Locale locale) {
            return date.getYear();
        }
    }
    ,
    HALF_YEAR("HY", "Half-Year", "yyyy 'H'HH", "'H'HH"){

        @Override
        public LocalDateTime getNextDate(LocalDateTime begin) {
            return begin.plusMonths(6);
        }

        @Override
        public LocalDateTime transformToValidDate(LocalDateTime begin, @Nullable Locale locale) {
            int startHY = (begin.getMonthOfYear() - 1) / 6 == 0 ? 1 : 7;
            return new LocalDateTime(begin.getYear(), startHY, 1, 0, 0);
        }

        @Override
        public LocalDateTime toNextDate(LocalDateTime end) {
            return end.plusMonths(6);
        }

        @Override
        public int getRelativeId(LocalDateTime date, Locale locale) {
            return (date.getMonthOfYear() - 1) / 6 == 0 ? 0 : 1;
        }
    }
    ,
    QUARTER("Q", "Quarter", "yyyy 'Q'QQ", "'Q'QQ"){

        @Override
        public LocalDateTime getNextDate(LocalDateTime begin) {
            return begin.plusMonths(3);
        }

        @Override
        public LocalDateTime transformToValidDate(LocalDateTime begin, @Nullable Locale locale) {
            int startQuarter = begin.getMonthOfYear() - (begin.getMonthOfYear() - 1) % 3;
            return new LocalDateTime(begin.getYear(), startQuarter, 1, 0, 0);
        }

        @Override
        public LocalDateTime toNextDate(LocalDateTime end) {
            return end.plusMonths(3);
        }

        @Override
        public int getRelativeId(LocalDateTime date, Locale locale) {
            int startQuarter = date.getMonthOfYear() - (date.getMonthOfYear() - 1) % 3;
            return startQuarter;
        }
    }
    ,
    MONTH("M", "Month", "yyyy MMM", "MMM"){

        @Override
        public LocalDateTime getNextDate(LocalDateTime begin) {
            return begin.plusMonths(1);
        }

        @Override
        public LocalDateTime toNextDate(LocalDateTime end) {
            return end.plusMonths(1);
        }

        @Override
        public LocalDateTime transformToValidDate(LocalDateTime begin, @Nullable Locale locale) {
            return new LocalDateTime(begin.getYear(), begin.getMonthOfYear(), 1, 0, 0);
        }

        @Override
        public int getRelativeId(LocalDateTime date, Locale locale) {
            return date.getMonthOfYear();
        }
    }
    ,
    WEEK("W", "Week", "xxxx 'Week 'w", "'Week 'w"){

        @Override
        public LocalDateTime getNextDate(LocalDateTime begin) {
            return begin.plusDays(7);
        }

        @Override
        public LocalDateTime transformToValidDate(LocalDateTime begin, @Nullable Locale locale) {
            if (OlapLevelType.isNotDefiningCalendar(locale)) {
                return begin.withDayOfWeek(1).withMillisOfDay(0);
            }
            LocalDate firstDay = OlapLevelType.getFirstDayOfWeek(begin, locale);
            return new LocalDateTime(firstDay.getYear(), firstDay.getMonthValue(), firstDay.getDayOfMonth(), 0, 0);
        }

        @Override
        public int getRelativeId(LocalDateTime date, @Nullable Locale locale) {
            if (OlapLevelType.isNotDefiningCalendar(locale)) {
                return date.getWeekOfWeekyear();
            }
            TemporalField week = OlapLevelType.getWeekFields(locale).weekOfWeekBasedYear();
            return OlapLevelType.getFirstDayOfWeek(date, locale).get(week);
        }

        @Override
        public boolean keyUniqueInLevel() {
            return false;
        }

        private static LocalDateTime transformToISO(LocalDateTime begin) {
            int currentWeek = begin.getWeekOfWeekyear();
            LocalDateTime currentDate = begin;
            LocalDateTime prevDay;
            while (currentWeek == (prevDay = currentDate.minusDays(1)).getWeekOfWeekyear()) {
                currentDate = prevDay;
            }
            return currentDate.withMillisOfDay(0);
        }
    }
    ,
    DAY("D", "Day", "d MMM yyyy", "EEEE", "dayOfWeek"){

        @Override
        public LocalDateTime getNextDate(LocalDateTime begin) {
            return begin.plusDays(1);
        }

        @Override
        public LocalDateTime transformToValidDate(LocalDateTime begin, @Nullable Locale locale) {
            return new LocalDateTime(begin.getYear(), begin.getMonthOfYear(), begin.getDayOfMonth(), 0, 0);
        }

        @Override
        public int getRelativeId(LocalDateTime date, @Nullable Locale locale) {
            int dayOfWeek = date.getDayOfWeek();
            if (OlapLevelType.isNotDefiningCalendar(locale)) {
                return dayOfWeek;
            }
            DayOfWeek firstDayOfWeek = OlapLevelType.getWeekFields(locale).getFirstDayOfWeek();
            int weekStart = firstDayOfWeek.getValue();
            int relId = dayOfWeek - weekStart + 1;
            return dayOfWeek >= weekStart ? relId : relId + 7;
        }
    }
    ,
    DAY_MONTH("DM", "DayMonth", "d MMM yyyy", "'Day 'd", "dayOfMonth"){

        @Override
        public LocalDateTime getNextDate(LocalDateTime begin) {
            return begin.plusDays(1);
        }

        @Override
        public LocalDateTime transformToValidDate(LocalDateTime begin, @Nullable Locale locale) {
            return new LocalDateTime(begin.getYear(), begin.getMonthOfYear(), begin.getDayOfMonth(), 0, 0);
        }

        @Override
        public int getRelativeId(LocalDateTime date, Locale locale) {
            return date.getDayOfMonth();
        }
    }
    ,
    DAY_YEAR("DY", "DayYear", "d MMM yyyy", "'Day 'D", "dayOfYear"){

        @Override
        public LocalDateTime getNextDate(LocalDateTime begin) {
            return begin.plusDays(1);
        }

        @Override
        public LocalDateTime transformToValidDate(LocalDateTime begin, @Nullable Locale locale) {
            return new LocalDateTime(begin.getYear(), begin.getMonthOfYear(), begin.getDayOfMonth(), 0, 0);
        }

        @Override
        public int getRelativeId(LocalDateTime date, Locale locale) {
            return date.getDayOfYear();
        }
    }
    ,
    HOUR("H", "Hour", "H' h'", "H' h'"){

        @Override
        public LocalDateTime getNextDate(LocalDateTime begin) {
            return begin.plusHours(1);
        }

        @Override
        public LocalDateTime transformToValidDate(LocalDateTime begin, @Nullable Locale locale) {
            return new LocalDateTime(begin.getYear(), begin.getMonthOfYear(), begin.getDayOfMonth(), begin.getHourOfDay(), 0);
        }

        @Override
        public int getRelativeId(LocalDateTime date, Locale locale) {
            return date.getHourOfDay();
        }

        @Override
        public LocalDateTime toNextDate(LocalDateTime end) {
            return end.plusHours(1);
        }
    }
    ,
    HALF_HOUR("HH", "Half-Hour", "H' h' mm", "mm"){

        @Override
        public LocalDateTime getNextDate(LocalDateTime begin) {
            return begin.plusMinutes(30);
        }

        @Override
        public LocalDateTime transformToValidDate(LocalDateTime begin, @Nullable Locale locale) {
            int minutes = begin.getMinuteOfHour() / 30 * 30;
            return new LocalDateTime(begin.getYear(), begin.getMonthOfYear(), begin.getDayOfMonth(), begin.getHourOfDay(), minutes);
        }

        @Override
        public int getRelativeId(LocalDateTime date, Locale locale) {
            return date.getMinuteOfHour() / 30;
        }

        @Override
        public LocalDateTime toNextDate(LocalDateTime end) {
            return end.plusMinutes(30);
        }
    }
    ,
    QUARTER_HOUR("HH", "Quarter-Hour", "H' h' mm", "mm"){

        @Override
        public LocalDateTime getNextDate(LocalDateTime begin) {
            return begin.plusMinutes(15);
        }

        @Override
        public LocalDateTime transformToValidDate(LocalDateTime begin, @Nullable Locale locale) {
            int minutes = begin.getMinuteOfHour() / 15 * 15;
            return new LocalDateTime(begin.getYear(), begin.getMonthOfYear(), begin.getDayOfMonth(), begin.getHourOfDay(), minutes);
        }

        @Override
        public int getRelativeId(LocalDateTime date, Locale locale) {
            return date.getMinuteOfHour() / 15;
        }

        @Override
        public LocalDateTime toNextDate(LocalDateTime end) {
            return end.plusMinutes(15);
        }
    }
    ,
    MINUTE("MM", "Minute", "H' h' mm", "mm"){

        @Override
        public LocalDateTime getNextDate(LocalDateTime begin) {
            return begin.plusMinutes(1);
        }

        @Override
        public LocalDateTime transformToValidDate(LocalDateTime begin, @Nullable Locale locale) {
            return new LocalDateTime(begin.getYear(), begin.getMonthOfYear(), begin.getDayOfMonth(), begin.getHourOfDay(), begin.getMinuteOfHour());
        }

        @Override
        public int getRelativeId(LocalDateTime date, Locale locale) {
            return date.getMinuteOfHour();
        }

        @Override
        public LocalDateTime toNextDate(LocalDateTime end) {
            return end.plusMinutes(1);
        }
    }
    ,
    SECOND("S", "Second", "H' h' mm:ss", "ss"){

        @Override
        public LocalDateTime getNextDate(LocalDateTime begin) {
            return begin.plusSeconds(1);
        }

        @Override
        public LocalDateTime transformToValidDate(LocalDateTime begin, @Nullable Locale locale) {
            return new LocalDateTime(begin.getYear(), begin.getMonthOfYear(), begin.getDayOfMonth(), begin.getHourOfDay(), begin.getMinuteOfHour(), begin.getSecondOfMinute());
        }

        @Override
        public int getRelativeId(LocalDateTime date, Locale locale) {
            return date.getSecondOfMinute();
        }

        @Override
        public LocalDateTime toNextDate(LocalDateTime end) {
            return end.plusSeconds(1);
        }
    };

    private static HashMap<String, OlapLevelType> shortNames;
    private final String shortName;
    private final String name;
    private final String defaultNameFormat;
    private final String absoluteDefaultNameFormat;
    @Nullable
    private final String timeDivisionName;
    static final String PATTERN_SUFFIX = "(?=(?:[^']*(')[^']*\\1)*[^']*$)";
    static final Pattern PATTERN_HH;
    static final Pattern PATTERN_QQ;
    static final Pattern PATTERN_ww;
    static final Pattern PATTERN_w;
    static final Pattern PATTERN_xxxx;
    static final Pattern PATTERN_xx;

    private OlapLevelType(String shortName, String name, String defaultNameFormat, String absoluteDefaultNameFormat) {
        this(shortName, name, defaultNameFormat, absoluteDefaultNameFormat, null);
    }

    private OlapLevelType(String shortName, String name, String defaultNameFormat, String absoluteDefaultNameFormat, String timeDivisionName) {
        this.shortName = shortName;
        this.name = name;
        this.defaultNameFormat = defaultNameFormat;
        this.absoluteDefaultNameFormat = absoluteDefaultNameFormat;
        this.timeDivisionName = timeDivisionName;
    }

    private static boolean isNotDefiningCalendar(@Nullable Locale locale) {
        return locale == null || locale.getCountry().isEmpty();
    }

    private static WeekFields getWeekFields(@Nullable Locale locale) {
        return WeekFields.of(locale == null ? Locale.getDefault() : locale);
    }

    @Nullable
    public static OlapLevelType parseShortName(String shortName) {
        if (shortNames == null) {
            OlapLevelType.initialize(shortName);
        }
        return shortNames.get(shortName);
    }

    public static synchronized void initialize(String shortName) {
        HashMap<String, OlapLevelType> map = new HashMap<String, OlapLevelType>();
        for (OlapLevelType type : OlapLevelType.values()) {
            map.put(type.shortName, type);
        }
        shortNames = map;
    }

    public String getName() {
        return this.name;
    }

    public String getMemberNameDefaultFormat(boolean absoluteNameFormat) {
        return absoluteNameFormat ? this.absoluteDefaultNameFormat : this.defaultNameFormat;
    }

    public String getMemberNameFor(String levelNameFormat, @Nullable Locale locale, LocalDateTime date) {
        int halfYear = 1 + date.getMonthOfYear() / 6;
        int quarter = date.getMonthOfYear() / 3 + 1;
        if (levelNameFormat.contains("HH")) {
            levelNameFormat = CdStringUtils.replaceAllNotInSimpleQuote((String)levelNameFormat, (Pattern)PATTERN_HH, (String)Integer.toString(halfYear));
        }
        if (levelNameFormat.contains("QQ")) {
            levelNameFormat = CdStringUtils.replaceAllNotInSimpleQuote((String)levelNameFormat, (Pattern)PATTERN_QQ, (String)Integer.toString(quarter));
        }
        if (!OlapLevelType.isNotDefiningCalendar(locale)) {
            if (levelNameFormat.contains("w")) {
                int w = WEEK.getRelativeId(date, locale);
                levelNameFormat = CdStringUtils.replaceAllNotInSimpleQuote((String)levelNameFormat, (Pattern)PATTERN_ww, (String)String.format("%02d", w));
                levelNameFormat = CdStringUtils.replaceAllNotInSimpleQuote((String)levelNameFormat, (Pattern)PATTERN_w, (String)Integer.toString(w));
            }
            if (levelNameFormat.contains("x")) {
                int weekYear = OlapLevelType.getAsJavaLocalDate(date).get(WeekFields.of(locale).weekBasedYear());
                levelNameFormat = CdStringUtils.replaceAllNotInSimpleQuote((String)levelNameFormat, (Pattern)PATTERN_xxxx, (String)Integer.toString(weekYear));
                levelNameFormat = CdStringUtils.replaceAllNotInSimpleQuote((String)levelNameFormat, (Pattern)PATTERN_xx, (String)String.format("%02d", weekYear % 100));
            }
        }
        DateTimeFormatter format = DateTimeFormat.forPattern((String)levelNameFormat).withLocale(locale);
        return format.print((ReadablePartial)date);
    }

    public abstract LocalDateTime getNextDate(LocalDateTime var1);

    public abstract LocalDateTime transformToValidDate(LocalDateTime var1, @Nullable Locale var2);

    public boolean isBefore(OlapLevelType levelType) {
        return this.ordinal() < levelType.ordinal();
    }

    public abstract int getRelativeId(LocalDateTime var1, @Nullable Locale var2);

    @NotNull
    private static LocalDate getFirstDayOfWeek(LocalDateTime begin, @Nullable Locale locale) {
        LocalDate asJavaLocalDate = OlapLevelType.getAsJavaLocalDate(begin);
        DayOfWeek firstDayOfWeek = OlapLevelType.getWeekFields(locale).getFirstDayOfWeek();
        LocalDate asFirstDayOfWeek = asJavaLocalDate.with(TemporalAdjusters.previousOrSame(firstDayOfWeek));
        return asFirstDayOfWeek;
    }

    @NotNull
    private static LocalDate getAsJavaLocalDate(LocalDateTime begin) {
        return LocalDate.of(begin.getYear(), begin.getMonthOfYear(), begin.getDayOfMonth());
    }

    public boolean hasTimeInformation() {
        return this == HOUR || this == HALF_HOUR || this == MINUTE || this == SECOND;
    }

    public boolean keyUniqueInLevel() {
        return true;
    }

    public LocalDateTime toNextDate(LocalDateTime end) {
        return end.plusDays(1);
    }

    @Nullable
    public String getTimeDivisionName() {
        return this.timeDivisionName;
    }

    public static List<OlapLevelType> parseList(String enums, String separator) {
        if (enums == null) {
            return Collections.emptyList();
        }
        String[] enumAr = enums.trim().split(" ");
        return Arrays.stream(enumAr).map(str -> {
            OlapLevelType level = OlapLevelType.parseShortName(str);
            if (level == null) {
                throw new RuntimeException((String)str);
            }
            return level;
        }).collect(Collectors.toList());
    }

    static {
        shortNames = null;
        PATTERN_HH = Pattern.compile("HH(?=(?:[^']*(')[^']*\\1)*[^']*$)");
        PATTERN_QQ = Pattern.compile("QQ(?=(?:[^']*(')[^']*\\1)*[^']*$)");
        PATTERN_ww = Pattern.compile("ww(?=(?:[^']*(')[^']*\\1)*[^']*$)");
        PATTERN_w = Pattern.compile("w(?=(?:[^']*(')[^']*\\1)*[^']*$)");
        PATTERN_xxxx = Pattern.compile("xxxx(?=(?:[^']*(')[^']*\\1)*[^']*$)");
        PATTERN_xx = Pattern.compile("xx(?=(?:[^']*(')[^']*\\1)*[^']*$)");
    }
}

