/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.enums;

import jakarta.xml.bind.annotation.XmlEnum;

@XmlEnum
public enum OlapAggregationType {
    SUM("sum", false, true),
    SUM_HIGH_PRECISION("sum (high precision)", false, true),
    SUM_CHILDREN("average (children)", true, false),
    SUM_SQUARE("sum square", false, true),
    MIN("min", false, true),
    MAX("max", false, true),
    AVG_CHILDREN("average (children)", true, false),
    AVG_LEAVES("average (leaves)", false, true),
    COUNT("count", false, true),
    DISTINCT_COUNT("distinct count", false, false),
    OPEN("open", true, false),
    CLOSE("close", true, false),
    OPEN_NO_EMPTY("open (non-empty)", true, false),
    CLOSE_NO_EMPTY("close (non-empty)", true, false),
    NO_EMPTY("no-empty", false, false),
    NO_EMPTY_ROWS("no-empty-rows", false, false),
    VECTOR("vector", false, true),
    VECTOR_SORTED("vector (sorted)", false, true),
    VECTOR_UNIQUE("vector unique", false, true),
    VECTOR_ROW_NUMBER("vector row numbers", false, true),
    TABLE_ROW_NUMBER("table row numbers", false, true),
    UNARY_OPERATOR("unary-operator", true, false),
    NONE("none", false, false);

    private final String friendlyName;
    private final boolean rollupHierarchyRequired;
    private final boolean multiTupleSupported;

    private OlapAggregationType(String friendlyName, boolean rollupHierarchyRequired, boolean multiTupleSupported) {
        this.friendlyName = friendlyName;
        this.rollupHierarchyRequired = rollupHierarchyRequired;
        this.multiTupleSupported = multiTupleSupported;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public boolean isRollupHierarchyRequired() {
        return this.rollupHierarchyRequired;
    }

    public boolean isMultiTupleSupported() {
        return this.multiTupleSupported;
    }

    public boolean useNoEmptyAggregation() {
        switch (this.ordinal()) {
            case 10: 
            case 11: 
            case 14: {
                return false;
            }
        }
        return true;
    }

    public boolean supportsEmptyToZero() {
        switch (this.ordinal()) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 21: {
                return true;
            }
        }
        return false;
    }

    public boolean outputScalarTypeIsDouble(boolean dataIsDouble) {
        switch (this.ordinal()) {
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                return false;
            }
            case 2: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return dataIsDouble;
    }

    public boolean isVector() {
        return this == VECTOR || this == VECTOR_SORTED || this == VECTOR_UNIQUE || this == VECTOR_ROW_NUMBER;
    }

    public boolean isAggregationForMeasureVectorSupported() {
        return this != NONE && this != VECTOR_ROW_NUMBER && this != TABLE_ROW_NUMBER;
    }

    public boolean supportsArrayFactColumn() {
        switch (this.ordinal()) {
            case 0: 
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return true;
            }
        }
        return false;
    }

    public boolean isSum() {
        return this == SUM || this == SUM_HIGH_PRECISION;
    }
}

