/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.directories;

import crazydev.common.configuration.CdConfigurationUtils;
import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.fs.CdVFileSystem;
import crazydev.iccube.configuration.OlapConfigurationErrorCode;
import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.olap.loggers.OlapLoggers;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;

public abstract class OlapDirectoryConfiguration {
    @XmlAttribute(name="value", required=true)
    private String value;
    @XmlTransient
    private File asFile;
    @XmlTransient
    private boolean created;
    @XmlTransient
    private boolean asMdxQueriesForMigration;

    protected OlapDirectoryConfiguration() {
    }

    protected OlapDirectoryConfiguration(String value) {
        this.value = value;
    }

    public String getFullName() {
        return "icCube.directories." + this.getName();
    }

    public abstract String getName();

    public String getValue() {
        return this.value;
    }

    public boolean isJcr() {
        return false;
    }

    public boolean wasCreated() {
        return this.created;
    }

    public void setAsMdxQueriesForMigration() {
        this.asMdxQueriesForMigration = true;
    }

    public void validate(CdVFileSystem vfs, boolean overridden) throws OlapConfigurationException {
        if (this.value == null) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{this.getName() + ":value"});
        }
        String xvalue = CdConfigurationUtils.substVars((String)this.value);
        File file = new File(xvalue);
        OlapLoggers.SERVER.debug((Object)("[directory] validating [" + System.identityHashCode(this) + "] [" + this.value + "][" + xvalue + "][" + file.getAbsolutePath() + "][existing:" + file.exists() + "]"));
        if (this.asMdxQueriesForMigration) {
            this.asFile = file;
            this.created = false;
            OlapLoggers.SERVER.debug((Object)("[directory] validating [" + System.identityHashCode(this) + "] [" + file.getAbsolutePath() + "] [asMdxQueriesForMigration:" + this.asMdxQueriesForMigration + "]"));
            return;
        }
        if (file.exists() && !file.isDirectory()) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.INVALID_DIRECTORY, new Serializable[]{this.getName(), this.value, file.getAbsolutePath()});
        }
        if (!file.exists()) {
            OlapLoggers.SERVER.debug((Object)("[directory] validating [" + System.identityHashCode(this) + "] [" + file.getAbsolutePath() + "] not existing"));
            if (!this.isJcr()) {
                try {
                    boolean c = vfs.validateDirectoryOnStartup(file);
                    this.asFile = file;
                    this.created = c;
                }
                catch (IOException ex) {
                    throw new OlapConfigurationException((Throwable)ex, OlapConfigurationErrorCode.INVALID_DIRECTORY, new Serializable[]{this.getName(), this.value, file.getAbsolutePath()});
                }
            } else {
                this.asFile = file;
                this.created = false;
            }
        } else if (overridden) {
            OlapLoggers.SERVER.debug((Object)("[directory] validating [" + System.identityHashCode(this) + "] [" + file.getAbsolutePath() + "] overridden"));
            this.asFile = file;
            File[] files = this.asFile.listFiles();
            if (files == null || files.length == 0) {
                this.created = true;
            }
        } else {
            OlapLoggers.SERVER.debug((Object)("[directory] validating [" + System.identityHashCode(this) + "] [" + file.getAbsolutePath() + "] nop"));
            this.asFile = file;
        }
        OlapLoggers.SERVER.debug((Object)("[directory] validated [" + System.identityHashCode(this) + "] [" + file.getAbsolutePath() + "][created:" + this.created + "]"));
    }

    public File asFile() {
        if (this.asFile == null) {
            throw new CdProgrammingException(this.getName() + ":value - not validated!");
        }
        return this.asFile;
    }
}

