/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.directories;

import crazydev.common.fs.CdVFileSystem;
import crazydev.iccube.configuration.OlapConfigurationErrorCode;
import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.directories.OlapDirectoryConfiguration;
import crazydev.iccube.directories.impl.OlapAuditDirectoryConfiguration;
import crazydev.iccube.directories.impl.OlapBackupDirectoryConfiguration;
import crazydev.iccube.directories.impl.OlapBuilderDirectoryConfiguration;
import crazydev.iccube.directories.impl.OlapCubesDirectoryConfiguration;
import crazydev.iccube.directories.impl.OlapDataDirectoryConfiguration;
import crazydev.iccube.directories.impl.OlapDocsRepositoryDirectoryConfiguration;
import crazydev.iccube.directories.impl.OlapMultiTenantDirectoryConfiguration;
import crazydev.iccube.directories.impl.OlapOAuth2DirectoryConfiguration;
import crazydev.iccube.directories.impl.OlapOfflineDirectoryConfiguration;
import crazydev.iccube.directories.impl.OlapPluginsDirectoryConfiguration;
import crazydev.iccube.directories.impl.OlapRepositoryDirectoryConfiguration;
import crazydev.iccube.directories.impl.OlapRolesDirectoryConfiguration;
import crazydev.iccube.directories.impl.OlapSchedulerDirectoryConfiguration;
import crazydev.iccube.directories.impl.OlapSchemaDataDirectoryConfiguration;
import crazydev.iccube.directories.impl.OlapTenantsDirectoryConfiguration;
import crazydev.iccube.directories.impl.OlapTmpDirectoryConfiguration;
import crazydev.iccube.directories.impl.OlapUsersDirectoryConfiguration;
import crazydev.iccube.directories.impl.OlapWebPubDirectoryConfiguration;
import crazydev.iccube.runtime.OlapRuntime;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="directories")
public class OlapDirectoriesConfiguration {
    @XmlElement(name="dataDirectory", required=true)
    private OlapDataDirectoryConfiguration dataDirectory;
    @XmlElement(name="tmpDirectory", required=true)
    private OlapTmpDirectoryConfiguration tmpDirectory;
    @XmlElement(name="pluginsDirectory", required=false)
    private OlapPluginsDirectoryConfiguration _pluginsDirectory;
    @XmlElement(name="cubesDirectory", required=true)
    private OlapCubesDirectoryConfiguration cubesDirectory;
    @XmlElement(name="auditDirectory", required=false)
    private OlapAuditDirectoryConfiguration auditDirectory;
    @XmlElement(name="schemaDataDirectory", required=true)
    private OlapSchemaDataDirectoryConfiguration schemaDataDirectory;
    @XmlElement(name="offlineDirectory", required=true)
    private OlapOfflineDirectoryConfiguration offlineDirectory;
    @XmlElement(name="builderDirectory", required=true)
    private OlapBuilderDirectoryConfiguration builderDirectory;
    @XmlElement(name="oauth2Directory", required=false)
    private OlapOAuth2DirectoryConfiguration oauth2Directory;
    @XmlElement(name="rolesDirectory", required=true)
    private OlapRolesDirectoryConfiguration rolesDirectory;
    @XmlElement(name="usersDirectory", required=true)
    private OlapUsersDirectoryConfiguration usersDirectory;
    @XmlElement(name="tenantsDirectory", required=false)
    @Nullable
    private OlapTenantsDirectoryConfiguration tenantsDirectory;
    @XmlElement(name="webPubDirectory", required=true)
    private OlapWebPubDirectoryConfiguration webPubDirectory;
    @XmlElement(name="repositoryDirectory", required=false)
    @Nullable
    private OlapRepositoryDirectoryConfiguration repositoryDirectory;
    @XmlElement(name="docsRepositoryDirectory", required=true)
    private OlapDocsRepositoryDirectoryConfiguration docsRepositoryDirectory;
    @XmlElement(name="schedulerDirectory", required=true)
    private OlapSchedulerDirectoryConfiguration schedulerDirectory;
    @XmlElement(name="backupDirectory", required=true)
    private OlapBackupDirectoryConfiguration backupDirectory;
    @XmlElement(name="multiTenantDirectory", required=false)
    @Nullable
    private OlapMultiTenantDirectoryConfiguration multiTenantDirectory;
    @XmlTransient
    private boolean preValidated;

    public void validate(OlapRuntime runtime, boolean withMultiTenant) throws OlapConfigurationException {
        CdVFileSystem vfs = runtime.getVfs();
        boolean overridden = this.onPreValidation(runtime);
        this.doValidate(vfs, overridden, "dataDirectory", this.dataDirectory);
        this.doValidate(vfs, overridden, "tmpDirectory", this.tmpDirectory);
        this.doValidate(vfs, overridden, "cubesDirectory", this.cubesDirectory);
        if (this.auditDirectory == null) {
            File auditFile = new File(this.dataDirectory.asFile(), "audit");
            String auditPath = auditFile.getAbsolutePath();
            this.auditDirectory = new OlapAuditDirectoryConfiguration(auditPath);
        }
        this.doValidate(vfs, overridden, "auditDirectory", this.auditDirectory);
        this.doValidate(vfs, overridden, "schemaDataDirectory", this.schemaDataDirectory);
        this.doValidate(vfs, overridden, "offlineDirectory", this.offlineDirectory);
        this.doValidate(vfs, overridden, "builderDirectory", this.builderDirectory);
        if (this.oauth2Directory == null) {
            File oauth2File = new File(this.dataDirectory.asFile(), "oauth2");
            String oauth2Path = oauth2File.getAbsolutePath();
            this.oauth2Directory = new OlapOAuth2DirectoryConfiguration(oauth2Path);
        }
        this.doValidate(vfs, overridden, "oauth2Directory", this.oauth2Directory);
        this.doValidate(vfs, overridden, "rolesDirectory", this.rolesDirectory);
        this.doValidate(vfs, overridden, "usersDirectory", this.usersDirectory);
        this.doValidate(vfs, overridden, "webPubDirectory", this.webPubDirectory);
        this.doValidate(vfs, overridden, "docsRepositoryDirectory", this.docsRepositoryDirectory);
        this.doValidate(vfs, overridden, "schedulerDirectory", this.schedulerDirectory);
        this.doValidate(vfs, overridden, "backupDirectory", this.backupDirectory);
        if (withMultiTenant) {
            this.doValidate(vfs, overridden, "tenantsDirectory", this.tenantsDirectory);
            this.doValidate(vfs, overridden, "multiTenantDirectory", this.multiTenantDirectory);
        }
    }

    private void doValidate(CdVFileSystem vfs, boolean overridden, String xmlTagName, OlapDirectoryConfiguration directory) throws OlapConfigurationException {
        if (directory == null) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{xmlTagName});
        }
        directory.validate(vfs, overridden);
        File file = directory.asFile();
        String path = file.getAbsolutePath();
        Properties props = System.getProperties();
        props.setProperty("icCube.directories." + xmlTagName, path);
    }

    private boolean onPreValidation(OlapRuntime runtime) throws OlapConfigurationException {
        if (this.preValidated) {
            return false;
        }
        String dataDirectory = runtime.getDataDirectory();
        if (dataDirectory != null) {
            this.overrideForDevelopment(dataDirectory, dataDirectory + "/tmp", dataDirectory + "/cubes", dataDirectory + "/audit", dataDirectory + "/schemaData", dataDirectory + "/offline", dataDirectory + "/builder", dataDirectory + "/oauth2", dataDirectory + "/roles", dataDirectory + "/users", this.tenantsDirectory != null ? dataDirectory + "/tenants" : null, dataDirectory + "/webPub", dataDirectory + "/docsRepository", dataDirectory + "/scheduler", dataDirectory + "/backup", this.multiTenantDirectory != null ? dataDirectory + "/tenantsData" : null);
        }
        this.preValidated = true;
        return dataDirectory != null;
    }

    private void overrideForDevelopment(String dataDirectory, String tmpDirectory, String cubesDirectory, String auditDirectory, String schemaDataDirectory, String offlineDirectory, String builderDirectory, String oauth2Directory, String rolesDirectory, String usersDirectory, @Nullable String tenantsDirectory, String webPubDirectory, String docsRepositoryDirectory, String schedulerDirectory, String backupDirectory, @Nullable String multiTenantDirectory) {
        this.dataDirectory = new OlapDataDirectoryConfiguration(dataDirectory);
        this.tmpDirectory = new OlapTmpDirectoryConfiguration(tmpDirectory);
        this.cubesDirectory = new OlapCubesDirectoryConfiguration(cubesDirectory);
        this.auditDirectory = new OlapAuditDirectoryConfiguration(auditDirectory);
        this.schemaDataDirectory = new OlapSchemaDataDirectoryConfiguration(schemaDataDirectory);
        this.offlineDirectory = new OlapOfflineDirectoryConfiguration(offlineDirectory);
        this.builderDirectory = new OlapBuilderDirectoryConfiguration(builderDirectory);
        this.oauth2Directory = new OlapOAuth2DirectoryConfiguration(oauth2Directory);
        this.rolesDirectory = new OlapRolesDirectoryConfiguration(rolesDirectory);
        this.usersDirectory = new OlapUsersDirectoryConfiguration(usersDirectory);
        this.tenantsDirectory = tenantsDirectory != null ? new OlapTenantsDirectoryConfiguration(tenantsDirectory) : null;
        this.webPubDirectory = new OlapWebPubDirectoryConfiguration(webPubDirectory);
        this.docsRepositoryDirectory = new OlapDocsRepositoryDirectoryConfiguration(docsRepositoryDirectory);
        this.schedulerDirectory = new OlapSchedulerDirectoryConfiguration(schedulerDirectory);
        this.backupDirectory = new OlapBackupDirectoryConfiguration(backupDirectory);
        this.multiTenantDirectory = multiTenantDirectory != null ? new OlapMultiTenantDirectoryConfiguration(multiTenantDirectory) : null;
    }

    public OlapDataDirectoryConfiguration getDataDirectory() {
        return this.dataDirectory;
    }

    public OlapTmpDirectoryConfiguration getTmpDirectory() {
        return this.tmpDirectory;
    }

    public OlapCubesDirectoryConfiguration getCubesDirectory() {
        return this.cubesDirectory;
    }

    public OlapAuditDirectoryConfiguration getAuditDirectory() {
        return this.auditDirectory;
    }

    public OlapSchemaDataDirectoryConfiguration getSchemaDataDirectory() {
        return this.schemaDataDirectory;
    }

    public OlapOfflineDirectoryConfiguration getOfflineDirectory() {
        return this.offlineDirectory;
    }

    public OlapBuilderDirectoryConfiguration getBuilderDirectory() {
        return this.builderDirectory;
    }

    public OlapOAuth2DirectoryConfiguration getOAuth2Directory() {
        return this.oauth2Directory;
    }

    public OlapRolesDirectoryConfiguration getRolesDirectory() {
        return this.rolesDirectory;
    }

    public OlapUsersDirectoryConfiguration getUsersDirectory() {
        return this.usersDirectory;
    }

    @Nullable
    public OlapTenantsDirectoryConfiguration getTenantsDirectory() {
        return this.tenantsDirectory;
    }

    public OlapWebPubDirectoryConfiguration getWebPubDirectory() {
        return this.webPubDirectory;
    }

    public OlapDocsRepositoryDirectoryConfiguration getDocsRepositoryDirectory() {
        return this.docsRepositoryDirectory;
    }

    public OlapSchedulerDirectoryConfiguration getSchedulerDirectory() {
        return this.schedulerDirectory;
    }

    public OlapBackupDirectoryConfiguration getBackupDirectory() {
        return this.backupDirectory;
    }

    @Nullable
    public OlapMultiTenantDirectoryConfiguration getMultiTenantDirectory() {
        return this.multiTenantDirectory;
    }
}

