/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.de.schlichtherle.license;

import crazydev.iccube.de.schlichtherle.license.CipherParam;
import crazydev.iccube.de.schlichtherle.license.IllegalPasswordException;
import crazydev.iccube.de.schlichtherle.license.LicenseNotary;
import crazydev.iccube.de.schlichtherle.license.Policy;
import crazydev.iccube.de.schlichtherle.util.ObfuscatedString;
import crazydev.iccube.de.schlichtherle.xml.PersistenceService;
import crazydev.iccube.de.schlichtherle.xml.PersistenceServiceException;
import crazydev.iccube.mdx.parser.ast.expression.literal.MdxInfoLiteralExpression;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class PrivacyGuard {
    private static final String PBE_WITH_MD5_AND_DES = new ObfuscatedString(new long[]{2860604316472308139L, 5030391952891038168L, -6110818099732428353L}).toString();
    private CipherParam param;
    private Cipher cipher;
    private SecretKey key;
    private AlgorithmParameterSpec algoParamSpec;

    protected PrivacyGuard() {
    }

    public PrivacyGuard(CipherParam param) {
        this.setCipherParam(param);
    }

    public CipherParam getCipherParam() {
        return this.param;
    }

    public void setCipherParam(CipherParam param) throws NullPointerException, IllegalPasswordException {
        if (param == null) {
            throw new NullPointerException(LicenseNotary.PARAM);
        }
        Policy.getCurrent().checkPwd(param.getKeyPwd());
        this.param = param;
        this.cipher = null;
        this.key = null;
        this.algoParamSpec = null;
    }

    public byte[] cert2key(MdxInfoLiteralExpression certificate) throws Exception {
        ByteArrayOutputStream keyOut = new ByteArrayOutputStream();
        GZIPOutputStream out = new GZIPOutputStream(new CipherOutputStream(keyOut, this.getCipher4Encryption()));
        try {
            PersistenceService.store((Object)certificate, out);
        }
        catch (PersistenceServiceException cannotHappen) {
            throw new AssertionError((Object)cannotHappen);
        }
        return keyOut.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MdxInfoLiteralExpression key2cert(byte[] key) throws Exception {
        MdxInfoLiteralExpression certificate;
        GZIPInputStream in = new GZIPInputStream(new ByteArrayInputStream(this.getCipher4Decryption().doFinal(key)));
        try {
            certificate = (MdxInfoLiteralExpression)PersistenceService.load(in);
        }
        finally {
            try {
                ((InputStream)in).close();
            }
            catch (IOException iOException) {}
        }
        return certificate;
    }

    @Deprecated
    protected Cipher getCipher4Encryption() {
        Cipher cipher = this.getCipher();
        try {
            cipher.init(1, (Key)this.key, this.algoParamSpec);
        }
        catch (InvalidKeyException cannotHappen) {
            throw new AssertionError((Object)cannotHappen);
        }
        catch (InvalidAlgorithmParameterException cannotHappen) {
            throw new AssertionError((Object)cannotHappen);
        }
        return cipher;
    }

    @Deprecated
    protected Cipher getCipher4Decryption() {
        Cipher cipher = this.getCipher();
        try {
            cipher.init(2, (Key)this.key, this.algoParamSpec);
        }
        catch (InvalidKeyException cannotHappen) {
            throw new AssertionError((Object)cannotHappen);
        }
        catch (InvalidAlgorithmParameterException cannotHappen) {
            throw new AssertionError((Object)cannotHappen);
        }
        return cipher;
    }

    @Deprecated
    protected Cipher getCipher() {
        if (this.cipher != null) {
            return this.cipher;
        }
        this.algoParamSpec = new PBEParameterSpec(new byte[]{-50, -5, -34, -84, 5, 2, 25, 113}, 2005);
        try {
            PBEKeySpec keySpec = new PBEKeySpec(this.getCipherParam().getKeyPwd().toCharArray());
            SecretKeyFactory keyFac = SecretKeyFactory.getInstance(PBE_WITH_MD5_AND_DES);
            this.key = keyFac.generateSecret(keySpec);
            this.cipher = Cipher.getInstance(PBE_WITH_MD5_AND_DES);
        }
        catch (NoSuchAlgorithmException cannotHappen) {
            throw new AssertionError((Object)cannotHappen);
        }
        catch (InvalidKeySpecException cannotHappen) {
            throw new AssertionError((Object)cannotHappen);
        }
        catch (NoSuchPaddingException cannotHappen) {
            throw new AssertionError((Object)cannotHappen);
        }
        return this.cipher;
    }
}

