/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.crac;

import java.util.logging.Logger;
import org.crac.Core;
import org.crac.Resource;

public abstract class CRaCUtils {
    public static final Logger LOG = Logger.getLogger("icCube.crac");
    private static final boolean withCRaC = ModuleLayer.boot().findModule("jdk.crac").isPresent();

    private CRaCUtils() {
    }

    public static boolean withCRaC() {
        return withCRaC;
    }

    public static void register(Resource resource, String info) {
        if (!CRaCUtils.withCRaC()) {
            return;
        }
        LOG.info("[CRaC] registration for %s".formatted(info));
        Core.getGlobalContext().register(resource);
        LOG.info("[CRaC] registration for %s completed".formatted(info));
    }
}

