/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.contextual;

import crazydev.common.exception.CdErrorCode;
import crazydev.common.exception.CdErrorLocation;
import crazydev.common.property.CdProperty;
import crazydev.iccube.contextual.IOlapContextual;
import crazydev.iccube.contextual.OlapContextualBigException;
import crazydev.iccube.contextual.OlapContextualError;
import crazydev.iccube.contextual.OlapContextualErrorException;
import crazydev.iccube.contextual.OlapContextualErrorLocation;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class OlapContextualErrorManager<CODE extends CdErrorCode, ERROR extends OlapContextualError<CODE>> {
    public static final Logger LOGGER = OlapLoggers.BUILDER;
    private final String internalFriendlyName;
    private final boolean stopOnError;
    private final List<ERROR> errors = new ArrayList<ERROR>();
    private final LinkedList<IOlapContextual> context = new LinkedList();

    public OlapContextualErrorManager(String internalFriendlyName) {
        this(internalFriendlyName, true);
    }

    public OlapContextualErrorManager(String internalFriendlyName, boolean stopOnError) {
        this.internalFriendlyName = internalFriendlyName;
        this.stopOnError = stopOnError;
    }

    public OlapContextualErrorManager(String internalFriendlyName, Iterable<IOlapContextual> context, boolean stopOnError) {
        this.internalFriendlyName = internalFriendlyName;
        this.stopOnError = stopOnError;
        for (IOlapContextual contextual : context) {
            this.context.add(contextual);
        }
    }

    public OlapContextualBigException asException() {
        return new OlapContextualBigException(this.errors);
    }

    public void addError(OlapContextualErrorManager<CODE, ERROR> errorManager) {
        for (OlapContextualError error : errorManager.errors) {
            if (this.stopOnError) {
                throw this.createErrorException(error);
            }
            this.errors.add((ERROR)((Object)error));
        }
    }

    protected abstract OlapContextualErrorException createErrorException(ERROR var1);

    public void addError(ERROR error) {
        this.addError(null, null, error);
    }

    public void addError(CdProperty property, ERROR error) {
        this.addError(property, null, error);
    }

    public void addError(CODE errorCode, Serializable ... params) {
        this.addError(this.createError(errorCode, params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addErrorWithContextual(IOlapContextual contextual, CdProperty property, CODE errorCode, Serializable[] params) {
        if (!this.pushRequired(contextual)) {
            this.addError(property, null, errorCode, params);
            return;
        }
        this.pushContext(contextual);
        try {
            this.addError(property, null, errorCode, params);
        }
        finally {
            this.popContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addErrorWithContextual(IOlapContextual contextual, CODE errorCode, Serializable ... params) {
        if (!this.pushRequired(contextual)) {
            this.addError(errorCode, params);
            return;
        }
        this.pushContext(contextual);
        try {
            this.addError(errorCode, params);
        }
        finally {
            this.popContext();
        }
    }

    public void addErrorWithContextual(IOlapContextual contextual, ERROR error) {
        if (!this.pushRequired(contextual)) {
            this.addError(error);
            return;
        }
        this.pushContext(contextual);
        try {
            this.addError(error);
        }
        finally {
            this.popContext();
        }
    }

    private boolean pushRequired(IOlapContextual contextual) {
        if (contextual == null) {
            return false;
        }
        if (this.context.isEmpty()) {
            return true;
        }
        IOlapContextual last = this.context.getLast();
        return last != contextual;
    }

    public void addError(CdProperty property, CdErrorLocation propertyLocation, CODE errorCode, Serializable ... params) {
        this.addError(property, propertyLocation, this.createError(errorCode, params));
    }

    public void addError(CdProperty property, CODE errorCode, Serializable ... params) {
        this.addError(property, null, this.createError(errorCode, params));
    }

    private void addError(CdProperty property, CdErrorLocation propertyLocation, ERROR error) {
        error.setLocation((CdErrorLocation)this.getContextPath(property, propertyLocation));
        if (this.stopOnError) {
            throw this.createErrorException(error);
        }
        this.errors.add(error);
    }

    public void addException(RuntimeException exception) {
        if (!this.hasErrors()) {
            LOGGER.error((Object)(this.internalFriendlyName + " error manager reporting a runtime exception"), (Throwable)exception);
            this.addError(this.createUnexpectedError(exception));
        }
    }

    protected abstract ERROR createError(CODE var1, Serializable[] var2);

    protected abstract ERROR createUnexpectedError(RuntimeException var1);

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public int getErrorCount() {
        return this.errors.size();
    }

    public List<ERROR> getErrors() {
        return this.errors;
    }

    public Iterable<IOlapContextual> getContext() {
        return this.context;
    }

    public void pushContext(IOlapContextual contextObject) {
        this.context.addLast(contextObject);
    }

    public void popContext() {
        this.context.removeLast();
    }

    private OlapContextualErrorLocation getContextPath(CdProperty property, CdErrorLocation propertyLocation) {
        IOlapContextual[] path = new IOlapContextual[this.context.size()];
        for (int idx = 0; idx < this.context.size(); ++idx) {
            path[idx] = this.context.get(idx);
        }
        return new OlapContextualErrorLocation(path, property, propertyLocation);
    }
}

