/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.configuration.component.properties;

import crazydev.common.lang.CdXmlaSchemaType;
import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.configuration.component.properties.OlapProperty;
import crazydev.iccube.configuration.component.properties.OlapPropertyAccessType;
import org.jetbrains.annotations.Nullable;

public abstract class OlapPropertyDescription<T> {
    private static final String PREFIX = "icCube.";
    private final String name;
    private final Class<T> type;
    private final OlapPropertyAccessType accessType;

    public OlapPropertyDescription(String name, Class<T> type) {
        this(name, type, OlapPropertyAccessType.READ_WRITE);
    }

    public OlapPropertyDescription(String name, Class<T> type, OlapPropertyAccessType accessType) {
        this.name = PREFIX + name;
        this.type = type;
        this.accessType = accessType;
    }

    public String getName() {
        return this.name;
    }

    public abstract String getInfo();

    public Class<T> getType() {
        return this.type;
    }

    public OlapPropertyAccessType getAccessType() {
        return this.accessType;
    }

    public boolean isRequired() {
        return false;
    }

    public abstract CdXmlaSchemaType getXmlaType();

    public abstract String toXmlaValueAsString(T var1);

    public OlapProperty<T> asProperty(T value) {
        return new OlapProperty<T>(this, value);
    }

    public abstract OlapProperty<T> asPropertyFromString(String var1, String var2) throws OlapConfigurationException;

    @Nullable
    public T getDefaultValue() {
        return null;
    }

    public String toString() {
        return this.name;
    }
}

