/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.configuration.component.properties;

import crazydev.iccube.configuration.component.properties.OlapPropertyAccessType;
import crazydev.iccube.configuration.component.properties.OlapPropertyDescription;

public class OlapProperty<T> {
    private final OlapPropertyDescription<T> description;
    private final T value;
    private boolean isOverridden;

    public OlapProperty(OlapPropertyDescription<T> description, T value) {
        this(description, value, false);
    }

    private OlapProperty(OlapPropertyDescription<T> description, T value, boolean isOverridden) {
        this.description = description;
        this.value = value;
        this.isOverridden = isOverridden;
    }

    public OlapProperty asOverridden() {
        return new OlapProperty<T>(this.description, this.value, true);
    }

    public String getName() {
        return this.description.getName();
    }

    public String getNameAsMdHref() {
        return this.description.getName().toLowerCase().replace(" ", "-").replace(".", "");
    }

    public OlapPropertyDescription<T> getDescription() {
        return this.description;
    }

    public boolean isReadOnly() {
        return this.description.getAccessType() == OlapPropertyAccessType.READ;
    }

    public T getValue() {
        return this.value;
    }

    public boolean isOverridden() {
        return this.isOverridden;
    }

    public String getXmlaValueAsString() {
        return this.description.toXmlaValueAsString(this.value);
    }

    public String toString() {
        return this.description.getName() + "(" + String.valueOf(this.value) + ")";
    }
}

