/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.configuration.component.properties;

import crazydev.common.lang.CdXmlaSchemaType;
import crazydev.iccube.configuration.OlapConfigurationErrorCode;
import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.configuration.component.properties.OlapMask;
import crazydev.iccube.configuration.component.properties.OlapProperty;
import crazydev.iccube.configuration.component.properties.OlapPropertyAccessType;
import crazydev.iccube.configuration.component.properties.OlapPropertyDescription;
import java.io.Serializable;

public abstract class OlapMaskPropertyDescription<T extends OlapMask<T>>
extends OlapPropertyDescription<T> {
    public OlapMaskPropertyDescription(String name, Class<T> clazz) {
        this(name, clazz, OlapPropertyAccessType.READ_WRITE);
    }

    public OlapMaskPropertyDescription(String name, Class<T> clazz, OlapPropertyAccessType accessType) {
        super(name, clazz, accessType);
    }

    @Override
    public CdXmlaSchemaType getXmlaType() {
        return CdXmlaSchemaType.DBTYPE_I4;
    }

    @Override
    public String toXmlaValueAsString(T value) {
        return String.valueOf(((OlapMask)value).mask());
    }

    @Override
    public OlapProperty<T> asPropertyFromString(String location, String value) throws OlapConfigurationException {
        try {
            Object mask = OlapMask.valueOf(this.getType(), value);
            return new OlapProperty(this, mask);
        }
        catch (IllegalArgumentException ex) {
            throw new OlapConfigurationException((Throwable)ex, location, OlapConfigurationErrorCode.PROPERTY_ON_ERROR, new Serializable[]{this.getName(), value, ex.getMessage()});
        }
    }
}

