/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.configuration.component.properties;

import crazydev.iccube.configuration.component.properties.OlapMaskHelper;

public abstract class OlapMask<T extends OlapMask<T>> {
    private final int mask;

    protected OlapMask(int mask) {
        this.mask = mask;
    }

    protected OlapMask(OlapMask<T> ... values) {
        int mask = 0;
        if (values != null) {
            for (OlapMask<T> value : values) {
                mask |= value.mask;
            }
        }
        this.mask = mask;
    }

    public static <T extends OlapMask<T>> T valueOf(Class<T> type, String value) {
        return OlapMaskHelper.valueOf(type, value);
    }

    public int mask() {
        return this.mask;
    }

    public boolean has(OlapMask<T> bit) {
        if (this.getClass() != bit.getClass()) {
            return false;
        }
        return (this.mask & bit.mask) == bit.mask;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OlapMask olapMask = (OlapMask)o;
        return this.mask == olapMask.mask;
    }

    public int hashCode() {
        return this.mask;
    }

    public String toString() {
        return OlapMaskHelper.toString(this);
    }
}

