/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.configuration.component.properties;

import crazydev.common.lang.CdXmlaSchemaType;
import crazydev.iccube.configuration.OlapConfigurationErrorCode;
import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.configuration.component.properties.OlapProperty;
import crazydev.iccube.configuration.component.properties.OlapPropertyAccessType;
import crazydev.iccube.configuration.component.properties.OlapPropertyDescription;
import java.io.Serializable;

public abstract class OlapLongPropertyDescription
extends OlapPropertyDescription<Long> {
    public OlapLongPropertyDescription(String name) {
        this(name, OlapPropertyAccessType.READ_WRITE);
    }

    public OlapLongPropertyDescription(String name, OlapPropertyAccessType accessType) {
        super(name, Long.class, accessType);
    }

    @Override
    public CdXmlaSchemaType getXmlaType() {
        return CdXmlaSchemaType.DBTYPE_I4;
    }

    @Override
    public String toXmlaValueAsString(Long value) {
        return String.valueOf(value);
    }

    @Override
    public OlapProperty<Long> asPropertyFromString(String location, String value) throws OlapConfigurationException {
        try {
            return new OlapProperty<Long>(this, Long.valueOf(value));
        }
        catch (NumberFormatException ex) {
            throw new OlapConfigurationException((Throwable)ex, location, OlapConfigurationErrorCode.PROPERTY_ON_ERROR, new Serializable[]{this.getName(), value, ex.getMessage()});
        }
    }

    public OlapProperty<Long> asPropertyFromLong(String location, Long value) {
        return new OlapProperty<Long>(this, value);
    }
}

