/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.configuration.component.properties;

import crazydev.common.lang.CdAbstractEnum;
import crazydev.common.lang.CdXmlaSchemaType;
import crazydev.iccube.configuration.OlapConfigurationErrorCode;
import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.configuration.component.properties.OlapProperty;
import crazydev.iccube.configuration.component.properties.OlapPropertyAccessType;
import crazydev.iccube.configuration.component.properties.OlapPropertyDescription;
import java.io.Serializable;

public abstract class OlapEnumPropertyDescription<T extends Enum<T>>
extends OlapPropertyDescription<T> {
    public OlapEnumPropertyDescription(String name, Class<T> type) {
        super(name, type);
    }

    public OlapEnumPropertyDescription(String name, Class<T> type, OlapPropertyAccessType accessType) {
        super(name, type, accessType);
    }

    @Override
    public CdXmlaSchemaType getXmlaType() {
        return CdXmlaSchemaType.DBTYPE_WSTR;
    }

    @Override
    public String toXmlaValueAsString(T value) {
        return ((Enum)value).name();
    }

    @Override
    public OlapProperty<T> asPropertyFromString(String location, String value) throws OlapConfigurationException {
        try {
            Object enumValue = Enum.valueOf(this.getType(), value);
            return new OlapProperty(this, enumValue);
        }
        catch (IllegalArgumentException ex) {
            try {
                Enum[] enumValues;
                int valueAsInt;
                if (value.startsWith("0x")) {
                    value = value.substring(2);
                    valueAsInt = Integer.parseInt(value, 16);
                } else {
                    valueAsInt = Integer.valueOf(value);
                }
                for (Enum enumValue : enumValues = (Enum[])this.getType().getEnumConstants()) {
                    if (!(enumValue instanceof CdAbstractEnum ? ((CdAbstractEnum)enumValue).getPosition() == valueAsInt : enumValue.ordinal() == valueAsInt)) continue;
                    return new OlapProperty<Enum>(this, enumValue);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            throw new OlapConfigurationException((Throwable)ex, location, OlapConfigurationErrorCode.PROPERTY_ON_ERROR, new Serializable[]{this.getName(), value, ex.getMessage()});
        }
    }
}

