/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.configuration.component.properties;

import crazydev.common.lang.CdXmlaSchemaType;
import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.configuration.component.properties.OlapProperty;
import crazydev.iccube.configuration.component.properties.OlapPropertyAccessType;
import crazydev.iccube.configuration.component.properties.OlapPropertyDescription;

public abstract class OlapBooleanPropertyDescription
extends OlapPropertyDescription<Boolean> {
    public OlapBooleanPropertyDescription(String name) {
        super(name, Boolean.class);
    }

    public OlapBooleanPropertyDescription(String name, OlapPropertyAccessType accessType) {
        super(name, Boolean.class, accessType);
    }

    @Override
    public CdXmlaSchemaType getXmlaType() {
        return CdXmlaSchemaType.DBTYPE_BOOL;
    }

    @Override
    public String toXmlaValueAsString(Boolean value) {
        return String.valueOf(value);
    }

    @Override
    public OlapProperty<Boolean> asPropertyFromString(String location, String value) throws OlapConfigurationException {
        return new OlapProperty<Boolean>(this, OlapBooleanPropertyDescription.toBoolean(value));
    }

    private static boolean toBoolean(String name) {
        return name.equalsIgnoreCase("true") || name.equalsIgnoreCase("yes") || name.equalsIgnoreCase("on");
    }
}

