/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.configuration.component.plugins.method;

import crazydev.iccube.configuration.OlapConfigurationErrorCode;
import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.configuration.component.plugins.OlapConfPlugin;
import crazydev.iccube.olap.eval.method.OlapModuleMethodCallInstrFactory;
import crazydev.iccube.olap.eval.method.OlapModuleMethodsRepository;
import crazydev.iccube.olap.loggers.OlapLoggers;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="olapMethods")
public class OlapConfMethodsPlugin
extends OlapConfPlugin {
    @XmlAttribute(name="moduleName", required=true)
    private String moduleName = "";
    @XmlAttribute(name="className", required=true)
    private String className;
    @XmlTransient
    private OlapModuleMethodCallInstrFactory factory;

    public String getModuleName() {
        return this.moduleName;
    }

    @Override
    public void setupAndValidate(@Nullable ClassLoader classLoader) throws OlapConfigurationException {
        try {
            Class<?> clazz = classLoader == null ? Class.forName(this.className) : classLoader.loadClass(this.className);
            this.factory = (OlapModuleMethodCallInstrFactory)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            OlapLoggers.BUILDER.error((Object)"methods plugin validation error", (Throwable)ex);
            throw new OlapConfigurationException(OlapConfigurationErrorCode.INVALID_JAVA_CLASS_NAME, new Serializable[]{this.className, ex});
        }
    }

    public OlapModuleMethodCallInstrFactory register(OlapModuleMethodsRepository repository) {
        repository.registerModule(this.factory);
        return this.factory;
    }
}

