/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.configuration.component.plugins.intializer;

import crazydev.iccube.configuration.OlapConfigurationErrorCode;
import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.configuration.component.plugins.OlapConfPlugin;
import crazydev.iccube.olap.loggers.OlapLoggers;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="initialization")
public class OlapConfInitializerPlugin
extends OlapConfPlugin {
    @XmlAttribute(name="className", required=true)
    private String className;

    public OlapConfInitializerPlugin() {
    }

    public OlapConfInitializerPlugin(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    @Override
    public void setupAndValidate(@Nullable ClassLoader classLoader) throws OlapConfigurationException {
        if (this.className == null || this.className.trim().isEmpty()) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.INVALID_JAVA_CLASS_NAME, new Serializable[]{"missing"});
        }
        try {
            Class<?> clazz = classLoader == null ? Class.forName(this.className) : classLoader.loadClass(this.className);
            Method method = clazz.getDeclaredMethod("init", new Class[0]);
            method.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException ex) {
            OlapLoggers.BUILDER.error((Object)"initialization plugin validation error", (Throwable)ex);
            throw new OlapConfigurationException(OlapConfigurationErrorCode.INVALID_JAVA_CLASS_NAME, new Serializable[]{this.className, ex});
        }
        catch (NoSuchMethodException ex) {
            OlapLoggers.BUILDER.error((Object)"initialization plugin validation error", (Throwable)ex);
            throw new OlapConfigurationException(OlapConfigurationErrorCode.MISSING_INIT_METHOD, new Serializable[]{this.className, ex});
        }
        catch (InvocationTargetException ex) {
            OlapLoggers.BUILDER.error((Object)"initialization plugin validation error", (Throwable)ex);
            throw new OlapConfigurationException(OlapConfigurationErrorCode.INIT_METHOD_ERROR, new Serializable[]{this.className, ex});
        }
        catch (IllegalAccessException ex) {
            OlapLoggers.BUILDER.error((Object)"initialization plugin validation error", (Throwable)ex);
            throw new OlapConfigurationException(OlapConfigurationErrorCode.INIT_METHOD_ERROR, new Serializable[]{this.className, ex});
        }
    }
}

