/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.configuration.component.plugins.function;

import crazydev.iccube.configuration.OlapConfigurationErrorCode;
import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.configuration.component.plugins.function.OlapConfFunctionPlugin;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.function.OlapFunctionRepository;
import crazydev.iccube.olap.loggers.OlapLoggers;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="olapFunction")
public class OlapConfOlapFunctionPlugin
extends OlapConfFunctionPlugin {
    @XmlAttribute(name="className", required=true)
    private String className;
    @XmlAttribute(name="overwriteExisting")
    private boolean overwriteExisting;
    @XmlTransient
    private OlapFunction olapFunction;

    public OlapConfOlapFunctionPlugin() {
    }

    public OlapConfOlapFunctionPlugin(String className, boolean overwriteExisting) {
        this.className = className;
        this.overwriteExisting = overwriteExisting;
    }

    @Override
    public void setupAndValidate(@Nullable ClassLoader classLoader) throws OlapConfigurationException {
        Class<?> function;
        try {
            function = classLoader == null ? Class.forName(this.className) : classLoader.loadClass(this.className);
        }
        catch (ClassNotFoundException ex) {
            OlapLoggers.BUILDER.error((Object)"MDX function plugin validation error", (Throwable)ex);
            throw new OlapConfigurationException(OlapConfigurationErrorCode.INVALID_JAVA_CLASS_NAME, new Serializable[]{this.className, ex});
        }
        if (!OlapFunction.class.isAssignableFrom(function)) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.CLASS_NOT_EXTENDING_OTHER_CLASS, new Serializable[]{this.className, OlapFunction.class.getName()});
        }
        try {
            this.olapFunction = (OlapFunction)function.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            OlapLoggers.BUILDER.error((Object)"MDX function plugin validation error", (Throwable)ex);
            throw new OlapConfigurationException(OlapConfigurationErrorCode.CLASS_FAILED_ON_EMPTY_CONSTRUCTOR, new Serializable[]{this.className, ex});
        }
        catch (IllegalAccessException ex) {
            OlapLoggers.BUILDER.error((Object)"MDX function plugin validation error", (Throwable)ex);
            throw new OlapConfigurationException(OlapConfigurationErrorCode.CLASS_CONSTRUCTOR_ILLEGAL_ACCESS, new Serializable[]{this.className, ex});
        }
    }

    @Override
    public List<OlapFunction> register(OlapFunctionRepository repository) throws OlapConfigurationException {
        ArrayList<OlapFunction> functions = new ArrayList<OlapFunction>();
        repository.registerStandardFunction(this.olapFunction, this.overwriteExisting, true);
        functions.add(this.olapFunction);
        return functions;
    }

    public String getClassName() {
        return this.className;
    }

    public boolean isOverwriteExisting() {
        return this.overwriteExisting;
    }
}

