/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.configuration.component.plugins;

import crazydev.iccube.configuration.component.plugins.builder.OlapConfBuilderPlugin;
import crazydev.iccube.configuration.component.plugins.function.OlapConfFunctionPlugin;
import crazydev.iccube.configuration.component.plugins.function.OlapConfJavaFunctionsPlugin;
import crazydev.iccube.configuration.component.plugins.function.OlapConfJavaTableAgrregatorPlugin;
import crazydev.iccube.configuration.component.plugins.function.OlapConfOlapFunctionPlugin;
import crazydev.iccube.configuration.component.plugins.function.OlapConfOlapStatFunctionPlugin;
import crazydev.iccube.configuration.component.plugins.intializer.OlapConfAuthenticationServicePlugin;
import crazydev.iccube.configuration.component.plugins.intializer.OlapConfInitializerPlugin;
import crazydev.iccube.configuration.component.plugins.localization.OlapConfLocalizationPlugin;
import crazydev.iccube.configuration.component.plugins.method.OlapConfMethodsPlugin;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlElementRefs;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import java.util.jar.JarFile;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="plugins")
public class OlapConfPluginContainer {
    public static final String PLUGIN_CONTAINER_ENCODING = "UTF-8";
    @XmlElement(name="name")
    private String name;
    @XmlElementRefs(value={@XmlElementRef(type=OlapConfOlapFunctionPlugin.class), @XmlElementRef(type=OlapConfOlapStatFunctionPlugin.class), @XmlElementRef(type=OlapConfJavaFunctionsPlugin.class)})
    private List<OlapConfFunctionPlugin> functions;
    @XmlElementRefs(value={@XmlElementRef(type=OlapConfMethodsPlugin.class)})
    private List<OlapConfMethodsPlugin> methods;
    @XmlElementRef(type=OlapConfJavaTableAgrregatorPlugin.class)
    private List<OlapConfJavaTableAgrregatorPlugin> tableAggregator;
    @XmlElement(name="builder")
    private List<OlapConfBuilderPlugin> builders;
    @XmlElement(name="localization")
    private List<OlapConfLocalizationPlugin> localizations;
    @XmlElement(name="initialization")
    private OlapConfInitializerPlugin initialization;
    @XmlElement(name="authenticationService")
    private OlapConfAuthenticationServicePlugin authenticationService;
    @XmlTransient
    private File location;

    public String getName() {
        return this.name;
    }

    public List<OlapConfFunctionPlugin> getFunctions() {
        return this.functions == null ? Collections.emptyList() : this.functions;
    }

    public List<OlapConfJavaTableAgrregatorPlugin> getTableAggregator() {
        return this.tableAggregator == null ? Collections.emptyList() : this.tableAggregator;
    }

    public List<OlapConfMethodsPlugin> getMethods() {
        return this.methods == null ? Collections.emptyList() : this.methods;
    }

    public List<OlapConfBuilderPlugin> getBuilders() {
        return this.builders == null ? Collections.emptyList() : this.builders;
    }

    public List<OlapConfLocalizationPlugin> getLocalizations() {
        return this.localizations == null ? Collections.emptyList() : this.localizations;
    }

    @Nullable
    public OlapConfInitializerPlugin getInitialization() {
        return this.initialization;
    }

    @Nullable
    public OlapConfAuthenticationServicePlugin getAuthenticationService() {
        return this.authenticationService;
    }

    public File getLocation() {
        return this.location;
    }

    public void setLocation(File location) {
        this.location = location;
    }

    public static Reader getLocationReader(File location) throws IOException {
        if (location.isDirectory()) {
            File pluginFile = new File(location, "META-INF/plugin.xml");
            FileInputStream stream = new FileInputStream(pluginFile);
            return new InputStreamReader((InputStream)stream, PLUGIN_CONTAINER_ENCODING);
        }
        JarFile pluginJar = new JarFile(location);
        InputStream inputStream = pluginJar.getInputStream(pluginJar.getEntry("META-INF/plugin.xml"));
        return new InputStreamReader(inputStream, PLUGIN_CONTAINER_ENCODING);
    }
}

