/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.configuration.component;

import crazydev.common.configuration.CdConfigurationUtils;
import crazydev.iccube.configuration.OlapConfigurationErrorCode;
import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.pub.common.IOlapServiceConfiguration;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="cachingPolicy")
public class OlapEngineResultCachePolicyConfiguration {
    @XmlElement(name="classname", required=true)
    private String clazz;
    @XmlElement(name="param", required=false)
    private List<Param> params;

    public OlapEngineResultCachePolicyConfiguration() {
    }

    public OlapEngineResultCachePolicyConfiguration(String clazz, @Nullable List<Param> params) {
        this.clazz = clazz;
        this.params = params;
    }

    public void validate() throws OlapConfigurationException {
        if (this.clazz == null || this.clazz.trim().isEmpty()) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"Result cache caching policy service : classname"});
        }
        if (this.params != null) {
            for (Param param : this.params) {
                param.value = CdConfigurationUtils.substVars((String)param.value);
            }
        }
    }

    public String getClazz() {
        return this.clazz.trim();
    }

    public List<Param> getParams() {
        return this.params == null ? Collections.emptyList() : this.params;
    }

    public IOlapServiceConfiguration createServiceConfiguration() {
        return new IOlapServiceConfiguration(this){
            final /* synthetic */ OlapEngineResultCachePolicyConfiguration this$0;
            {
                OlapEngineResultCachePolicyConfiguration olapEngineResultCachePolicyConfiguration = this$0;
                Objects.requireNonNull(olapEngineResultCachePolicyConfiguration);
                this.this$0 = olapEngineResultCachePolicyConfiguration;
            }

            @Override
            public List<String> getConfigurationProperties() {
                ArrayList<String> names = new ArrayList<String>();
                for (Param param : this.this$0.getParams()) {
                    names.add(param.getName());
                }
                return names;
            }

            @Override
            @Nullable
            public String getConfigurationProperty(String name) {
                for (Param param : this.this$0.getParams()) {
                    if (param.name == null || !param.name.equals(name)) continue;
                    return param.value;
                }
                return null;
            }
        };
    }

    @XmlType(name="paramType", namespace="icCubeResultCache")
    @XmlRootElement(name="param")
    public static class Param {
        @XmlElement(name="name", required=true)
        private String name;
        @XmlElement(name="value", required=true)
        private String value;

        public Param() {
        }

        public Param(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

